/* -*- Mode: C; c-basic-offset: 8; indent-tabs-mode: nil -*- */
/* vim: set filetype=c tabstop=8 shiftwidth=4 expandtab: */

#ifdef ECL_CMU_FORMAT
# define ECL_NAME_PPRINT(x) ECL_NAME(x)
#else
# define ECL_NAME_PPRINT(x) NULL
#endif
#ifdef ECL_FINAL
# define ECL_NAME(x) x
#else
# define ECL_NAME(x) NULL
#endif
#ifdef DPP
#define CLOS_ "CLOS::"
#define EXT_ "EXT::"
#define SYS_ "SI::"
#define MP_ "MP::"
#define KEY_ ":"
#define GRAY_ "GRAY::"
#define FFI_ "FFI::"
typedef struct {
        const char *name, *translation;
        /* narg >= 0: function takes exactly narg arguments */
        /* narg < 0: function takes -narg-1 required arguments */
        int narg;
} cl_symbol_initializer;
#else
#include "ecl_constants.h"
#define CLOS_
#define EXT_
#define SYS_
#define MP_
#define KEY_
#define GRAY_
#define FFI_
#endif
/*
 * Conditional addition of functions and symbols. The list of symbols can
 * not depend on the features, because otherwise the sources will and we will
 * not be able to cross-compile.
 */
#ifdef ECL_THREADS
# define IF_MP(x) x
#else
# define IF_MP(x) NULL
#endif
#ifdef TCP
# define IF_TCP(x) x
#else
# define IF_TCP(x) NULL
#endif
#ifdef PROFILE
# define IF_PROFILE(x) x
#else
# define IF_PROFILE(x) NULL
#endif
#ifndef ECL_CLOS_STREAMS
# undef GRAY_
# define GRAY_ SYS_
#endif
#ifdef ECL_EXTERNALIZABLE
# define IF_EXTERNALIZABLE(x) x
#else
# define IF_EXTERNALIZABLE(x) NULL
#endif
#ifdef ECL_SSE2
# define IF_SSE2(x) x
#else
# define IF_SSE2(x) NULL
#endif
#if defined(HAVE_LIBFFI)
# define IF_DFFI(x) x
#else
# define IF_DFFI(x) NULL
#endif
#ifdef ECL_COMPLEX_FLOAT
# define IF_COMPLEX_FLOAT(x) x
#else
# define IF_COMPLEX_FLOAT(x) NULL
#endif

/* XXX When the symbol has the associated function its name must
   follow the naming convention, otherwise si:mangle-name will
   miscompile the symbol reference. See #534. -- jd 2019-12-04*/

cl_symbol_initializer
cl_symbols[] = {

{"NIL",NULL,-1},
{"T",NULL,-1},
{SYS_ "UNBOUND","si_unbound",0},
{SYS_ "PROTECT-TAG",NULL,-1},
{SYS_ "DUMMY-TAG",NULL,-1},
{SYS_ "*RESTART-CLUSTERS*",NULL,-1},
{SYS_ "*HANDLER-CLUSTERS*",NULL,-1},
{EXT_ "*INTERRUPTS-ENABLED*",NULL,1},

/* LISP PACKAGE */
{"&ALLOW-OTHER-KEYS",NULL,-1},
{"&AUX",NULL,-1},
{"&BODY",NULL,-1},
{"&ENVIRONMENT",NULL,-1},
{"&KEY",NULL,-1},
{"&OPTIONAL",NULL,-1},
{"&REST",NULL,-1},
{"&WHOLE",NULL,-1},
{"+","cl_P",-1},
{"++",NULL,-1},
{"+++",NULL,-1},
{"-","cl_M",-2},
{"*","cl_X",-1},
{"**",NULL,-1},
{"***",NULL,-1},
{"/","cl_N",-2},
{"//",NULL,-1},
{"///",NULL,-1},
{"/=","cl_NE",-1},
{"*BREAK-ON-SIGNALS*",NULL,-1},
{"*COMPILE-FILE-PATHNAME*",NULL,-1},
{"*COMPILE-FILE-TRUENAME*",NULL,-1},
{"*COMPILE-PRINT*",NULL,-1},
{"*COMPILE-VERBOSE*",NULL,-1},
{"*DEBUG-IO*",NULL,-1},
{"*DEBUGGER-HOOK*",NULL,-1},
{"*DEFAULT-PATHNAME-DEFAULTS*",NULL,-1},
{"*ERROR-OUTPUT*",NULL,-1},
{"*FEATURES*",NULL,-1},
{"*GENSYM-COUNTER*",NULL,-1},
{"*LOAD-PATHNAME*",NULL,-1},
{"*LOAD-PRINT*",NULL,-1},
{"*LOAD-TRUENAME*",NULL,-1},
{"*LOAD-VERBOSE*",NULL,-1},
{"*MACROEXPAND-HOOK*",NULL,-1},
{"*MODULES*",NULL,-1},
{EXT_ "*MODULE-PROVIDER-FUNCTIONS*",NULL,-1},
{"*PACKAGE*",NULL,-1},
{"*PRINT-ARRAY*",NULL,-1},
{"*PRINT-BASE*",NULL,-1},
{"*PRINT-CASE*",NULL,-1},
{"*PRINT-CIRCLE*",NULL,-1},
{"*PRINT-ESCAPE*",NULL,-1},
{"*PRINT-GENSYM*",NULL,-1},
{"*PRINT-LENGTH*",NULL,-1},
{"*PRINT-LEVEL*",NULL,-1},
{"*PRINT-LINES*",NULL,-1},
{"*PRINT-MISER-WIDTH*",NULL,-1},
{"*PRINT-PPRINT-DISPATCH*",NULL,-1},
#if defined(ECL_CMU_FORMAT)
{"*PRINT-PRETTY*",NULL,-1},
#else
{"*PRINT-PRETTY*",NULL,-1},
#endif
{"*PRINT-RADIX*",NULL,-1},
{"*PRINT-READABLY*",NULL,-1},
{"*PRINT-RIGHT-MARGIN*",NULL,-1},
{"*QUERY-IO*",NULL,-1},
{"*RANDOM-STATE*",NULL,-1},
{"*READ-BASE*",NULL,-1},
{"*READ-DEFAULT-FLOAT-FORMAT*",NULL,-1},
{"*READ-EVAL*",NULL,-1},
{"*READ-SUPPRESS*",NULL,-1},
{"*READTABLE*",NULL,-1},
{"*STANDARD-INPUT*",NULL,-1},
{"*STANDARD-OUTPUT*",NULL,-1},
{"*TERMINAL-IO*",NULL,-1},
{"*TRACE-OUTPUT*",NULL,-1},
{"1+","cl_1P",1},
{"1-","cl_1M",1},
{"<","cl_L",-1},
{"<=","cl_LE",-1},
{"=","cl_E",-2},
{">","cl_G",-1},
{">=","cl_GE",-1},
{"ABORT","ECL_NAME(cl_abort)",-1},
{"ABS","cl_abs",1},
{"ACONS","cl_acons",3},
{"ACOS","ECL_NAME(cl_acos)",1},
{"ACOSH","ECL_NAME(cl_acosh)",1},
{"ADJOIN","cl_adjoin",-3},
{"ADJUST-ARRAY","ECL_NAME(cl_adjust_array)",-3},
{"ADJUSTABLE-ARRAY-P","cl_adjustable_array_p",1},
{"ALPHA-CHAR-P","cl_alpha_char_p",1},
{"ALPHANUMERICP","cl_alphanumericp",1},
{"AND",NULL,-1},
{"APPEND","cl_append",-1},
{"APPLY","cl_apply",-3},
{"APROPOS","ECL_NAME(cl_apropos)",-2},
{"APROPOS-LIST","ECL_NAME(cl_apropos_list)",-2},
{"AREF","cl_aref",-2},
{"ARITHMETIC-ERROR",NULL,-1},
{"ARITHMETIC-ERROR-OPERANDS",NULL,-1},
{"ARITHMETIC-ERROR-OPERATION",NULL,-1},
{"ARRAY",NULL,-1},
{"ARRAY-DIMENSION","cl_array_dimension",2},
{"ARRAY-DIMENSION-LIMIT",NULL,-1},
{"ARRAY-DIMENSIONS","ECL_NAME(cl_array_dimensions)",1},
{"ARRAY-DISPLACEMENT","cl_array_displacement",1},
{"ARRAY-ELEMENT-TYPE","cl_array_element_type",1},
{"ARRAY-HAS-FILL-POINTER-P","cl_array_has_fill_pointer_p",1},
{"ARRAY-IN-BOUNDS-P","ECL_NAME(cl_array_in_bounds_p)",-2},
{"ARRAY-RANK","cl_array_rank",1},
{"ARRAY-RANK-LIMIT",NULL,-1},
{"ARRAY-ROW-MAJOR-INDEX","ECL_NAME(cl_array_row_major_index)",-2},
{"ARRAY-TOTAL-SIZE","cl_array_total_size",1},
{"ARRAY-TOTAL-SIZE-LIMIT",NULL,-1},
{"ARRAYP","cl_arrayp",1},
{"ASH","cl_ash",2},
{"ASIN","ECL_NAME(cl_asin)",1},
{"ASINH","ECL_NAME(cl_asinh)",1},
{"ASSERT",NULL,-1},
{"ASSOC","cl_assoc",-3},
{"ASSOC-IF","ECL_NAME(cl_assoc_if)",-3},
{"ASSOC-IF-NOT","ECL_NAME(cl_assoc_if_not)",-3},
{"ATAN","cl_atan",-2},
{"ATANH","ECL_NAME(cl_atanh)",1},
{"ATOM","cl_atom",1},
{"BASE-CHAR",NULL,-1},
{"BASE-STRING",NULL,-1},
{"BIGNUM",NULL,-1},
{"BIT","ECL_NAME(cl_bit)",-2},
{"BIT-AND","ECL_NAME(cl_bit_and)",-3},
{"BIT-ANDC1","ECL_NAME(cl_bit_andc1)",-3},
{"BIT-ANDC2","ECL_NAME(cl_bit_andc2)",-3},
{"BIT-EQV","ECL_NAME(cl_bit_eqv)",-3},
{"BIT-IOR","ECL_NAME(cl_bit_ior)",-3},
{"BIT-NAND","ECL_NAME(cl_bit_nand)",-3},
{"BIT-NOR","ECL_NAME(cl_bit_nor)",-3},
{"BIT-NOT","ECL_NAME(cl_bit_not)",-2},
{"BIT-ORC1","ECL_NAME(cl_bit_orc1)",-3},
{"BIT-ORC2","ECL_NAME(cl_bit_orc2)",-3},
{"BIT-VECTOR",NULL,-1},
{"BIT-VECTOR-P","cl_bit_vector_p",1},
{"BIT-XOR","ECL_NAME(cl_bit_xor)",-3},
{"BLOCK",NULL,-1},
{"BOOLE","cl_boole",3},
{"BOOLE-1",NULL,-1},
{"BOOLE-2",NULL,-1},
{"BOOLE-AND",NULL,-1},
{"BOOLE-ANDC1",NULL,-1},
{"BOOLE-ANDC2",NULL,-1},
{"BOOLE-C1",NULL,-1},
{"BOOLE-C2",NULL,-1},
{"BOOLE-CLR",NULL,-1},
{"BOOLE-EQV",NULL,-1},
{"BOOLE-IOR",NULL,-1},
{"BOOLE-NAND",NULL,-1},
{"BOOLE-NOR",NULL,-1},
{"BOOLE-ORC1",NULL,-1},
{"BOOLE-ORC2",NULL,-1},
{"BOOLE-SET",NULL,-1},
{"BOOLE-XOR",NULL,-1},
{"BOOLEAN",NULL,-1},
{"BOTH-CASE-P","cl_both_case_p",1},
{"BOUNDP","cl_boundp",1},
{"BREAK",NULL,-1},
{"BROADCAST-STREAM",NULL,-1},
{"BROADCAST-STREAM-STREAMS","cl_broadcast_stream_streams",1},
{"BUTLAST","cl_butlast",-2},
{"BYTE","ECL_NAME(cl_byte)",2},
{"BYTE-POSITION","ECL_NAME(cl_byte_position)",1},
{"BYTE-SIZE","ECL_NAME(cl_byte_size)",1},
{"CAAAAR","cl_caaaar",1},
{"CAAADR","cl_caaadr",1},
{"CAAAR","cl_caaar",1},
{"CAADAR","cl_caadar",1},
{"CAADDR","cl_caaddr",1},
{"CAADR","cl_caadr",1},
{"CAAR","cl_caar",1},
{"CADAAR","cl_cadaar",1},
{"CADADR","cl_cadadr",1},
{"CADAR","cl_cadar",1},
{"CADDAR","cl_caddar",1},
{"CADDDR","cl_cadddr",1},
{"CADDR","cl_caddr",1},
{"CADR","cl_cadr",1},
{"CALL-ARGUMENTS-LIMIT",NULL,-1},
{"CAR","cl_car",1},
{"CASE",NULL,-1},
{"CATCH",NULL,-1},
{"CCASE",NULL,-1},
{"CDAAAR","cl_cdaaar",1},
{"CDAADR","cl_cdaadr",1},
{"CDAAR","cl_cdaar",1},
{"CDADAR","cl_cdadar",1},
{"CDADDR","cl_cdaddr",1},
{"CDADR","cl_cdadr",1},
{"CDAR","cl_cdar",1},
{"CDDAAR","cl_cddaar",1},
{"CDDADR","cl_cddadr",1},
{"CDDAR","cl_cddar",1},
{"CDDDAR","cl_cdddar",1},
{"CDDDDR","cl_cddddr",1},
{"CDDDR","cl_cdddr",1},
{"CDDR","cl_cddr",1},
{"CDR","cl_cdr",1},
{"CEILING","cl_ceiling",-2},
{"CELL-ERROR",NULL,-1},
{"CELL-ERROR-NAME",NULL,-1},
{"CERROR","cl_cerror",-3},
{"CHAR","cl_char",2},
{"CHAR-CODE","cl_char_code",1},
{"CHAR-CODE-LIMIT",NULL,-1},
{"CHAR-DOWNCASE","cl_char_downcase",1},
{"CHAR-EQUAL","cl_char_equal",-2},
{"CHAR-GREATERP","cl_char_greaterp",-1},
{"CHAR-INT","cl_char_int",1},
{"CHAR-LESSP","cl_char_lessp",-1},
{"CHAR-NAME","cl_char_name",1},
{"CHAR-NOT-EQUAL","cl_char_not_equal",-1},
{"CHAR-NOT-GREATERP","cl_char_not_greaterp",-1},
{"CHAR-NOT-LESSP","cl_char_not_lessp",-1},
{"CHAR-UPCASE","cl_char_upcase",1},
{"CHAR/=","cl_charNE",-1},
{"CHAR<","cl_charL",-1},
{"CHAR<=","cl_charLE",-1},
{"CHAR=","cl_charE",-2},
{"CHAR>","cl_charG",-1},
{"CHAR>=","cl_charGE",-1},
{"CHARACTER","cl_character",1},
{"CHARACTERP","cl_characterp",1},
{"CHECK-TYPE",NULL,-1},
{"CIS","ECL_NAME(cl_cis)",1},
{"CLEAR-INPUT","cl_clear_input",-1},
{"CLEAR-OUTPUT","cl_clear_output",-1},
{"CLOSE","cl_close",-2},
{"CLRHASH","cl_clrhash",1},
{"CODE-CHAR","cl_code_char",1},
{"COERCE","ECL_NAME(cl_coerce)",2},
{"COMPILATION-SPEED",NULL,-1},
{"COMPILE",NULL,-1},
{"COMPILE-FILE",NULL,-1},
{"COMPILE-FILE-PATHNAME",NULL,-1},
{"COMPILED-FUNCTION",NULL,-1},
{"COMPILED-FUNCTION-P","cl_compiled_function_p",1},
{"COMPILER-MACRO",NULL,-1},
{"COMPILER-MACRO-FUNCTION",NULL,-1},
{"COMPLEMENT","ECL_NAME(cl_complement)",1},
{"COMPLEX","cl_complex",-2},
{"COMPLEXP","cl_complexp",1},
{"COMPUTE-RESTARTS","ECL_NAME(cl_compute_restarts)",-1},
{"CONCATENATE","ECL_NAME(cl_concatenate)",-2},
{"CONCATENATED-STREAM",NULL,-1},
{"CONCATENATED-STREAM-STREAMS","cl_concatenated_stream_streams",1},
{"COND",NULL,-1},
{"CONDITION",NULL,-1},
{"CONJUGATE","cl_conjugate",1},
{"CONTINUE","ECL_NAME(cl_continue)",-1},
{"CONS","cl_cons",2},
{"CONSP","cl_consp",1},
{"CONSTANTLY","ECL_NAME(cl_constantly)",1},
{"CONSTANTP","cl_constantp",-2},
{"CONTROL-ERROR",NULL,-1},
{"COPY-ALIST","cl_copy_alist",1},
{"COPY-LIST","cl_copy_list",1},
{"COPY-PPRINT-DISPATCH","ECL_NAME_PPRINT(cl_copy_pprint_dispatch)",-1},
{"COPY-READTABLE","cl_copy_readtable",-1},
{"COPY-SEQ","cl_copy_seq",1},
{"COPY-STRUCTURE","cl_copy_structure",1},
{"COPY-SYMBOL","cl_copy_symbol",-2},
{"COPY-TREE","cl_copy_tree",1},
{"COS","cl_cos",1},
{"COSH","cl_cosh",1},
{"COUNT","ECL_NAME(cl_count)",-3},
{"COUNT-IF","ECL_NAME(cl_count_if)",-3},
{"COUNT-IF-NOT","ECL_NAME(cl_count_if_not)",-3},
{"CTYPECASE",NULL,-1},
{"DEBUG",NULL,-1},
{"DECF",NULL,-1},
{"DECLAIM",NULL,-1},
{"DECLARATION",NULL,-1},
{"DECLARE",NULL,-1},
{"DECODE-FLOAT","cl_decode_float",1},
{"DECODE-UNIVERSAL-TIME","ECL_NAME(cl_decode_universal_time)",-2},
{"DEFCONSTANT",NULL,-1},
{"DEFINE-CONDITION",NULL,-1},
{"DEFINE-COMPILER-MACRO",NULL,-1},
{"DEFINE-MODIFY-MACRO",NULL,-1},
{"DEFINE-SETF-EXPANDER",NULL,-1},
{"DEFINE-SYMBOL-MACRO",NULL,-1},
{"DEFMACRO",NULL,-1},
{"DEFPACKAGE",NULL,-1},
{"DEFPARAMETER",NULL,-1},
{"DEFSETF",NULL,-1},
{"DEFSTRUCT",NULL,-1},
{"DEFTYPE",NULL,-1},
{"DEFUN",NULL,-1},
{"DEFVAR",NULL,-1},
{"DELETE","ECL_NAME(cl_delete)",-3},
{"DELETE-DUPLICATES","ECL_NAME(cl_delete_duplicates)",-2},
{"DELETE-FILE","cl_delete_file",1},
{"DELETE-IF","ECL_NAME(cl_delete_if)",-3},
{"DELETE-IF-NOT","ECL_NAME(cl_delete_if_not)",-3},
{"DELETE-PACKAGE","cl_delete_package",1},
{"DENOMINATOR","cl_denominator",1},
{"DEPOSIT-FIELD","ECL_NAME(cl_deposit_field)",3},
{"DESCRIBE","ECL_NAME(cl_describe)",-2},
{"DESTRUCTURING-BIND",NULL,-1},
{"DIGIT-CHAR","cl_digit_char",-2},
{"DIGIT-CHAR-P","cl_digit_char_p",-2},
{"DIRECTORY","cl_directory",-2},
{"DIRECTORY-NAMESTRING","cl_directory_namestring",1},
{"DISASSEMBLE",NULL,-1},
{"DIVISION-BY-ZERO",NULL,-1},
{"DO",NULL,-1},
{"DO*",NULL,-1},
{"DO-ALL-SYMBOLS",NULL,-1},
{"DO-EXTERNAL-SYMBOLS",NULL,-1},
{"DO-SYMBOLS",NULL,-1},
{"DOCUMENTATION",NULL,-1},
{"DOLIST",NULL,-1},
{"DOTIMES",NULL,-1},
{"DOUBLE-FLOAT",NULL,-1},
{"DOUBLE-FLOAT-EPSILON",NULL,-1},
{"DOUBLE-FLOAT-NEGATIVE-EPSILON",NULL,-1},
{"DPB","ECL_NAME(cl_dpb)",3},
{"DRIBBLE","ECL_NAME(cl_dribble)",-1},
{"DYNAMIC-EXTENT",NULL,-1},
{"ECASE",NULL,-1},
{"ECHO-STREAM",NULL,-1},
{"ECHO-STREAM-INPUT-STREAM","cl_echo_stream_input_stream",1},
{"ECHO-STREAM-OUTPUT-STREAM","cl_echo_stream_output_stream",1},
{"ED",NULL,-1},
{"EIGHTH","cl_eighth",1},
{"ELT","cl_elt",2},
{"ENCODE-UNIVERSAL-TIME","ECL_NAME(cl_encode_universal_time)",-7},
{"END-OF-FILE",NULL,-1},
{"ENDP","cl_endp",1},
{"ENOUGH-NAMESTRING","cl_enough_namestring",-2},
{"ENSURE-DIRECTORIES-EXIST","ECL_NAME(cl_ensure_directories_exist)",-2},
{"EQ","cl_eq",2},
{"EQL","cl_eql",2},
{"EQUAL","cl_equal",2},
{"EQUALP","cl_equalp",2},
{"ERROR","cl_error",-2},
{"ETYPECASE",NULL,-1},
{"EVAL","cl_eval",1},
{"EVAL-WHEN",NULL,-1},
{"EVENP","cl_evenp",1},
{"EVERY","ECL_NAME(cl_every)",-3},
{"EXP","cl_exp",1},
{"EXPORT","cl_export",-2},
{"EXPT","cl_expt",2},
{"EXTENDED-CHAR",NULL,-1},
{"FBOUNDP","cl_fboundp",1},
{"FCEILING","ECL_NAME(cl_fceiling)",-2},
{"FDEFINITION","cl_fdefinition",1},
{"FFLOOR","ECL_NAME(cl_ffloor)",-2},
{"FIFTH","cl_fifth",1},
{"FILE-AUTHOR","cl_file_author",1},
{"FILE-ERROR",NULL,-1},
{"FILE-ERROR-PATHNAME",NULL,-1},
{"FILE-LENGTH","cl_file_length",1},
{"FILE-NAMESTRING","cl_file_namestring",1},
{"FILE-POSITION","cl_file_position",-2},
{"FILE-STREAM",NULL,-1},
{"FILE-STRING-LENGTH","cl_file_string_length",2},
{"FILE-WRITE-DATE","cl_file_write_date",1},
{"FILL","ECL_NAME(cl_fill)",-3},
{"FILL-POINTER","cl_fill_pointer",1},
{"FIND","ECL_NAME(cl_find)",-3},
{"FIND-ALL-SYMBOLS","ECL_NAME(cl_find_all_symbols)",1},
{"FIND-IF","ECL_NAME(cl_find_if)",-3},
{"FIND-IF-NOT","ECL_NAME(cl_find_if_not)",-3},
{"FIND-PACKAGE","cl_find_package",1},
{"FIND-RESTART","ECL_NAME(cl_find_restart)",-2},
{"FIND-SYMBOL","cl_find_symbol",-2},
{"FINISH-OUTPUT","cl_finish_output",-1},
{"FIRST","cl_car",1},
{"FIXNUM",NULL,-1},
{"FLET",NULL,-1},
{"FLOAT","cl_float",-2},
{"FLOAT-DIGITS","cl_float_digits",1},
{"FLOAT-PRECISION","cl_float_precision",1},
{"FLOAT-RADIX","cl_float_radix",1},
{"FLOAT-SIGN","cl_float_sign",-2},
{"FLOATING-POINT-INEXACT",NULL,-1},
{"FLOATING-POINT-INVALID-OPERATION",NULL,-1},
{"FLOATING-POINT-OVERFLOW",NULL,-1},
{"FLOATING-POINT-UNDERFLOW",NULL,-1},
{"FLOATP","cl_floatp",1},
{"FLOOR","cl_floor",-2},
{"FMAKUNBOUND","cl_fmakunbound",1},
{"FORCE-OUTPUT","cl_force_output",-1},
{"FORMAT","cl_format",-3},
{"FORMATTER",NULL,-1},
{"FOURTH","cl_cadddr",1},
{"FRESH-LINE","cl_fresh_line",-1},
{"FROUND","ECL_NAME(cl_fround)",-2},
{"FTRUNCATE","ECL_NAME(cl_ftruncate)",-2},
{"FTYPE",NULL,-1},
{"FUNCALL","cl_funcall",-2},
{"FUNCTION-LAMBDA-EXPRESSION","cl_function_lambda_expression",1},
{"FUNCTION",NULL,-1},
{"FUNCTION-KEYWORDS",NULL,-1},
{"FUNCTIONP","cl_functionp",1},
{"GCD","cl_gcd",-1},
{"GENSYM","cl_gensym",-1},
{"GENTEMP","cl_gentemp",-1},
{"GET","cl_get",-3},
{"GET-DECODED-TIME","ECL_NAME(cl_get_decoded_time)",0},
{"GET-DISPATCH-MACRO-CHARACTER","cl_get_dispatch_macro_character",-3},
{"GET-INTERNAL-REAL-TIME","cl_get_internal_real_time",0},
{"GET-INTERNAL-RUN-TIME","cl_get_internal_run_time",0},
{"GET-MACRO-CHARACTER","cl_get_macro_character",-2},
{"GET-OUTPUT-STREAM-STRING","cl_get_output_stream_string",1},
{"GET-PROPERTIES","cl_get_properties",2},
{"GET-SETF-EXPANSION",NULL,-1},
{"GET-UNIVERSAL-TIME","cl_get_universal_time",0},
{"GETF","cl_getf",-3},
{"GETHASH","cl_gethash",-3},
{"GO",NULL,-1},
{"GRAPHIC-CHAR-P","cl_graphic_char_p",1},
{"HANDLER-CASE",NULL,-1},
{"HANDLER-BIND",NULL,-1},
{"HASH-TABLE",NULL,-1},
{"HASH-TABLE-COUNT","cl_hash_table_count",1},
{"HASH-TABLE-P","cl_hash_table_p",1},
{"HASH-TABLE-REHASH-SIZE","cl_hash_table_rehash_size",1},
{"HASH-TABLE-REHASH-THRESHOLD","cl_hash_table_rehash_threshold",1},
{"HASH-TABLE-SIZE","cl_hash_table_size",1},
{"HASH-TABLE-TEST","cl_hash_table_test",1},
{"HOST-NAMESTRING","cl_host_namestring",1},
{"IDENTITY","cl_identity",1},
{"IGNORABLE",NULL,-1},
{"IGNORE",NULL,-1},
{"IGNORE-ERRORS",NULL,-1},
{"IMAGPART","cl_imagpart",1},
{"IMPORT","cl_import",-2},
{"IN-PACKAGE",NULL,-1},
{"INCF",NULL,-1},
{"INLINE",NULL,-1},
{"INPUT-STREAM-P","cl_input_stream_p",1},
{"INSPECT","ECL_NAME(cl_inspect)",1},
{"INTEGER",NULL,-1},
{"INTEGER-DECODE-FLOAT","cl_integer_decode_float",1},
{"INTEGER-LENGTH","cl_integer_length",1},
{"INTEGERP","cl_integerp",1},
{"INTERACTIVE-STREAM-P","cl_interactive_stream_p",1},
{"INTERN","cl_intern",-2},
{"INTERNAL-TIME-UNITS-PER-SECOND",NULL,-1},
{"INTERSECTION","ECL_NAME(cl_intersection)",-3},
{"INVOKE-DEBUGGER",NULL,-1},
{"INVOKE-RESTART","ECL_NAME(cl_invoke_restart)",-2},
{"INVOKE-RESTART-INTERACTIVELY","ECL_NAME(cl_invoke_restart_interactively)",1},
{"ISQRT","ECL_NAME(cl_isqrt)",1},
{"KEYWORD",NULL,-1},
{"KEYWORDP","cl_keywordp",1},
{"LABELS",NULL,-1},
{"LAMBDA",NULL,-1},
{"LAMBDA-LIST-KEYWORDS",NULL,-1},
{"LAMBDA-PARAMETERS-LIMIT",NULL,-1},
{"LAST","cl_last",-2},
{"LCM","cl_lcm",-1},
{"LDB","ECL_NAME(cl_ldb)",2},
{"LDB-TEST","ECL_NAME(cl_ldb_test)",2},
{"LDIFF","cl_ldiff",2},
{"LEAST-NEGATIVE-DOUBLE-FLOAT",NULL,-1},
{"LEAST-NEGATIVE-LONG-FLOAT",NULL,-1},
{"LEAST-NEGATIVE-NORMALIZED-DOUBLE-FLOAT",NULL,-1},
{"LEAST-NEGATIVE-NORMALIZED-LONG-FLOAT",NULL,-1},
{"LEAST-NEGATIVE-NORMALIZED-SHORT-FLOAT",NULL,-1},
{"LEAST-NEGATIVE-NORMALIZED-SINGLE-FLOAT",NULL,-1},
{"LEAST-NEGATIVE-SHORT-FLOAT",NULL,-1},
{"LEAST-NEGATIVE-SINGLE-FLOAT",NULL,-1},
{"LEAST-POSITIVE-DOUBLE-FLOAT",NULL,-1},
{"LEAST-POSITIVE-LONG-FLOAT",NULL,-1},
{"LEAST-POSITIVE-NORMALIZED-DOUBLE-FLOAT",NULL,-1},
{"LEAST-POSITIVE-NORMALIZED-LONG-FLOAT",NULL,-1},
{"LEAST-POSITIVE-NORMALIZED-SHORT-FLOAT",NULL,-1},
{"LEAST-POSITIVE-NORMALIZED-SINGLE-FLOAT",NULL,-1},
{"LEAST-POSITIVE-SHORT-FLOAT",NULL,-1},
{"LEAST-POSITIVE-SINGLE-FLOAT",NULL,-1},
{"LENGTH","cl_length",1},
{"LET",NULL,-1},
{"LET*",NULL,-1},
{"LISP-IMPLEMENTATION-TYPE","ECL_NAME(cl_lisp_implementation_type)",0},
{"LISP-IMPLEMENTATION-VERSION","ECL_NAME(cl_lisp_implementation_version)",0},
{"LIST","cl_list",-1},
{"LIST*","cl_listX",-1},
{"LIST-ALL-PACKAGES","cl_list_all_packages",0},
{"LIST-LENGTH","cl_list_length",1},
{"LISTEN","cl_listen",-1},
{"LISTP","cl_listp",1},
{"LOAD","cl_load",-2},
{"LOAD-LOGICAL-PATHNAME-TRANSLATIONS","ECL_NAME(cl_load_logical_pathname_translations)",1},
{"LOAD-TIME-VALUE",NULL,-1},
{"LOCALLY",NULL,-1},
{"LOG","cl_log",-2},
{"LOGAND","cl_logand",-1},
{"LOGANDC1","cl_logandc1",2},
{"LOGANDC2","cl_logandc2",2},
{"LOGBITP","cl_logbitp",2},
{"LOGCOUNT","cl_logcount",1},
{"LOGEQV","cl_logeqv",-1},
{"LOGICAL-PATHNAME","cl_logical_pathname",1},
{"LOGICAL-PATHNAME-TRANSLATIONS","ECL_NAME(cl_logical_pathname_translations)",1},
{"LOGIOR","cl_logior",-1},
{"LOGNAND","cl_lognand",2},
{"LOGNOR","cl_lognor",2},
{"LOGNOT","cl_lognot",1},
{"LOGORC1","cl_logorc1",2},
{"LOGORC2","cl_logorc2",2},
{"LOGTEST","ECL_NAME(cl_logtest)",2},
{"LOGXOR","cl_logxor",-1},
{"LONG-FLOAT",NULL,-1},
{"LONG-FLOAT-EPSILON",NULL,-1},
{"LONG-FLOAT-NEGATIVE-EPSILON",NULL,-1},
{"LONG-SITE-NAME","ECL_NAME(cl_long_site_name)",0},
{"LOOP",NULL,-1},
{"LOOP-FINISH",NULL,-1},
{"LOWER-CASE-P","cl_lower_case_p",1},
{"MACHINE-INSTANCE","ECL_NAME(cl_machine_instance)",0},
{"MACHINE-TYPE","ECL_NAME(cl_machine_type)",0},
{"MACHINE-VERSION","ECL_NAME(cl_machine_version)",0},
{"MACRO-FUNCTION","cl_macro_function",-2},
{"MACROEXPAND","cl_macroexpand",-2},
{"MACROEXPAND-1","cl_macroexpand_1",-2},
{"MACROLET",NULL,-1},
{"MAKE-ARRAY","ECL_NAME(cl_make_array)",-2},
{"MAKE-BROADCAST-STREAM","cl_make_broadcast_stream",-1},
{"MAKE-CONDITION","ECL_NAME(cl_make_condition)",-2},
{"MAKE-CONCATENATED-STREAM","cl_make_concatenated_stream",-1},
{"MAKE-DISPATCH-MACRO-CHARACTER","cl_make_dispatch_macro_character",-2},
{"MAKE-ECHO-STREAM","cl_make_echo_stream",2},
{"MAKE-HASH-TABLE","cl_make_hash_table",-1},
{"MAKE-LIST","cl_make_list",-2},
{"MAKE-PACKAGE","cl_make_package",-2},
{"MAKE-PATHNAME","cl_make_pathname",-1},
{"MAKE-RANDOM-STATE","cl_make_random_state",-1},
{"MAKE-SEQUENCE","ECL_NAME(cl_make_sequence)",-3},
{"MAKE-STRING","cl_make_string",-2},
{"MAKE-STRING-INPUT-STREAM","cl_make_string_input_stream",-2},
{"MAKE-STRING-OUTPUT-STREAM","cl_make_string_output_stream",-1},
{"MAKE-SYMBOL","cl_make_symbol",1},
{"MAKE-SYNONYM-STREAM","cl_make_synonym_stream",1},
{"MAKE-TWO-WAY-STREAM","cl_make_two_way_stream",2},
{"MAKUNBOUND","cl_makunbound",1},
{"MAP","ECL_NAME(cl_map)",-4},
{"MAP-INTO","ECL_NAME(cl_map_into)",-3},
{"MAPC","cl_mapc",-2},
{"MAPCAN","cl_mapcan",-2},
{"MAPCAR","cl_mapcar",-2},
{"MAPCON","cl_mapcon",-2},
{"MAPHASH","cl_maphash",2},
{"MAPL","cl_mapl",-2},
{"MAPLIST","cl_maplist",-2},
{"MASK-FIELD","ECL_NAME(cl_mask_field)",2},
{"MAX","cl_max",-2},
{"MEMBER","cl_member",-3},
{"MEMBER-IF","ECL_NAME(cl_member_if)",-3},
{"MEMBER-IF-NOT","ECL_NAME(cl_member_if_not)",-3},
{"MERGE","ECL_NAME(cl_merge)",-5},
{"MERGE-PATHNAMES","cl_merge_pathnames",-2},
{"MIN","cl_min",-2},
{"MINUSP","cl_minusp",1},
{"MISMATCH","ECL_NAME(cl_mismatch)",-3},
{"MOD","cl_mod",2},
{"MOST-NEGATIVE-DOUBLE-FLOAT",NULL,-1},
{"MOST-NEGATIVE-FIXNUM",NULL,-1},
{"MOST-NEGATIVE-LONG-FLOAT",NULL,-1},
{"MOST-NEGATIVE-SHORT-FLOAT",NULL,-1},
{"MOST-NEGATIVE-SINGLE-FLOAT",NULL,-1},
{"MOST-POSITIVE-DOUBLE-FLOAT",NULL,-1},
{"MOST-POSITIVE-FIXNUM",NULL,-1},
{"MOST-POSITIVE-LONG-FLOAT",NULL,-1},
{"MOST-POSITIVE-SHORT-FLOAT",NULL,-1},
{"MOST-POSITIVE-SINGLE-FLOAT",NULL,-1},
{"MUFFLE-WARNING","ECL_NAME(cl_muffle_warning)",-1},
{"MULTIPLE-VALUE-BIND",NULL,-1},
{"MULTIPLE-VALUE-CALL",NULL,-1},
{"MULTIPLE-VALUE-LIST",NULL,-1},
{"MULTIPLE-VALUE-PROG1",NULL,-1},
{"MULTIPLE-VALUE-SETQ",NULL,-1},
{"MULTIPLE-VALUES-LIMIT",NULL,-1},
{"NAME-CHAR","cl_name_char",1},
{"NAMESTRING","cl_namestring",1},
{"NBUTLAST","cl_nbutlast",-2},
{"NCONC","cl_nconc",-1},
{"NINTERSECTION","ECL_NAME(cl_nintersection)",-3},
{"NINTH","cl_ninth",1},
{"NOT","cl_not",1},
{"NOTANY","ECL_NAME(cl_notany)",-3},
{"NOTEVERY","ECL_NAME(cl_notevery)",-3},
{"NOTINLINE",NULL,-1},
{"NRECONC","cl_nreconc",2},
{"NREVERSE","cl_nreverse",1},
{"NSET-DIFFERENCE","ECL_NAME(cl_nset_difference)",-3},
{"NSET-EXCLUSIVE-OR","ECL_NAME(cl_nset_exclusive_or)",-3},
{"NSTRING-CAPITALIZE","cl_nstring_capitalize",-1},
{"NSTRING-DOWNCASE","cl_nstring_downcase",-1},
{"NSTRING-UPCASE","cl_nstring_upcase",-1},
{"NSUBLIS","cl_nsublis",-3},
{"NSUBST","cl_nsubst",-4},
{"NSUBST-IF","ECL_NAME(cl_nsubst_if)",-4},
{"NSUBST-IF-NOT","ECL_NAME(cl_nsubst_if_not)",-4},
{"NSUBSTITUTE","ECL_NAME(cl_nsubstitute)",-4},
{"NSUBSTITUTE-IF","ECL_NAME(cl_nsubstitute_if)",-4},
{"NSUBSTITUTE-IF-NOT","ECL_NAME(cl_nsubstitute_if_not)",-4},
{"NTH","cl_nth",2},
{"NTH-VALUE",NULL,-1},
{"NTHCDR","cl_nthcdr",2},
{"NULL","cl_null",1},
{"NUMBER",NULL,-1},
{"NUMBERP","cl_numberp",1},
{"NUMERATOR","cl_numerator",1},
{"NUNION","ECL_NAME(cl_nunion)",-3},
{"ODDP","cl_oddp",1},
{"OPEN","cl_open",-2},
{"OPEN-STREAM-P","cl_open_stream_p",1},
{"OPTIMIZE",NULL,-1},
{"OR",NULL,-1},
{"OTHERWISE",NULL,-1},
{"OUTPUT-STREAM-P","cl_output_stream_p",1},
{"PACKAGE",NULL,-1},
{"PACKAGE-ERROR",NULL,-1},
{"PACKAGE-ERROR-PACKAGE",NULL,-1},
{"PACKAGE-NAME","cl_package_name",1},
{"PACKAGE-NICKNAMES","cl_package_nicknames",1},
{"PACKAGE-SHADOWING-SYMBOLS","cl_package_shadowing_symbols",1},
{"PACKAGE-USE-LIST","cl_package_use_list",1},
{"PACKAGE-USED-BY-LIST","cl_package_used_by_list",1},
{"PACKAGEP","cl_packagep",1},
{"PAIRLIS","cl_pairlis",-3},
{"PARSE-ERROR",NULL,-1},
{"PARSE-INTEGER","cl_parse_integer",-2},
{"PARSE-NAMESTRING","cl_parse_namestring",-2},
{"PATHNAME","cl_pathname",1},
{"PATHNAME-DEVICE","cl_pathname_device",-2},
{"PATHNAME-DIRECTORY","cl_pathname_directory",-2},
{"PATHNAME-HOST","cl_pathname_host",-2},
{"PATHNAME-MATCH-P","cl_pathname_match_p",2},
{"PATHNAME-NAME","cl_pathname_name",-2},
{"PATHNAME-TYPE","cl_pathname_type",-2},
{"PATHNAME-VERSION","cl_pathname_version",1},
{"PATHNAMEP","cl_pathnamep",1},
{"PEEK-CHAR","cl_peek_char",-1},
{"PHASE","ECL_NAME(cl_phase)",1},
{"PI",NULL,-1},
{"PLUSP","cl_plusp",1},
{"POP",NULL,-1},
{"POSITION","ECL_NAME(cl_position)",-3},
{"POSITION-IF","ECL_NAME(cl_position_if)",-3},
{"POSITION-IF-NOT","ECL_NAME(cl_position_if_not)",-3},
{"PPRINT","cl_pprint",-2},
{"PPRINT-DISPATCH","ECL_NAME_PPRINT(cl_pprint_dispatch)",-2},
{"PPRINT-EXIT-IF-LIST-EXHAUSTED",NULL,-1},
{"PPRINT-FILL","ECL_NAME_PPRINT(cl_pprint_fill)",-3},
{"PPRINT-INDENT","ECL_NAME_PPRINT(cl_pprint_indent)",-3},
{"PPRINT-LINEAR","ECL_NAME_PPRINT(cl_pprint_linear)",-3},
{"PPRINT-LOGICAL-BLOCK",NULL,-1},
{"PPRINT-NEWLINE","ECL_NAME_PPRINT(cl_pprint_newline)",-2},
{"PPRINT-POP",NULL,-1},
{"PPRINT-TAB","ECL_NAME_PPRINT(cl_pprint_tab)",-4},
{"PPRINT-TABULAR","ECL_NAME_PPRINT(cl_pprint_tabular)",-3},
{"PRIN1","cl_prin1",-2},
{"PRIN1-TO-STRING","ECL_NAME(cl_prin1_to_string)",1},
{"PRINC","cl_princ",-2},
{"PRINC-TO-STRING","ECL_NAME(cl_princ_to_string)",1},
{"PRINT","cl_print",-2},
{"PRINT-NOT-READABLE",NULL,-1},
{"PRINT-NOT-READABLE-OBJECT",NULL,-1},
{"PROBE-FILE","cl_probe_file",1},
{"PROCLAIM",NULL,-1},
{"PROG",NULL,-1},
{"PROG*",NULL,-1},
{"PROG1",NULL,-1},
{"PROG2",NULL,-1},
{"PROGN",NULL,-1},
{"PROGRAM-ERROR",NULL,-1},
{"PROGV",NULL,-1},
{"PROVIDE","ECL_NAME(cl_provide)",1},
{"PSETF",NULL,-1},
{"PSETQ",NULL,-1},
{"PUSH",NULL,-1},
{"PUSHNEW",NULL,-1},
{"QUOTE",NULL,-1},
{"RANDOM","cl_random",-2},
{"RANDOM-STATE",NULL,-1},
{"RANDOM-STATE-P","cl_random_state_p",1},
{"RASSOC","cl_rassoc",-3},
{"RASSOC-IF","ECL_NAME(cl_rassoc_if)",-3},
{"RASSOC-IF-NOT","ECL_NAME(cl_rassoc_if_not)",-3},
{"RATIO",NULL,-1},
{"RATIONAL","cl_rational",1},
{"RATIONALIZE","cl_rationalize",1},
{"RATIONALP","cl_rationalp",1},
{"READ","cl_read",-1},
{"READ-BYTE","cl_read_byte",-2},
{"READ-CHAR","cl_read_char",-1},
{"READ-CHAR-NO-HANG","cl_read_char_no_hang",-1},
{"READ-DELIMITED-LIST","cl_read_delimited_list",-2},
{"READ-FROM-STRING","ECL_NAME(cl_read_from_string)",-2},
{"READ-LINE","cl_read_line",-1},
{"READ-PRESERVING-WHITESPACE","cl_read_preserving_whitespace",-1},
{"READ-SEQUENCE","cl_read_sequence",-3},
{"READER-ERROR",NULL,-1},
{"READTABLE",NULL,-1},
{"READTABLE-CASE","cl_readtable_case",1},
{"READTABLEP","cl_readtablep",1},
{"REAL",NULL,-1},
{"REALP","cl_realp",1},
{"REALPART","cl_realpart",1},
{"REDUCE","ECL_NAME(cl_reduce)",-3},
{"REM","cl_rem",2},
{"REMF",NULL,-1},
{"REMHASH","cl_remhash",2},
{"REMOVE","ECL_NAME(cl_remove)",-3},
{"REMOVE-DUPLICATES","ECL_NAME(cl_remove_duplicates)",-2},
{"REMOVE-IF","ECL_NAME(cl_remove_if)",-3},
{"REMOVE-IF-NOT","ECL_NAME(cl_remove_if_not)",-3},
{"REMPROP","cl_remprop",2},
{"RENAME-FILE","cl_rename_file",-3},
{"RENAME-PACKAGE","cl_rename_package",-3},
{"REPLACE","ECL_NAME(cl_replace)",-3},
{"REQUIRE","ECL_NAME(cl_require)",-2},
{"REST","cl_cdr",1},
{"RESTART",NULL,1},
{"RESTART-BIND",NULL,1},
{"RESTART-CASE",NULL,1},
{"RESTART-NAME",NULL,1},
{"RETURN",NULL,-1},
{"RETURN-FROM",NULL,-1},
{"REVAPPEND","cl_revappend",2},
{"REVERSE","cl_reverse",1},
{"ROOM",NULL,-1},
{"ROTATEF",NULL,-1},
{"ROUND","cl_round",-2},
{"ROW-MAJOR-AREF","cl_row_major_aref",2},
{"RPLACA","cl_rplaca",2},
{"RPLACD","cl_rplacd",2},
{"SAFETY",NULL,-1},
{"SATISFIES",NULL,-1},
{"SBIT","ECL_NAME(cl_sbit)",-2},
{"SCALE-FLOAT","cl_scale_float",2},
{"SCHAR","cl_char",2},
{"SEARCH","ECL_NAME(cl_search)",-3},
{"SECOND","cl_cadr",1},
{"SEQUENCE",NULL,-1},
{"SERIOUS-CONDITION",NULL,-1},
{"SET","cl_set",2},
{"SET-DIFFERENCE","ECL_NAME(cl_set_difference)",-3},
{"SET-DISPATCH-MACRO-CHARACTER","cl_set_dispatch_macro_character",-4},
{"SET-EXCLUSIVE-OR","ECL_NAME(cl_set_exclusive_or)",-3},
{"SET-MACRO-CHARACTER","cl_set_macro_character",-3},
{"SET-PPRINT-DISPATCH","ECL_NAME_PPRINT(cl_set_pprint_dispatch)",-3},
{"SET-SYNTAX-FROM-CHAR","cl_set_syntax_from_char",-3},
{"SETF",NULL,-1},
{"SETQ",NULL,-1},
{"SEVENTH","cl_seventh",1},
{"SHADOW","cl_shadow",-2},
{"SHADOWING-IMPORT","cl_shadowing_import",-2},
{"SHIFTF",NULL,-1},
{"SHORT-FLOAT",NULL,-1},
{"SHORT-FLOAT-EPSILON",NULL,-1},
{"SHORT-FLOAT-NEGATIVE-EPSILON",NULL,-1},
{"SHORT-SITE-NAME","ECL_NAME(cl_short_site_name)",0},
{"SIGNAL",NULL,-1},
{"SIGNED-BYTE",NULL,-1},
{"SIGNUM","ECL_NAME(cl_signum)",1},
{"SIMPLE-ARRAY",NULL,-1},
{"SIMPLE-BASE-STRING",NULL,-1},
{"SIMPLE-BIT-VECTOR",NULL,-1},
{"SIMPLE-BIT-VECTOR-P","cl_simple_bit_vector_p",1},
{"SIMPLE-CONDITION",NULL,-1},
{"SIMPLE-CONDITION-FORMAT-CONTROL",NULL,-1},
{"SIMPLE-CONDITION-FORMAT-ARGUMENTS",NULL,-1},
{"SIMPLE-ERROR",NULL,-1},
{"SIMPLE-STRING",NULL,-1},
{"SIMPLE-STRING-P","cl_simple_string_p",1},
{"SIMPLE-TYPE-ERROR",NULL,-1},
{"SIMPLE-VECTOR",NULL,-1},
{"SIMPLE-VECTOR-P","cl_simple_vector_p",1},
{"SIMPLE-WARNING",NULL,-1},
{"SIN","cl_sin",1},
{"SINGLE-FLOAT",NULL,-1},
{"SINGLE-FLOAT-EPSILON",NULL,-1},
{"SINGLE-FLOAT-NEGATIVE-EPSILON",NULL,-1},
{"SINH","cl_sinh",1},
{"SIXTH","cl_sixth",1},
{"SLEEP","cl_sleep",1},
{"SOFTWARE-TYPE","ECL_NAME(cl_software_type)",0},
{"SOFTWARE-VERSION","ECL_NAME(cl_software_version)",0},
{"SOME","ECL_NAME(cl_some)",-3},
{"SORT","ECL_NAME(cl_sort)",-3},
{"SPACE",NULL,-1},
{"SPECIAL",NULL,-1},
{"SPECIAL-OPERATOR-P","cl_special_operator_p",1},
{"SPEED",NULL,-1},
{"SQRT","cl_sqrt",1},
{"STABLE-SORT","ECL_NAME(cl_stable_sort)",-3},
{"STANDARD-CHAR",NULL,-1},
{"STANDARD-CHAR-P","cl_standard_char_p",1},
{"STEP",NULL,-1},
{"STORAGE-CONDITION",NULL,-1},
{"STORE-VALUE","ECL_NAME(cl_store_value)",-2},
{"STREAM",NULL,-1},
{"STREAM-ELEMENT-TYPE","cl_stream_element_type",1},
{"STREAM-ERROR",NULL,-1},
{"STREAM-ERROR-STREAM",NULL,-1},
{"STREAM-EXTERNAL-FORMAT","cl_stream_external_format",1},
{"STREAMP","cl_streamp",1},
{"STRING","cl_string",1},
{"STRING-DOWNCASE","cl_string_downcase",-1},
{"STRING-CAPITALIZE","cl_string_capitalize",-1},
{"STRING-EQUAL","cl_string_equal",-3},
{"STRING-GREATERP","cl_string_greaterp",-1},
{"STRING-LEFT-TRIM","cl_string_left_trim",2},
{"STRING-LESSP","cl_string_lessp",-1},
{"STRING-NOT-EQUAL","cl_string_not_equal",-1},
{"STRING-NOT-GREATERP","cl_string_not_greaterp",-1},
{"STRING-NOT-LESSP","cl_string_not_lessp",-1},
{"STRING-RIGHT-TRIM","cl_string_right_trim",2},
{"STRING-STREAM",NULL,-1},
{"STRING-TRIM","cl_string_trim",2},
{"STRING-UPCASE","cl_string_upcase",-1},
{"STRING/=","cl_stringNE",-1},
{"STRING<","cl_stringL",-1},
{"STRING<=","cl_stringLE",-1},
{"STRING=","cl_stringE",-3},
{"STRING>","cl_stringG",-1},
{"STRING>=","cl_stringGE",-1},
{"STRINGP","cl_stringp",1},
{"STRUCTURE",NULL,-1},
{"STYLE-WARNING",NULL,-1},
{"SUBLIS","cl_sublis",-3},
{"SUBSEQ","cl_subseq",-3},
{"SUBSETP","ECL_NAME(cl_subsetp)",-3},
{"SUBST","cl_subst",-4},
{"SUBST-IF","ECL_NAME(cl_subst_if)",-4},
{"SUBST-IF-NOT","ECL_NAME(cl_subst_if_not)",-4},
{"SUBSTITUTE","ECL_NAME(cl_substitute)",-4},
{"SUBSTITUTE-IF","ECL_NAME(cl_substitute_if)",-4},
{"SUBSTITUTE-IF-NOT","ECL_NAME(cl_substitute_if_not)",-4},
{"SUBTYPEP","ECL_NAME(cl_subtypep)",-3},
{"SVREF","cl_svref",2},
{"SXHASH","cl_sxhash",1},
{"SYMBOL",NULL,-1},
{"SYMBOL-FUNCTION","cl_symbol_function",1},
{"SYMBOL-MACROLET",NULL,-1},
{"SYMBOL-NAME","cl_symbol_name",1},
{"SYMBOL-PACKAGE","cl_symbol_package",1},
{"SYMBOL-PLIST","cl_symbol_plist",1},
{"SYMBOL-VALUE","cl_symbol_value",1},
{"SYMBOLP","cl_symbolp",1},
{"SYNONYM-STREAM",NULL,-1},
{"SYNONYM-STREAM-SYMBOL","cl_synonym_stream_symbol",1},
{"TAGBODY",NULL,-1},
{"TAILP","cl_tailp",2},
{"TAN","cl_tan",1},
{"TANH","cl_tanh",1},
{"TENTH","cl_tenth",1},
{"TERPRI","cl_terpri",-1},
{"THE",NULL,-1},
{"THIRD","cl_caddr",1},
{"THROW",NULL,-1},
{"TIME",NULL,-1},
{"TRACE",NULL,-1},
{"TRANSLATE-LOGICAL-PATHNAME","cl_translate_logical_pathname",-2},
{"TRANSLATE-PATHNAME","cl_translate_pathname",-4},
{"TREE-EQUAL","cl_tree_equal",-3},
{"TRUENAME","cl_truename",1},
{"TRUNCATE","cl_truncate",-2},
{"TWO-WAY-STREAM",NULL,-1},
{"TWO-WAY-STREAM-INPUT-STREAM","cl_two_way_stream_input_stream",1},
{"TWO-WAY-STREAM-OUTPUT-STREAM","cl_two_way_stream_output_stream",1},
{"TYPE",NULL,-1},
{"TYPE-ERROR",NULL,-1},
{"TYPE-ERROR-DATUM",NULL,-1},
{"TYPE-ERROR-EXPECTED-TYPE",NULL,-1},
{"TYPE-OF","cl_type_of",1},
{"TYPECASE",NULL,-1},
{"TYPEP","ECL_NAME(cl_typep)",-3},
{"UNBOUND-SLOT",NULL,-1},
{"UNBOUND-SLOT-INSTANCE",NULL,-1},
{"UNBOUND-VARIABLE",NULL,-1},
{"UNDEFINED-FUNCTION",NULL,-1},
{"UNEXPORT","cl_unexport",-2},
{"UNINTERN","cl_unintern",-2},
{"UNION","ECL_NAME(cl_union)",-3},
{"UNLESS",NULL,-1},
{"UNREAD-CHAR","cl_unread_char",-2},
{"UNSIGNED-BYTE",NULL,-1},
{"UNTRACE",NULL,-1},
{"UNUSE-PACKAGE","cl_unuse_package",-2},
{"UNWIND-PROTECT",NULL,-1},
{"UPGRADED-ARRAY-ELEMENT-TYPE","ECL_NAME(cl_upgraded_array_element_type)",-2},
{"UPGRADED-COMPLEX-PART-TYPE","ECL_NAME(cl_upgraded_complex_part_type)",-2},
{"UPPER-CASE-P","cl_upper_case_p",1},
{"USE-PACKAGE","cl_use_package",-2},
{"USE-VALUE","ECL_NAME(cl_use_value)",-2},
{"USER-HOMEDIR-PATHNAME","cl_user_homedir_pathname",-1},
{"VALUES","cl_values",-1},
{"VALUES-LIST","cl_values_list",1},
{"VARIABLE",NULL,-1},
{"VECTOR","ECL_NAME(cl_vector)",-1},
{"VECTOR-POP","ECL_NAME(cl_vector_pop)",1},
{"VECTOR-PUSH","cl_vector_push",2},
{"VECTOR-PUSH-EXTEND","cl_vector_push_extend",-3},
{"VECTORP","cl_vectorp",1},
{"WARN",NULL,-1},
{"WARNING",NULL,-1},
{"WHEN",NULL,-1},
{"WILD-PATHNAME-P","cl_wild_pathname_p",-2},
{"WITH-COMPILATION-UNIT",NULL,-1},
{"WITH-CONDITION-RESTARTS",NULL,-1},
{"WITH-HASH-TABLE-ITERATOR",NULL,-1},
{"WITH-INPUT-FROM-STRING",NULL,-1},
{"WITH-OPEN-FILE",NULL,-1},
{"WITH-OPEN-STREAM",NULL,-1},
{"WITH-OUTPUT-TO-STRING",NULL,-1},
{"WITH-PACKAGE-ITERATOR",NULL,-1},
{"WITH-SIMPLE-RESTART",NULL,-1},
{"WITH-STANDARD-IO-SYNTAX",NULL,-1},
{"WRITE","cl_write",-2},
{"WRITE-BYTE","cl_write_byte",2},
{"WRITE-CHAR","cl_write_char",-2},
{"WRITE-LINE","cl_write_line",-2},
{"WRITE-SEQUENCE","cl_write_sequence",-3},
{"WRITE-STRING","cl_write_string",-2},
{"WRITE-TO-STRING","ECL_NAME(cl_write_to_string)",-2},
{"Y-OR-N-P","ECL_NAME(cl_y_or_n_p)",-1},
{"YES-OR-NO-P","ECL_NAME(cl_yes_or_no_p)",-1},
{"ZEROP","cl_zerop",1},
{"ALLOCATE-INSTANCE",NULL,2},
{"ADD-METHOD",NULL,-1},
{"BUILT-IN-CLASS",NULL,-1},
{"CALL-METHOD",NULL,-1},
{"CALL-NEXT-METHOD",NULL,-1},
{"CHANGE-CLASS",NULL,-1},
{"CLASS",NULL,-1},
{"CLASS-NAME",NULL,-1},
{"CLASS-OF","cl_class_of",1},
{"COMPUTE-APPLICABLE-METHODS",NULL,-1},
{"DEFCLASS",NULL,-1},
{"DEFGENERIC",NULL,-1},
{"DEFINE-METHOD-COMBINATION",NULL,-1},
{"DEFMETHOD",NULL,-1},
{"DESCRIBE-OBJECT",NULL,-1},
{"ENSURE-GENERIC-FUNCTION",NULL,-2},
{"FIND-CLASS","cl_find_class",-2},
{"FIND-METHOD",NULL,-1},
{"GENERIC-FUNCTION",NULL,-1},
{"IF",NULL,-1},
{"INITIALIZE-INSTANCE",NULL,-1},
{"INVALID-METHOD-ERROR","ECL_NAME(cl_invalid_method_error)",-3},
{"MAKE-INSTANCE",NULL,-1},
{"MAKE-INSTANCES-OBSOLETE",NULL,-1},
{"MAKE-LOAD-FORM",NULL,-1},
{"MAKE-LOAD-FORM-SAVING-SLOTS",NULL,-1},
{"MAKE-METHOD",NULL,-1},
{"METHOD",NULL,-1},
{"METHOD-COMBINATION-ERROR","ECL_NAME(cl_method_combination_error)",-2},
{"METHOD-COMBINATION",NULL,-1},
{"METHOD-QUALIFIERS",NULL,-1},
{"NEXT-METHOD-P",NULL,-1},
{"NO-APPLICABLE-METHOD",NULL,-1},
{"NO-NEXT-METHOD",NULL,-1},
{"PRINT-OBJECT",NULL,-1},
{"PRINT-UNREADABLE-OBJECT",NULL,-1},
{"REINITIALIZE-INSTANCE",NULL,-1},
{"REMOVE-METHOD",NULL,-1},
{"SHARED-INITIALIZE",NULL,-1},
{"SLOT-BOUNDP","ECL_NAME(cl_slot_boundp)",2},
{"SLOT-EXISTS-P","ECL_NAME(cl_slot_exists_p)",2},
{"SLOT-MAKUNBOUND","ECL_NAME(cl_slot_makunbound)",2},
{"SLOT-MISSING",NULL,-1},
{"SLOT-UNBOUND",NULL,-1},
{"SLOT-VALUE","cl_slot_value",2},
{"STANDARD",NULL,-1},
{"STANDARD-CLASS",NULL,-1},
{"STANDARD-GENERIC-FUNCTION",NULL,-1},
{"STANDARD-METHOD",NULL,-1},
{"STANDARD-OBJECT",NULL,-1},
{"STRUCTURE-CLASS",NULL,-1},
{"STRUCTURE-OBJECT",NULL,-1},
{"UPDATE-INSTANCE-FOR-DIFFERENT-CLASS",NULL,-1},
{"UPDATE-INSTANCE-FOR-REDEFINED-CLASS",NULL,-1},
{"WITH-ACCESSORS",NULL,-1},
{"WITH-SLOTS",NULL,-1},
{KEY_ "ACCESSOR",NULL,-1},
{KEY_ "ARGUMENT-PRECEDENCE-ORDER",NULL,-1},
{KEY_ "ALLOCATION",NULL,-1},
{KEY_ "DECLARE",NULL,-1},
{KEY_ "DEFAULT-INITARGS",NULL,-1},
{KEY_ "DESCRIPTION",NULL,-1},
{KEY_ "DIRECT-DEFAULT-INITARGS",NULL,-1},
{KEY_ "DIRECT-SLOTS",NULL,-1},
{KEY_ "DIRECT-SUPERCLASSES",NULL,-1},
{KEY_ "GENERIC-FUNCTION-CLASS",NULL,-1},
{KEY_ "IDENTITY-WITH-ONE-ARGUMENT",NULL,-1},
{KEY_ "INITARG",NULL,-1},
{KEY_ "INITARGS",NULL,-1},
{KEY_ "INITFORM",NULL,-1},
{KEY_ "INITFUNCTION",NULL,-1},
{KEY_ "LAMBDA-LIST",NULL,-1},
{KEY_ "LOCATION",NULL,-1},
{KEY_ "METACLASS",NULL,-1},
{KEY_ "METHOD",NULL,-1},
{KEY_ "METHOD-CLASS",NULL,-1},
{KEY_ "METHOD-COMBINATION",NULL,-1},
{KEY_ "OPERATOR",NULL,-1},
{KEY_ "ORDER",NULL,-1},
{KEY_ "READER",NULL,-1},
{KEY_ "READERS",NULL,-1},
{KEY_ "REQUIRED",NULL,-1},
{KEY_ "WRITER",NULL,-1},
{KEY_ "WRITERS",NULL,-1},

/* SYSTEM PACKAGE */
{SYS_ "#!",NULL,-1},
{SYS_ "*BACKQ-LEVEL*",NULL,-1},
{SYS_ "*CBLOCK*",NULL,-1},
{SYS_ "*CIRCLE-COUNTER*",NULL,-1},
{SYS_ "*CIRCLE-STACK*",NULL,-1},
{SYS_ "*CLASS-NAME-HASH-TABLE*",NULL,-1},
{SYS_ "*COMPILER-CONSTANTS*",NULL,-1},
{SYS_ "*GC-MESSAGE*",NULL,-1},
{SYS_ "*GC-VERBOSE*",NULL,-1},
{SYS_ "*IGNORE-EOF-ON-TERMINAL-IO*",NULL,-1},
{SYS_ "*INDENT-FORMATTED-OUTPUT*",NULL,-1},
{SYS_ "*INIT-FUNCTION-PREFIX*",NULL,-1},
{SYS_ "*KEEP-DEFINITIONS*",NULL,-1},
{EXT_ "*LOAD-HOOKS*",NULL,-1},
{SYS_ "*LOAD-SEARCH-LIST*",NULL,-1},
{SYS_ "*MAKE-CONSTANT","si_Xmake_constant",2},
{SYS_ "*MAKE-SPECIAL","si_Xmake_special",1},
{SYS_ "*PRINT-PACKAGE*",NULL,-1},
{SYS_ "*PRINT-STRUCTURE*",NULL,-1},
{SYS_ "*SHARP-EQ-CONTEXT*",NULL,-1},
{SYS_ "*STEP-LEVEL*","OBJNULL",-1},
{SYS_ "*STEP-ACTION*","OBJNULL",-1},
{SYS_ ".",NULL,-1},
{SYS_ "UNQUOTE",NULL,-1},
{SYS_ "UNQUOTE-NSPLICE",NULL,-1},
{SYS_ "UNQUOTE-SPLICE",NULL,-1},
{SYS_ "ALLOCATE-RAW-INSTANCE","si_allocate_raw_instance",3},
{EXT_ "ARGC","si_argc",0},
{EXT_ "ARGV","si_argv",1},
{SYS_ "ASET","si_aset",-2},
{SYS_ "BASE-CHAR-P","si_base_char_p",1},
{SYS_ "BASE-STRING-P","si_base_string_p",1},
{SYS_ "BC-DISASSEMBLE","si_bc_disassemble",1},
{SYS_ "BC-SPLIT","si_bc_split",1},
{SYS_ "BC-JOIN","si_bc_join",4},
{SYS_ "BDS-TOP","si_bds_top",0},
{SYS_ "BDS-VAL","si_bds_val",1},
{SYS_ "BDS-VAR","si_bds_var",1},
{SYS_ "BIT-ARRAY-OP","si_bit_array_op",4},
{SYS_ "C-ARGUMENTS-LIMIT",NULL,-1},
{SYS_ "CHAR-SET","si_char_set",3},
{EXT_ "CHDIR","si_chdir",-2},
{SYS_ "CLEAR-COMPILER-PROPERTIES","cl_identity",1},
{SYS_ "COERCE-TO-BASE-STRING","si_coerce_to_base_string",1},
{SYS_ "COERCE-TO-EXTENDED-STRING","si_coerce_to_extended_string",1},
{SYS_ "COERCE-TO-FILENAME","si_coerce_to_filename",1},
{SYS_ "COERCE-TO-FUNCTION","si_coerce_to_function",1},
{SYS_ "COERCE-TO-PACKAGE","si_coerce_to_package",1},
{SYS_ "COPY-TO-SIMPLE-BASE-STRING","si_copy_to_simple_base_string",1},
{SYS_ "COMPILED-FUNCTION-BLOCK","si_compiled_function_block",1},
{EXT_ "COMPILED-FUNCTION-NAME","si_compiled_function_name",1},
{SYS_ "COPY-STREAM","si_copy_stream",3},
{SYS_ "DESTRUCTURE",NULL,-1},
{SYS_ "DO-READ-SEQUENCE","si_do_read_sequence",4},
{SYS_ "DO-WRITE-SEQUENCE","si_do_write_sequence",4},
{SYS_ "ELT-SET","si_elt_set",3},
{SYS_ "EVAL-WITH-ENV","si_eval_with_env",-2},
{SYS_ "EXPAND-DEFMACRO",NULL,-1},
{SYS_ "FILE-COLUMN","si_file_column",1},
{EXT_ "FILE-KIND","si_file_kind",2},
{SYS_ "FILL-POINTER-SET","si_fill_pointer_set",2},
{EXT_ "FILE-STREAM-FD","si_file_stream_fd",1},
{EXT_ "MAKE-STREAM-FROM-FD",NULL,-1},
{EXT_ "FIXNUMP","si_fixnump",1},
{SYS_ "FORMAT-ERROR",NULL,-1},
#ifdef ECL_CMU_FORMAT
{SYS_ "FORMATTER-AUX",NULL,-3},
#else
{SYS_ "FORMATTER-AUX","si_formatter_aux",-3},
#endif
{SYS_ "FRS-BDS","si_frs_bds",1},
{SYS_ "FRS-IHS","si_frs_ihs",1},
{SYS_ "FRS-TAG","si_frs_tag",1},
{SYS_ "FRS-TOP","si_frs_top",0},
{SYS_ "FSET","si_fset",-3},
{SYS_ "FUNCTION-BLOCK-NAME","si_function_block_name",1},
{SYS_ "GET-LIBRARY-PATHNAME","si_get_library_pathname",0},
{SYS_ "GET-SYSPROP","si_get_sysprop",2},
{EXT_ "GETENV","si_getenv",1},
{EXT_ "GETCWD","si_getcwd",-1},
{EXT_ "GETPID","si_getpid",0},
{EXT_ "GETUID","si_getuid",0},
{SYS_ "HASH-SET","si_hash_set",3},
{SYS_ "HASH-TABLE-ITERATOR","si_hash_table_iterator",1},
{SYS_ "IHS-BDS","si_ihs_bds",1},
{SYS_ "IHS-ENV","si_ihs_env",1},
{SYS_ "IHS-FUN","si_ihs_fun",1},
{SYS_ "IHS-NEXT","si_ihs_next",1},
{SYS_ "IHS-PREV","si_ihs_prev",1},
{SYS_ "IHS-TOP","si_ihs_top",0},
{SYS_ "INTERPRETER-STACK","si_interpreter_stack",-1},
{SYS_ "LINK-FROM",NULL,-1},
{SYS_ "LINK-TO",NULL,-1},
{SYS_ "LOAD-SOURCE","si_load_source",4},
{SYS_ "LOGICAL-PATHNAME-P","si_logical_pathname_p",1},
{SYS_ "MACRO",NULL,-1},
{SYS_ "MAKE-LAMBDA","si_make_lambda",2},
{SYS_ "MAKE-PURE-ARRAY","si_make_pure_array",6},
{SYS_ "MAKE-STRING-OUTPUT-STREAM-FROM-STRING","si_make_string_output_stream_from_string",1},
{SYS_ "MAKE-STRUCTURE","si_make_structure",-2},
{SYS_ "MAKE-VECTOR","si_make_vector",6},
{SYS_ "MANGLE-NAME","si_mangle_name",-2},
{SYS_ "MEMBER1","si_member1",5},
{SYS_ "MEMQ","si_memq",2},
{SYS_ "MKDIR","si_mkdir",2},
{EXT_ "MKSTEMP","si_mkstemp",1},
{SYS_ "NEED-TO-MAKE-LOAD-FORM-P","si_need_to_make_load_form_p",1},
{SYS_ "RMDIR","si_rmdir",1},
{EXT_ "MAKE-PIPE","si_make_pipe",0},
/* package extensions */
{SYS_ "*IGNORE-PACKAGE-LOCKS*",NULL,-1},
{EXT_ "PACKAGE-LOCK","si_package_lock",2},
{EXT_ "PACKAGE-LOCKED-P","si_package_locked_p",1},
{SYS_ "LOCK-PACKAGE",NULL,1},
{SYS_ "UNLOCK-PACKAGE",NULL,1},
{SYS_ "WITHOUT-PACKAGE-LOCKS",NULL,1},
{SYS_ "WITH-UNLOCKED-PACKAGES",NULL,1},
{EXT_ "PACKAGE-LOCAL-NICKNAMES","si_package_local_nicknames",1},
{EXT_ "PACKAGE-LOCALLY-NICKNAMED-BY-LIST","si_package_locally_nicknamed_by_list",1},
{EXT_ "ADD-PACKAGE-LOCAL-NICKNAME",NULL,-1},
{EXT_ "REMOVE-PACKAGE-LOCAL-NICKNAME",NULL,-1},
{SYS_ "%ADD-PACKAGE-LOCAL-NICKNAME","si_add_package_local_nickname",3},
{SYS_ "%REMOVE-PACKAGE-LOCAL-NICKNAME","si_remove_package_local_nickname",2},
{SYS_ "PACKAGE-HASH-TABLES","si_package_hash_tables",1},
{SYS_ "PATHNAME-TRANSLATIONS","si_pathname_translations",-2},
{SYS_ "POINTER","si_pointer",1},
{SYS_ "PRETTY-PRINT-FORMAT",NULL,-1},
{SYS_ "PROCESS-DECLARATIONS","si_process_declarations",-2},
{SYS_ "PROCESS-LAMBDA","si_process_lambda",1},
{SYS_ "PROCESS-LAMBDA-LIST","si_process_lambda_list",2},
{SYS_ "PUT-F","si_put_f",3},
{SYS_ "PUT-PROPERTIES","si_put_properties",-2},
{SYS_ "PUT-SYSPROP","si_put_sysprop",3},
{SYS_ "PUTPROP","si_putprop",3},
{SYS_ "READTABLE-CASE-SET","si_readtable_case_set",2},
{SYS_ "REM-F","si_rem_f",2},
{SYS_ "REM-SYSPROP","si_rem_sysprop",2},
{SYS_ "REPLACE-ARRAY","si_replace_array",2},
{SYS_ "ROW-MAJOR-ASET","si_row_major_aset",3},
{EXT_ "SAFE-EVAL","ECL_NAME(si_safe_eval)",-3},
{SYS_ "SCH-FRS-BASE","si_sch_frs_base",2},
{SYS_ "SCHAR-SET","si_char_set",3},
{SYS_ "SERROR","si_serror",-3},
{SYS_ "SHARP-A-READER",NULL,-1},
{SYS_ "SHARP-S-READER",NULL,-1},
{SYS_ "SELECT-PACKAGE","si_select_package",1},
{SYS_ "SET-SYMBOL-PLIST","si_set_symbol_plist",2},
#if defined(HAVE_PUTENV) || defined(HAVE_SETENV)
{EXT_ "SETENV","si_setenv",2},
#else
{EXT_ "SETENV",NULL,-1},
#endif
{SYS_ "SETF-METHOD",NULL,-1},
{SYS_ "SETF-NAMEP",NULL,-1},
{SYS_ "SIMPLE-PROGRAM-ERROR","ECL_NAME(si_simple_program_error)",-2},
{SYS_ "SIGNAL-SIMPLE-ERROR","si_signal_simple_error",-5},
{SYS_ "SIGNAL-TYPE-ERROR","si_signal_type_error",2},
{SYS_ "SPECIALP","si_specialp",1},
{SYS_ "STANDARD-READTABLE","si_standard_readtable",0},
{SYS_ "STEPPER","OBJNULL",-1},
{SYS_ "BASE-STRING-CONCATENATE","si_base_string_concatenate",-1},
{SYS_ "STRING-TO-OBJECT","ECL_NAME(si_string_to_object)",-2},
{SYS_ "STRUCTURE-NAME","si_structure_name",1},
{SYS_ "STRUCTURE-PRINT-FUNCTION",NULL,-1},
{SYS_ "STRUCTURE-REF","si_structure_ref",3},
{SYS_ "STRUCTURE-SET","si_structure_set",4},
{SYS_ "STRUCTURE-SLOT-DESCRIPTIONS",NULL,-1},
{SYS_ "STRUCTURE-SUBTYPE-P","si_structure_subtype_p",2},
{SYS_ "STRUCTUREP","si_structurep",1},
{SYS_ "SVSET","si_svset",3},
{SYS_ "SYMBOL-MACRO",NULL,-1},
{EXT_ "SYSTEM","si_system",1},
{SYS_ "TERMINAL-INTERRUPT",NULL,-1},
{SYS_ "TOP-LEVEL",NULL,-1},
{SYS_ "UNIVERSAL-ERROR-HANDLER",NULL,-1},
{SYS_ "STACK-ERROR-HANDLER",NULL,-1},
{SYS_ "VALID-FUNCTION-NAME-P","si_valid_function_name_p",1},
{SYS_ "SEARCH-PRINT-CIRCLE","si_search_print_circle",1},
{SYS_ "WRITE-OBJECT-WITH-CIRCLE","si_write_object_with_circle",3},
{SYS_ "WRITE-OBJECT","si_write_object",2},
{SYS_ "WRITE-UGLY-OBJECT","si_write_ugly_object",2},

{SYS_ "COPY-INSTANCE","si_copy_instance",1},
{SYS_ "GENERIC-FUNCTION-P","si_generic_function_p",1},
{SYS_ "INSTANCE-REF","si_instance_ref",2},
{SYS_ "INSTANCE-SET","si_instance_set",3},
{SYS_ "INSTANCE-OBSOLETE-P","si_instance_obsolete_p",1},
{SYS_ "INSTANCE-NEW-STAMP","si_instance_new_stamp",1},
{SYS_ "INSTANCE-GET-STAMP","si_instance_get_stamp",1},
{SYS_ "INSTANCE-SLOTDS","si_instance_slotds",1},
{SYS_ "INSTANCE-SIG-SET","si_instance_sig_set",1},
{SYS_ "INSTANCE-CLASS","si_instance_class",1},
{SYS_ "INSTANCE-CLASS-SET","si_instance_class_set",2},
{SYS_ "INSTANCEP","si_instancep",1},
{SYS_ "SL-BOUNDP","si_sl_boundp",1},
{SYS_ "SL-MAKUNBOUND","si_sl_makunbound",2},
{SYS_ "SUBCLASSP","ECL_NAME(si_subclassp)",-3},
{SYS_ "OF-CLASS-P","ECL_NAME(si_of_class_p)",-3},
/*{SYS_ "UNBOUND","si_unbound",0}, */

{EXT_ "*SOURCE-LOCATION*",NULL,-1},
{EXT_ "*REGISTER-WITH-PDE-HOOK*",NULL,-1},
{EXT_ "REGISTER-WITH-PDE",NULL,-1},

/* #ifdef PROFILE */
{SYS_ "PROFILE",IF_PROFILE("si_profile"),-3},
{SYS_ "CLEAR-PROFILE",IF_PROFILE("si_clear_profile"),-1},
{SYS_ "DISPLAY-PROFILE",IF_PROFILE("si_display_profile"),-1},
/* #endif PROFILE */

/* #ifdef TCP */
{SYS_ "*PROFILE-ARRAY*",NULL,-1},
{SYS_ "OPEN-CLIENT-STREAM",IF_TCP("si_open_client_stream"),2},
{SYS_ "OPEN-SERVER-STREAM",IF_TCP("si_open_server_stream"),1},
{SYS_ "OPEN-UNIX-SOCKET-STREAM",IF_TCP("si_open_unix_socket_stream"),1},
{SYS_ "LOOKUP-HOST-ENTRY",IF_TCP("si_lookup_host_entry"),1},
/* #endif TCP */

{EXT_ "CATCH-SIGNAL","si_catch_signal",-3},
{EXT_ "GET-SIGNAL-HANDLER","si_get_signal_handler",1},
{EXT_ "SET-SIGNAL-HANDLER","si_set_signal_handler",2},

/* KEYWORD PACKAGE */
{KEY_ "ADJUSTABLE",NULL,-1},
{KEY_ "ABORT",NULL,-1},
{KEY_ "ABSOLUTE",NULL,-1},
{KEY_ "ALLOW-OTHER-KEYS",NULL,-1},
{KEY_ "APPEND",NULL,-1},
{KEY_ "ARRAY",NULL,-1},
{KEY_ "BACK",NULL,-1},
{KEY_ "BASE",NULL,-1},
{KEY_ "BLOCK",NULL,-1},
{KEY_ "CAPITALIZE",NULL,-1},
{KEY_ "CATCH",NULL,-1},
{KEY_ "CASE",NULL,-1},
{KEY_ "CIRCLE",NULL,-1},
{KEY_ "COMPILE-TOPLEVEL",NULL,-1},
{KEY_ "COMMON",NULL,-1},
{KEY_ "CONC-NAME",NULL,-1},
{KEY_ "CONSTRUCTOR",NULL,-1},
{KEY_ "CONTROL-STRING",NULL,-1},
{KEY_ "COPIER",NULL,-1},
{KEY_ "CREATE",NULL,-1},
{KEY_ "DATUM",NULL,-1},
{KEY_ "DEFAULT",NULL,-1},
{KEY_ "DEFAULTS",NULL,-1},
{KEY_ "DEVICE",NULL,-1},
{KEY_ "DIRECTION",NULL,-1},
{KEY_ "DIRECTORY",NULL,-1},
{KEY_ "DISPLACED-INDEX-OFFSET",NULL,-1},
{KEY_ "DISPLACED-TO",NULL,-1},
{KEY_ "DOCUMENTATION",NULL,-1},
{KEY_ "DOWNCASE",NULL,-1},
{KEY_ "ELEMENT-TYPE",NULL,-1},
{KEY_ "END",NULL,-1},
{KEY_ "END1",NULL,-1},
{KEY_ "END2",NULL,-1},
{KEY_ "EOF",NULL,-1},
{KEY_ "ERROR",NULL,-1},
{KEY_ "ESCAPE",NULL,-1},
{KEY_ "EXECUTE",NULL,-1},
{KEY_ "EXPECTED-TYPE",NULL,-1},
{KEY_ "EXPORT",NULL,-1},
{KEY_ "EXPORT-FROM",NULL,-1},
{KEY_ "EXTERNAL",NULL,-1},
{KEY_ "EXTERNAL-FORMAT",NULL,-1},
{KEY_ "FIFO",NULL,-1},
{KEY_ "FILE",NULL,-1},
{KEY_ "FILL-POINTER",NULL,-1},
{KEY_ "FORMAT-ARGUMENTS",NULL,-1},
{KEY_ "FORMAT-CONTROL",NULL,-1},
{KEY_ "FUNCTION",NULL,-1},
{KEY_ "GENSYM",NULL,-1},
{KEY_ "HASH-FUNCTION",NULL,-1},
{KEY_ "HOST",NULL,-1},
{KEY_ "IF-DOES-NOT-EXIST",NULL,-1},
{KEY_ "IF-ERROR-EXISTS",NULL,-1},
{KEY_ "IF-EXISTS",NULL,-1},
{KEY_ "IF-INPUT-DOES-NOT-EXIST",NULL,-1},
{KEY_ "IF-OUTPUT-EXISTS",NULL,-1},
{KEY_ "IGNORE",NULL,-1},
{KEY_ "IMPORT-FROM",NULL,-1},
{KEY_ "INCLUDE",NULL,-1},
{KEY_ "INHERITED",NULL,-1},
{KEY_ "INITIAL-ELEMENT",NULL,-1},
{KEY_ "INITIAL-CONTENTS",NULL,-1},
{KEY_ "INITIAL-OFFSET",NULL,-1},
{KEY_ "INPUT",NULL,-1},
{KEY_ "INTERACTIVE",NULL,-1},
{KEY_ "INSTANCE",NULL,-1},
{KEY_ "INTERN",NULL,-1},
{KEY_ "INTERNAL",NULL,-1},
{KEY_ "INVERT",NULL,-1},
{KEY_ "IO",NULL,-1},
{KEY_ "JUNK-ALLOWED",NULL,-1},
{KEY_ "KEY",NULL,-1},
{KEY_ "LENGTH",NULL,-1},
{KEY_ "LEVEL",NULL,-1},
{KEY_ "LINES",NULL,-1},
{KEY_ "LINK",NULL,-1},
{KEY_ "LIST-ALL",NULL,-1},
{KEY_ "LOCAL",NULL,-1},
{KEY_ "LOCAL-NICKNAMES",NULL,-1},
{KEY_ "LOCKABLE",NULL,-1},
{KEY_ "LOAD-TOPLEVEL",NULL,-1},
{KEY_ "MASK",NULL,-1},
{KEY_ "MISER-WIDTH",NULL,-1},
{KEY_ "NAME",NULL,-1},
{KEY_ "NAMED",NULL,-1},
{KEY_ "NEW-VERSION",NULL,-1},
{KEY_ "NEWEST",NULL,-1},
{KEY_ "NICKNAMES",NULL,-1},
{KEY_ "OBJECT",NULL,-1},
{KEY_ "OFFSET",NULL,-1},
{KEY_ "OPERATION",NULL,-1},
{KEY_ "OPERANDS",NULL,-1},
{KEY_ "OUTPUT",NULL,-1},
{KEY_ "OVERWRITE",NULL,-1},
{KEY_ "PACKAGE",NULL,-1},
{KEY_ "PATHNAME",NULL,-1},
{KEY_ "PPRINT-DISPATCH",NULL,-1},
{KEY_ "PREDICATE",NULL,-1},
{KEY_ "PRESERVE",NULL,-1},
{KEY_ "PRETTY",NULL,-1},
{KEY_ "PRINT",NULL,-1},
{KEY_ "PRINT-FUNCTION",NULL,-1},
{KEY_ "PRINT-OBJECT",NULL,-1},
{KEY_ "PROBE",NULL,-1},
{KEY_ "PROCESS",NULL,-1},
{KEY_ "RADIX",NULL,-1},
{KEY_ "READABLY",NULL,-1},
{KEY_ "REHASH-SIZE",NULL,-1},
{KEY_ "REHASH-THRESHOLD",NULL,-1},
{KEY_ "RELATIVE",NULL,-1},
{KEY_ "RENAME",NULL,-1},
{KEY_ "RENAME-AND-DELETE",NULL,-1},
{KEY_ "REPORT",NULL,-1},
{KEY_ "RIGHT-MARGIN",NULL,-1},
{KEY_ "SET-DEFAULT-PATHNAME",NULL,-1},
{KEY_ "SEARCH-LIST",NULL,-1},
{KEY_ "SHADOW",NULL,-1},
{KEY_ "SHADOWING-IMPORT",NULL,-1},
{KEY_ "SIZE",NULL,-1},
{KEY_ "SPECIAL",NULL,-1},
{KEY_ "START",NULL,-1},
{KEY_ "START1",NULL,-1},
{KEY_ "START2",NULL,-1},
{KEY_ "STREAM",NULL,-1},
{KEY_ "SUPERSEDE",NULL,-1},
{KEY_ "TAG",NULL,-1},
{KEY_ "TEST",NULL,-1},
{KEY_ "TEST-NOT",NULL,-1},
{KEY_ "TRUNCATE",NULL,-1},
{KEY_ "TYPE",NULL,-1},
{KEY_ "UNSPECIFIC",NULL,-1},
{KEY_ "UNMASK",NULL,-1},
{KEY_ "UP",NULL,-1},
{KEY_ "UPCASE",NULL,-1},
{KEY_ "USE",NULL,-1},
{KEY_ "CSTREAM",NULL,-1},
{KEY_ "VERBOSE",NULL,-1},
{KEY_ "VERSION",NULL,-1},
{KEY_ "WILD",NULL,-1},
{KEY_ "WILD-INFERIORS",NULL,-1},
{KEY_ "WAIT",NULL,-1},

{EXT_ "BYTE8",NULL,-1},
{EXT_ "BYTE16",NULL,-1},
{EXT_ "BYTE32",NULL,-1},
{EXT_ "BYTE64",NULL,-1},
{EXT_ "COMPILER-LET",NULL,-1},
{EXT_ "INTEGER8",NULL,-1},
{EXT_ "INTEGER16",NULL,-1},
{EXT_ "INTEGER32",NULL,-1},
{EXT_ "INTEGER64",NULL,-1},
{EXT_ "LAMBDA-BLOCK",NULL,-1},
{EXT_ "QUIT","si_quit",-1},
{EXT_ "GET-METHOD",NULL,-1},
{EXT_ "INSTANCE",NULL,-1},

{SYS_ "ALLOCATE-FOREIGN-DATA","si_allocate_foreign_data",2},
{SYS_ "FIND-FOREIGN-SYMBOL","si_find_foreign_symbol",4},
{SYS_ "FOREIGN-DATA",NULL,-1},
{SYS_ "FOREIGN-DATA-ADDRESS","si_foreign_data_address",1},
{SYS_ "FOREIGN-DATA-EQUAL","si_foreign_data_equal",2},
{SYS_ "FOREIGN-DATA-P","si_foreign_data_p",1},
{SYS_ "FOREIGN-DATA-POINTER","si_foreign_data_pointer",4},
{SYS_ "FOREIGN-DATA-RECAST","si_foreign_data_recast",3},
{SYS_ "FOREIGN-DATA-REF","si_foreign_data_ref",4},
{SYS_ "FOREIGN-DATA-REF-ELT","si_foreign_data_ref_elt",3},
{SYS_ "FOREIGN-DATA-SET","si_foreign_data_set",3},
{SYS_ "FOREIGN-DATA-SET-ELT","si_foreign_data_set_elt",4},
{SYS_ "FOREIGN-DATA-TAG","si_foreign_data_tag",1},
{SYS_ "FOREIGN-ELT-TYPE-P","si_foreign_elt_type_p",1},
{SYS_ "FREE-FOREIGN-DATA","si_free_foreign_data",1},
{SYS_ "MAKE-FOREIGN-DATA-FROM-ARRAY","si_make_foreign_data_from_array",1},
{SYS_ "LOAD-FOREIGN-MODULE","si_load_foreign_module",1},
{SYS_ "UNLOAD-FOREIGN-MODULE","si_unload_foreign_module",1},
{SYS_ "NULL-POINTER-P","si_null_pointer_p",1},
{SYS_ "SIZE-OF-FOREIGN-ELT-TYPE","si_size_of_foreign_elt_type",1},
{SYS_ "ALIGNMENT-OF-FOREIGN-ELT-TYPE","si_alignment_of_foreign_elt_type",1},
{KEY_ "BYTE",NULL,-1},
{KEY_ "CHAR",NULL,-1},
{KEY_ "CSFLOAT",NULL,-1},
{KEY_ "CDFLOAT",NULL,-1},
{KEY_ "CLFLOAT",NULL,-1},
{KEY_ "CSTRING",NULL,-1},
{KEY_ "DOUBLE",NULL,-1},
{KEY_ "FIXNUM",NULL,-1},
{KEY_ "FLOAT",NULL,-1},
{KEY_ "INT",NULL,-1},
{KEY_ "INT8-T",NULL,-1},
{KEY_ "INT16-T",NULL,-1},
{KEY_ "INT32-T",NULL,-1},
{KEY_ "INT64-T",NULL,-1},
{KEY_ "LONG",NULL,-1},
{KEY_ "LONG-DOUBLE",NULL,-1},
{KEY_ "LONG-LONG",NULL,-1},
{KEY_ "POINTER-SELF",NULL,-1},
{KEY_ "POINTER-VOID",NULL,-1},
{KEY_ "SHORT",NULL,-1},
{KEY_ "STRUCT",NULL,-1},
{KEY_ "UNION",NULL,-1},
{KEY_ "VOID",NULL,-1},
{KEY_ "UINT8-T",NULL,-1},
{KEY_ "UINT16-T",NULL,-1},
{KEY_ "UINT32-T",NULL,-1},
{KEY_ "UINT64-T",NULL,-1},
{KEY_ "UNSIGNED-BYTE",NULL,-1},
{KEY_ "UNSIGNED-CHAR",NULL,-1},
{KEY_ "UNSIGNED-INT",NULL,-1},
{KEY_ "UNSIGNED-LONG",NULL,-1},
{KEY_ "UNSIGNED-LONG-LONG",NULL,-1},
{KEY_ "UNSIGNED-SHORT",NULL,-1},

#ifdef GBC_BOEHM
{EXT_ "GC","si_gc",-1},
{SYS_ "GC-DUMP","si_gc_dump",0},
{SYS_ "GC-STATS","si_gc_stats",1},
#else
{EXT_ "GC","si_gc",-2},
{SYS_ "ALLOCATE","si_allocate",-3},
{SYS_ "ALLOCATED-PAGES","si_allocated_pages",-2},
{SYS_ "MAXIMUM-ALLOCATABLE-PAGES","si_maximum_allocatable_pages",-2},
{SYS_ "ALLOCATE-CONTIGUOUS-PAGES","si_allocate_contiguous_pages",-2},
{SYS_ "ALLOCATED-CONTIGUOUS-PAGES","si_allocated_contiguous_pages",-1},
{SYS_ "MAXIMUM-CONTIGUOUS-PAGES","si_maximum_contiguous_pages",-1},
{SYS_ "GC-TIME","si_gc_time",-1},
{SYS_ "GET-HOLE-SIZE","si_get_hole_size",-1},
{SYS_ "SET-HOLE-SIZE","si_set_hole_size",-2},
{SYS_ "IGNORE-MAXIMUM-PAGES","si_ignore_maximum_pages",-1},
{SYS_ "ROOM-REPORT","si_room_report",-1},
{SYS_ "RESET-GC-COUNT","si_reset_gc_count",-1},
#endif /* !GBC_BOEHM */

/* #ifdef ECL_THREADS */
{MP_ "PROCESS",NULL,-1},
{MP_ "LOCK",NULL,-1},
{MP_ "CONDITION-VARIABLE",NULL,-1},
{MP_ "*CURRENT-PROCESS*",NULL,-1},
{MP_ "ALL-PROCESSES",IF_MP("mp_all_processes"),0},
{MP_ "EXIT-PROCESS",IF_MP("mp_exit_process"),0},
{MP_ "MAKE-PROCESS",IF_MP("mp_make_process"),-1},
{MP_ "PROCESS-ACTIVE-P",IF_MP("mp_process_active_p"),1},
{MP_ "PROCESS-ENABLE",IF_MP("mp_process_enable"),1},
{MP_ "PROCESS-YIELD",IF_MP("mp_process_yield"),0},
{MP_ "PROCESS-KILL",IF_MP("mp_process_kill"),1},
{MP_ "PROCESS-NAME",IF_MP("mp_process_name"),1},
{MP_ "PROCESS-PRESET",IF_MP("mp_process_preset"),-3},
{MP_ "PROCESS-RUN-FUNCTION",IF_MP("mp_process_run_function"),-3},
{MP_ "PROCESS-WHOSTATE",IF_MP("mp_process_whostate"),1},
{MP_ "PROCESS-JOIN",IF_MP("mp_process_join"),1},
{MP_ "MAKE-LOCK",IF_MP("mp_make_lock"),-1},
{KEY_ "RECURSIVE",NULL,-1},
{MP_ "RECURSIVE-LOCK-P",IF_MP("mp_recursive_lock_p"),1},
{MP_ "HOLDING-LOCK-P",IF_MP("mp_holding_lock_p"),1},
{MP_ "LOCK-NAME",IF_MP("mp_lock_name"),1},
{MP_ "LOCK-OWNER",IF_MP("mp_lock_owner"),1},
{MP_ "LOCK-COUNT",IF_MP("mp_lock_count"),1},
{MP_ "GET-LOCK",IF_MP("mp_get_lock"),-2},
{MP_ "GIVEUP-LOCK",IF_MP("mp_giveup_lock"),1},
{MP_ "MAKE-CONDITION-VARIABLE",IF_MP("mp_make_condition_variable"),0},
{MP_ "CONDITION-VARIABLE-WAIT",IF_MP("mp_condition_variable_wait"),2},
{MP_ "CONDITION-VARIABLE-TIMEDWAIT",IF_MP("mp_condition_variable_timedwait"),3},
{MP_ "CONDITION-VARIABLE-SIGNAL",IF_MP("mp_condition_variable_signal"),1},
{MP_ "CONDITION-VARIABLE-BROADCAST",IF_MP("mp_condition_variable_broadcast"),1},
{KEY_ "INITIAL-BINDINGS",NULL,-1},
{MP_ "INTERRUPT-PROCESS",IF_MP("mp_interrupt_process"),2},
{MP_ "+LOAD-COMPILE-LOCK+",NULL,-1},
{MP_ "WITH-LOCK",NULL,-1},
{MP_ "WITH-RWLOCK",NULL,-1},
{MP_ "BLOCK-SIGNALS",IF_MP("mp_block_signals"),0},
{MP_ "RESTORE-SIGNALS",IF_MP("mp_restore_signals"),1},
{MP_ "PROCESS-SUSPEND",IF_MP("mp_process_suspend"),1},
{MP_ "PROCESS-RESUME",IF_MP("mp_process_resume"),1},
{MP_ "SUSPEND-LOOP",IF_MP("mp_suspend_loop"),0},
{MP_ "BREAK-SUSPEND-LOOP",IF_MP("mp_break_suspend_loop"),0},
{MP_ "MAKE-RWLOCK",IF_MP("mp_make_rwlock"),-1},
{MP_ "RWLOCK",NULL,-1},
{MP_ "RWLOCK-NAME",IF_MP("mp_rwlock_name"),1},
{MP_ "GET-RWLOCK-READ",IF_MP("mp_get_rwlock_read"),-2},
{MP_ "GET-RWLOCK-WRITE",IF_MP("mp_get_rwlock_write"),-2},
{MP_ "GIVEUP-RWLOCK-READ",IF_MP("mp_giveup_rwlock_read"),1},
{MP_ "GIVEUP-RWLOCK-WRITE",IF_MP("mp_giveup_rwlock_write"),1},
{MP_ "GLOBAL-LOCK",NULL,-1},
{MP_ "ERROR-LOCK",NULL,-1},

{MP_ "SEMAPHORE",NULL,-1},
{MP_ "MAKE-SEMAPHORE",IF_MP("mp_make_semaphore"),-1},
{MP_ "SIGNAL-SEMAPHORE",IF_MP("mp_signal_semaphore"),-2},
{MP_ "WAIT-ON-SEMAPHORE",IF_MP("mp_wait_on_semaphore"),1},
{MP_ "TRY-GET-SEMAPHORE",IF_MP("mp_try_get_semaphore"),1},
{MP_ "SEMAPHORE-COUNT",IF_MP("mp_semaphore_count"),1},
{MP_ "SEMAPHORE-NAME",IF_MP("mp_semaphore_name"),1},
{MP_ "SEMAPHORE-WAIT-COUNT",IF_MP("mp_semaphore_wait_count"),1},
{KEY_ "COUNT",NULL,-1},

{MP_ "BARRIER",NULL,-1},
{MP_ "MAKE-BARRIER",IF_MP("mp_make_barrier"),-2},
{MP_ "BARRIER-UNBLOCK",IF_MP("mp_barrier_unblock"),-2},
{MP_ "BARRIER-WAIT",IF_MP("mp_barrier_wait"),1},
{MP_ "BARRIER-COUNT",IF_MP("mp_barrier_count"),1},
{MP_ "BARRIER-NAME",IF_MP("mp_barrier_name"),1},
{MP_ "BARRIER-ARRIVERS-COUNT",IF_MP("mp_barrier_arrivers_count"),1},
{KEY_ "DISABLE",NULL,-1},
{KEY_ "RESET-COUNT",NULL,-1},
{KEY_ "KILL-WAITING",NULL,-1},
{KEY_ "UNBLOCKED",NULL,-1},

{MP_ "MAILBOX",NULL,-1},
{MP_ "MAKE-MAILBOX",IF_MP("mp_make_mailbox"),-1},
{MP_ "MAILBOX-NAME",IF_MP("mp_mailbox_name"),1},
{MP_ "MAILBOX-COUNT",IF_MP("mp_mailbox_count"),1},
{MP_ "MAILBOX-EMPTY-P",IF_MP("mp_mailbox_empty_p"),1},
{MP_ "MAILBOX-READ",IF_MP("mp_mailbox_read"),1},
{MP_ "MAILBOX-TRY-READ",IF_MP("mp_mailbox_try_read"),1},
{MP_ "MAILBOX-SEND",IF_MP("mp_mailbox_send"),2},
{MP_ "MAILBOX-TRY-SEND",IF_MP("mp_mailbox_try_send"),2},
{MP_ "COMPARE-AND-SWAP-CAR",IF_MP("mp_compare_and_swap_car"),3},
{MP_ "COMPARE-AND-SWAP-CDR",IF_MP("mp_compare_and_swap_cdr"),3},
{MP_ "COMPARE-AND-SWAP-SYMBOL-PLIST",IF_MP("mp_compare_and_swap_symbol_plist"),3},
{MP_ "COMPARE-AND-SWAP-SYMBOL-VALUE",IF_MP("mp_compare_and_swap_symbol_value"),3},
{MP_ "COMPARE-AND-SWAP-SVREF",IF_MP("mp_compare_and_swap_svref"),4},
{MP_ "COMPARE-AND-SWAP-INSTANCE",IF_MP("mp_compare_and_swap_instance"),4},
{MP_ "COMPARE-AND-SWAP-STRUCTURE",IF_MP("mp_compare_and_swap_structure"),5},
{MP_ "ATOMIC-INCF-CAR",IF_MP("mp_atomic_incf_car"),2},
{MP_ "ATOMIC-INCF-CDR",IF_MP("mp_atomic_incf_cdr"),2},
{MP_ "ATOMIC-INCF-SYMBOL-VALUE",IF_MP("mp_atomic_incf_symbol_value"),2},
{MP_ "ATOMIC-INCF-SVREF",IF_MP("mp_atomic_incf_svref"),3},
{MP_ "ATOMIC-INCF-INSTANCE",IF_MP("mp_atomic_incf_instance"),3},
{MP_ "DEFINE-CAS-EXPANDER",NULL,-1},
{MP_ "DEFCAS",NULL,-1},
{MP_ "REMCAS",NULL,-1},
{MP_ "GET-CAS-EXPANSION",NULL,-1},
{MP_ "COMPARE-AND-SWAP",NULL,-1},
{MP_ "ATOMIC-UPDATE",NULL,-1},
{MP_ "ATOMIC-PUSH",NULL,-1},
{MP_ "ATOMIC-POP",NULL,-1},
{MP_ "ATOMIC-INCF",NULL,-1},
{MP_ "ATOMIC-DECF",NULL,-1},
/* #endif defined(ECL_THREADS) */

{SYS_ "WHILE",NULL,-1},
{SYS_ "UNTIL",NULL,-1},
{SYS_ "QUASIQUOTE",NULL,-1},
{SYS_ "*EXIT-HOOKS*",NULL,-1},

{CLOS_ ".COMBINED-METHOD-ARGS.",NULL,-1},
{CLOS_ "+BUILTIN-CLASSES+",NULL,-1},
{CLOS_ "*NEXT-METHODS*",NULL,-1},
{CLOS_ "*OPTIMIZE-SLOT-ACCESS*",NULL,-1},
{CLOS_ "+THE-T-CLASS+",NULL,-1},
{CLOS_ "+THE-CLASS+",NULL,-1},
{CLOS_ "+THE-STD-CLASS+",NULL,-1},
{CLOS_ "+THE-STANDARD-CLASS+",NULL,-1},
{CLOS_ "+THE-FUNCALLABLE-STANDARD-CLASS+",NULL,-1},
{CLOS_ "ACCESSOR-METHOD-SLOT-DEFINITION",NULL,-1},
{CLOS_ "ADD-DEPENDENT",NULL,-1},
{CLOS_ "ADD-DIRECT-METHOD",NULL,-1},
{CLOS_ "ADD-DIRECT-SUBCLASS",NULL,-1},
{CLOS_ "CLASS-DEFAULT-INITARGS",NULL,-1},
{CLOS_ "CLASS-DIRECT-DEFAULT-INITARGS",NULL,-1},
{CLOS_ "CLASS-DIRECT-SLOTS",NULL,-1},
{CLOS_ "CLASS-DIRECT-SUBCLASSES",NULL,-1},
{CLOS_ "CLASS-DIRECT-SUPERCLASSES",NULL,-1},
{CLOS_ "CLASS-FINALIZED-P",NULL,-1},
{CLOS_ "CLASS-PRECEDENCE-LIST",NULL,-1},
{CLOS_ "CLASS-PROTOTYPE",NULL,-1},
{CLOS_ "CLASS-SLOTS",NULL,-1},
{CLOS_ "COMPUTE-APPLICABLE-METHODS-USING-CLASSES",NULL,-1},
{CLOS_ "COMPUTE-CLASS-PRECEDENCE-LIST",NULL,-1},
{CLOS_ "COMPUTE-DEFAULT-INITARGS",NULL,-1},
{CLOS_ "COMPUTE-DISCRIMINATING-FUNCTION",NULL,-1},
{CLOS_ "COMPUTE-EFFECTIVE-METHOD",NULL,-1},
{CLOS_ "COMPUTE-EFFECTIVE-SLOT-DEFINITION",NULL,-1},
{CLOS_ "COMPUTE-SLOTS",NULL,-1},
{CLOS_ "DIRECT-SLOT-DEFINITION",NULL,-1},
{CLOS_ "DIRECT-SLOT-DEFINITION-CLASS",NULL,-1},
{CLOS_ "EFFECTIVE-SLOT-DEFINITION",NULL,-1},
{CLOS_ "EFFECTIVE-SLOT-DEFINITION-CLASS",NULL,-1},
{CLOS_ "ENSURE-CLASS","ECL_NAME(clos_ensure_class)",-2},
{CLOS_ "ENSURE-CLASS-USING-CLASS",NULL,-1},
{CLOS_ "ENSURE-GENERIC-FUNCTION-USING-CLASS",NULL,-3},
{CLOS_ "EQL-SPECIALIZER",NULL,-1},
{CLOS_ "EQL-SPECIALIZER-OBJECT",NULL,-1},
{CLOS_ "EXTRACT-LAMBDA-LIST","ECL_NAME(clos_extract_lambda_list)",1},
{CLOS_ "EXTRACT-SPECIALIZER-NAMES","ECL_NAME(clos_extract_specializer_names)",1},
{CLOS_ "FINALIZE-INHERITANCE",NULL,-1},
{CLOS_ "FIND-METHOD-COMBINATION",NULL,-1},
{CLOS_ "FORWARD-REFERENCED-CLASS",NULL,-1},
{CLOS_ "FUNCALLABLE-STANDARD-CLASS",NULL,-1},
{CLOS_ "FUNCALLABLE-STANDARD-INSTANCE-ACCESS","ECL_NAME(clos_funcallable_standard_instance_access)",2},
{CLOS_ "FUNCALLABLE-STANDARD-OBJECT",NULL,-1},
{CLOS_ "GENERIC-FUNCTION-ARGUMENT-PRECEDENCE-ORDER",NULL,-1},
{CLOS_ "GENERIC-FUNCTION-DECLARATIONS",NULL,-1},
{CLOS_ "GENERIC-FUNCTION-LAMBDA-LIST",NULL,-1},
{CLOS_ "GENERIC-FUNCTION-METHOD-CLASS",NULL,-1},
{CLOS_ "GENERIC-FUNCTION-METHOD-COMBINATION",NULL,-1},
{CLOS_ "GENERIC-FUNCTION-METHODS",NULL,-1},
{CLOS_ "GENERIC-FUNCTION-NAME",NULL,-1},
{CLOS_ "INTERN-EQL-SPECIALIZER",NULL,-1},
{CLOS_ "LOCATION-TABLE",NULL,-1},
{CLOS_ "MAKE-METHOD-LAMBDA",NULL,-1},
{CLOS_ "MAP-DEPENDENTS",NULL,-1},
{CLOS_ "METAOBJECT",NULL,-1},
{CLOS_ "METHOD-FUNCTION",NULL,-1},
{CLOS_ "METHOD-GENERIC-FUNCTION",NULL,-1},
{CLOS_ "METHOD-LAMBDA-LIST",NULL,-1},
{CLOS_ "METHOD-SPECIALIZERS",NULL,-1},
{CLOS_ "NAME",NULL,-1},
{CLOS_ "READER-METHOD-CLASS",NULL,-1},
{CLOS_ "REMOVE-DEPENDENT",NULL,-1},
{CLOS_ "REMOVE-DIRECT-METHOD",NULL,-1},
{CLOS_ "REMOVE-DIRECT-SUBCLASS",NULL,-1},
{CLOS_ "SET-FUNCALLABLE-INSTANCE-FUNCTION","clos_set_funcallable_instance_function",2},
{CLOS_ "SLOT-BOUNDP-USING-CLASS",NULL,-1},
{CLOS_ "SLOT-DEFINITION",NULL,-1},
{CLOS_ "SLOT-DEFINITION-ALLOCATION",NULL,-1},
{CLOS_ "SLOT-DEFINITION-INITARGS",NULL,-1},
{CLOS_ "SLOT-DEFINITION-INITFORM",NULL,-1},
{CLOS_ "SLOT-DEFINITION-INITFUNCTION",NULL,-1},
{CLOS_ "SLOT-DEFINITION-LOCATION",NULL,-1},
{CLOS_ "SLOT-DEFINITION-NAME",NULL,-1},
{CLOS_ "SLOT-DEFINITION-READERS",NULL,-1},
{CLOS_ "SLOT-DEFINITION-TYPE",NULL,-1},
{CLOS_ "SLOT-DEFINITION-WRITERS",NULL,-1},
{CLOS_ "SLOT-MAKUNBOUND-USING-CLASS",NULL,-1},
{CLOS_ "SLOT-VALUE-USING-CLASS",NULL,-1},
{CLOS_ "SLOT-VALUE-SET","clos_slot_value_set",3},
{CLOS_ "SLOT-TABLE",NULL,-1},
{CLOS_ "SPECIALIZER",NULL,-1},
{CLOS_ "SPECIALIZER-DIRECT-GENERIC-FUNCTIONS",NULL,-1},
{CLOS_ "SPECIALIZER-DIRECT-METHODS",NULL,-1},
{CLOS_ "STANDARD-ACCESSOR-METHOD",NULL,-1},
{CLOS_ "STANDARD-DIRECT-SLOT-DEFINITION",NULL,-1},
{CLOS_ "STANDARD-EFFECTIVE-SLOT-DEFINITION",NULL,-1},
{CLOS_ "STANDARD-INSTANCE-ACCESS","ECL_NAME(clos_standard_instance_access)",2},
{CLOS_ "STANDARD-INSTANCE-SET","ECL_NAME(clos_standard_instance_set)",3},
{CLOS_ "STANDARD-READER-METHOD",NULL,-1},
{CLOS_ "STANDARD-SLOT-DEFINITION",NULL,-1},
{CLOS_ "STANDARD-WRITER-METHOD",NULL,-1},
{CLOS_ "STANDARD-OPTIMIZED-READER-METHOD",NULL,-1},
{CLOS_ "STANDARD-OPTIMIZED-WRITER-METHOD",NULL,-1},
{CLOS_ "STD-COMPUTE-APPLICABLE-METHODS","ECL_NAME(clos_std_compute_applicable_methods)",2},
{CLOS_ "STD-COMPUTE-APPLICABLE-METHODS-USING-CLASSES",NULL,2},
{CLOS_ "STD-COMPUTE-EFFECTIVE-METHOD","ECL_NAME(clos_std_compute_effective_method)",3},
{CLOS_ "COMPUTE-EFFECTIVE-METHOD-FUNCTION","ECL_NAME(clos_compute_effective_method_function)",3},
{CLOS_ "UPDATE-DEPENDENT",NULL,-1},
{CLOS_ "UPDATE-INSTANCE",NULL,1},
{CLOS_ "VALIDATE-SUPERCLASS",NULL,-1},
{CLOS_ "WRITER-METHOD-CLASS",NULL,-1},
{SYS_ "CLEAR-GFUN-HASH","si_clear_gfun_hash",1},
{CLOS_ "LOAD-DEFCLASS","ECL_NAME(clos_load_defclass)",4},
{CLOS_ "DOCSTRING",NULL,-1},
{CLOS_ "SAFE-INSTANCE-REF","clos_safe_instance_ref",2},

{SYS_ "CL-FIXNUM-BITS",NULL,-1},
{EXT_ "CL-FIXNUM",NULL,-1},
{EXT_ "CL-INDEX",NULL,-1},

{SYS_ "DO-DEFTYPE","ECL_NAME(si_do_deftype)",-4},
{SYS_ "CREATE-TYPE-NAME",NULL,-1},
{SYS_ "*ALIEN-DECLARATIONS*",NULL,-1},

#ifdef ENABLE_DLOPEN
{SYS_ "LOAD-BINARY","si_load_binary",4},
#else
{SYS_ "LOAD-BINARY",NULL,-1},
#endif

{SYS_ "*CODE-WALKER*",NULL,-1},

/* #if defined(HAVE_LIBFFI) */
{SYS_ "CALL-CFUN",IF_DFFI("si_call_cfun"),-5},
{KEY_ "CALLBACK",NULL,-1},
{SYS_ "MAKE-DYNAMIC-CALLBACK",IF_DFFI("si_make_dynamic_callback"),-5},
{SYS_ "FREE-FFI-CLOSURE",IF_DFFI("si_free_ffi_closure"),1},
/* #endif defined(HAVE_LIBFFI) */

{EXT_ "TRAP-FPE","si_trap_fpe",2},

{EXT_ "*ACTION-ON-UNDEFINED-VARIABLE*",NULL,-1},

{EXT_ "SET-BUFFERING-MODE","si_set_buffering_mode",2},
{KEY_ "NONE",NULL,-1},
{KEY_ "LINE-BUFFERED",NULL,-1},
{KEY_ "FULLY-BUFFERED",NULL,-1},
{KEY_ "LINE",NULL,-1},
{KEY_ "FULL",NULL,-1},

{SYS_ "CMP-ENV-REGISTER-MACROLET",NULL,-1},

{EXT_ "GET-FINALIZER","si_get_finalizer",1},
{EXT_ "SET-FINALIZER","si_set_finalizer",2},

{SYS_ "WRONG-TYPE-ARGUMENT","si_wrong_type_argument",-3},

{SYS_ "*CURRENT-FORM*",NULL,-1},

{SYS_ "CODE-BLOCK",NULL,-1},

{SYS_ "FRAME",NULL,-1},
{SYS_ "APPLY-FROM-STACK-FRAME","si_apply_from_stack_frame",2},

#ifdef ECL_CLOS_STREAMS
{GRAY_ "CLOSE",NULL,-1},
{GRAY_ "STREAMP",NULL,-1},
{GRAY_ "INPUT-STREAM-P",NULL,1},
{GRAY_ "OUTPUT-STREAM-P",NULL,1},
{GRAY_ "OPEN-STREAM-P",NULL,1},
{GRAY_ "STREAM-ADVANCE-TO-COLUMN",NULL,-1},
{GRAY_ "STREAM-CLEAR-INPUT",NULL,-1},
{GRAY_ "STREAM-CLEAR-OUTPUT",NULL,-1},
{GRAY_ "STREAM-ELEMENT-TYPE",NULL,1},
{GRAY_ "STREAM-FILE-DESCRIPTOR",NULL,-1},
{GRAY_ "STREAM-FILE-POSITION",NULL,-1},
{GRAY_ "STREAM-FINISH-OUTPUT",NULL,-1},
{GRAY_ "STREAM-FORCE-OUTPUT",NULL,-1},
{GRAY_ "STREAM-FRESH-LINE",NULL,-1},
{GRAY_ "STREAM-INTERACTIVE-P",NULL,-1},
{GRAY_ "STREAM-LINE-COLUMN",NULL,-1},
{GRAY_ "STREAM-LISTEN",NULL,-1},
{GRAY_ "STREAM-PEEK-CHAR",NULL,-1},
{GRAY_ "STREAM-READ-BYTE",NULL,-1},
{GRAY_ "STREAM-READ-CHAR",NULL,-1},
{GRAY_ "STREAM-READ-CHAR-NO-HANG",NULL,-1},
{GRAY_ "STREAM-READ-LINE",NULL,-1},
{GRAY_ "STREAM-READ-SEQUENCE",NULL,-1},
{GRAY_ "STREAM-START-LINE-P",NULL,-1},
{GRAY_ "STREAM-TERPRI",NULL,-1},
{GRAY_ "STREAM-UNREAD-CHAR",NULL,-1},
{GRAY_ "STREAM-WRITE-BYTE",NULL,-1},
{GRAY_ "STREAM-WRITE-CHAR",NULL,-1},
{GRAY_ "STREAM-WRITE-SEQUENCE",NULL,-1},
{GRAY_ "STREAM-WRITE-STRING",NULL,-1},
{GRAY_ "FUNDAMENTAL-STREAM",NULL,-1},
{GRAY_ "FUNDAMENTAL-INPUT-STREAM",NULL,-1},
{GRAY_ "FUNDAMENTAL-OUTPUT-STREAM",NULL,-1},
{GRAY_ "FUNDAMENTAL-CHARACTER-STREAM",NULL,-1},
{GRAY_ "FUNDAMENTAL-BINARY-STREAM",NULL,-1},
{GRAY_ "FUNDAMENTAL-CHARACTER-INPUT-STREAM",NULL,-1},
{GRAY_ "FUNDAMENTAL-CHARACTER-OUTPUT-STREAM",NULL,-1},
{GRAY_ "FUNDAMENTAL-BINARY-INPUT-STREAM",NULL,-1},
{GRAY_ "FUNDAMENTAL-BINARY-OUTPUT-STREAM",NULL,-1},
#endif /* ECL_CLOS_STREAMS */

{SYS_ "LOG1P","si_log1p",1},

{EXT_ "BC-FILE","si_compiled_function_file",1},
{EXT_ "COMPILED-FUNCTION-FILE","si_compiled_function_file",1},

{SYS_ "PROPERTY-LIST",NULL,1},

{SYS_ "BYTECODES",NULL,1},

{SYS_ "HASH-EQL","si_hash_eql",-1},
{SYS_ "HASH-EQUAL","si_hash_equal",-1},
{SYS_ "HASH-EQUALP","si_hash_equalp",-1},

{EXT_ "INTERACTIVE-INTERRUPT",NULL,-1},

{EXT_ "STORAGE-EXHAUSTED",NULL,-1},
{EXT_ "STACK-OVERFLOW",NULL,-1},
{EXT_ "STACK-OVERFLOW-SIZE",NULL,-1},
{EXT_ "STACK-OVERFLOW-TYPE",NULL,-1},
{EXT_ "BINDING-STACK",NULL,-1},
{EXT_ "FRAME-STACK",NULL,-1},
{EXT_ "LISP-STACK",NULL,-1},
{EXT_ "C-STACK",NULL,-1},
{EXT_ "HEAP-SIZE",NULL,-1},
{EXT_ "ILLEGAL-INSTRUCTION",NULL,-1},
{EXT_ "SET-LIMIT","si_set_limit",2},
{EXT_ "GET-LIMIT","si_get_limit",1},
{SYS_ "RESET-MARGIN","si_reset_margin",1},
{EXT_ "SEGMENTATION-VIOLATION",NULL,-1},

{EXT_ "EXTENDED-STRING",NULL,-1},

{SYS_ "CHECK-PENDING-INTERRUPTS","si_check_pending_interrupts",0},

{KEY_ "LATIN-1",NULL,-1},
{KEY_ "ISO-8859-1",NULL,-1},
{KEY_ "UTF-8",NULL,-1},
{KEY_ "UCS-2",NULL,-1},
{KEY_ "UCS-4",NULL,-1},

{EXT_ "CONSTANTLY-T",NULL,-1},
{EXT_ "CONSTANTLY-NIL",NULL,-1},

{EXT_ "MAYBE-QUOTE",NULL,-1},
{EXT_ "MAYBE-UNQUOTE",NULL,-1},

{KEY_ "CR",NULL,-1},
{KEY_ "LF",NULL,-1},
{KEY_ "CRLF",NULL,-1},
{KEY_ "UCS-2BE",NULL,-1},
{KEY_ "UCS-4BE",NULL,-1},
{KEY_ "UCS-2LE",NULL,-1},
{KEY_ "UCS-4LE",NULL,-1},

{EXT_ "LOAD-ENCODING","ECL_NAME(si_load_encoding)",1},
{EXT_ "MAKE-ENCODING","ECL_NAME(si_make_encoding)",1},
{EXT_ "ALL-ENCODINGS",NULL,-1},

{KEY_ "US-ASCII",NULL,-1},
{KEY_ "LITTLE-ENDIAN",NULL,-1},
{KEY_ "BIG-ENDIAN",NULL,-1},

{SYS_ "+UNICODE-DATABASE+",NULL,-1},

{EXT_ "COPY-FILE","si_copy_file",2},

{EXT_ "FILL-ARRAY-WITH-ELT","si_fill_array_with_elt",4},

{EXT_ "+ECL-VERSION-NUMBER+",NULL,-1},

{EXT_ "*BYTECODES-COMPILER*",NULL,-1},

#ifdef ECL_IEEE_FP
{SYS_ "NAN","si_nan",0},

{EXT_ "SHORT-FLOAT-POSITIVE-INFINITY",NULL,-1},
{EXT_ "SINGLE-FLOAT-POSITIVE-INFINITY",NULL,-1},
{EXT_ "DOUBLE-FLOAT-POSITIVE-INFINITY",NULL,-1},
{EXT_ "LONG-FLOAT-POSITIVE-INFINITY",NULL,-1},

{EXT_ "SHORT-FLOAT-NEGATIVE-INFINITY",NULL,-1},
{EXT_ "SINGLE-FLOAT-NEGATIVE-INFINITY",NULL,-1},
{EXT_ "DOUBLE-FLOAT-NEGATIVE-INFINITY",NULL,-1},
{EXT_ "LONG-FLOAT-NEGATIVE-INFINITY",NULL,-1},
#endif /* ECL_IEEE_FP */

{EXT_ "FLOAT-NAN-P","si_float_nan_p",1},
{EXT_ "FLOAT-INFINITY-P","si_float_infinity_p",1},
{EXT_ "FLOAT-NAN-STRING",NULL,1},
{EXT_ "FLOAT-INFINITY-STRING",NULL,1},

{SYS_ "READ-OBJECT-OR-IGNORE","si_read_object_or_ignore",2},

{EXT_ "READTABLE-LOCK","si_readtable_lock",-2},

{SYS_ "+IO-SYNTAX-PROGV-LIST+",NULL,-1},
{SYS_ "+ECL-SYNTAX-PROGV-LIST+",NULL,-1},
{SYS_ "WITH-ECL-IO-SYNTAX",NULL,-1},

{SYS_ "STREAM-EXTERNAL-FORMAT-SET","si_stream_external_format_set",2},

{KEY_ "CDECL",NULL,-1},
{KEY_ "EABI",NULL,-1},
{KEY_ "GNUW64",NULL,-1},
{KEY_ "STDCALL",NULL,-1},
{KEY_ "SYSV",NULL,-1},
{KEY_ "UNIX",NULL,-1},
{KEY_ "UNIX64",NULL,-1},
{KEY_ "VFP",NULL,-1},
{KEY_ "WIN64",NULL,-1},

{EXT_ "WEAK-POINTER",NULL,-1},
{EXT_ "MAKE-WEAK-POINTER","si_make_weak_pointer",1},
{EXT_ "WEAK-POINTER-VALUE","si_weak_pointer_value",1},

{SYS_ "*ALLOW-WITH-INTERRUPTS*",NULL,-1},

/* conveniance macros from CMU util */
{EXT_ "ONCE-ONLY",NULL,-1},
{EXT_ "COLLECT",NULL,-1},
{EXT_ "WITH-UNIQUE-NAMES",NULL,-1},
{EXT_ "WITH-GENSYMS",NULL,-1},
{EXT_ "WITH-CLEAN-SYMBOLS",NULL,-1},
{EXT_ "IF-LET",NULL,-1},
{EXT_ "WHEN-LET",NULL,-1},
{EXT_ "WHEN-LET*",NULL,-1},

{SYS_ "HANDLE-SIGNAL","si_handle_signal",2},

{EXT_ "WITH-INTERRUPTS",NULL,-1},
{EXT_ "WITHOUT-INTERRUPTS",NULL,-1},
{EXT_ "WITH-RESTORED-INTERRUPTS",NULL,-1},
{EXT_ "WITH-LOCAL-INTERRUPTS",NULL,-1},
{EXT_ "ALLOW-WITH-INTERRUPTS",NULL,-1},

{SYS_ "*QUIT-TAG*",NULL,-1},

{EXT_ "ARRAY-RAW-DATA","si_array_raw_data",1},

{EXT_ "*PROGRAM-EXIT-CODE*",NULL,-1},
{EXT_ "EXIT","si_exit",-1},

{EXT_ "ENVIRON","si_environ",0},

{KEY_ "ENVIRON",NULL,-1},

/* external-process extension */
{EXT_ "RUN-PROGRAM","ECL_NAME(si_run_program)",-3},

{EXT_ "MAKE-EXTERNAL-PROCESS",NULL,-1},
{EXT_ "EXTERNAL-PROCESS",NULL,-1},
{EXT_ "EXTERNAL-PROCESS-PID",NULL,-1},
{EXT_ "EXTERNAL-PROCESS-INPUT",NULL,-1},
{EXT_ "EXTERNAL-PROCESS-OUTPUT",NULL,-1},
{EXT_ "EXTERNAL-PROCESS-ERROR-STREAM",NULL,-1},
{EXT_ "EXTERNAL-PROCESS-STATUS",NULL,-1},
{EXT_ "EXTERNAL-PROCESS-WAIT",NULL,-2},
{EXT_ "TERMINATE-PROCESS","ECL_NAME(si_terminate_process)",-2},

{KEY_ "RUNNING",NULL,-1},
{KEY_ "EXITED",NULL,-1},
{KEY_ "SIGNALED",NULL,-1},
{KEY_ "STOPPED",NULL,-1},
{KEY_ "RESUMED",NULL,-1},
/* ~ external-process extension */

/* unixsys.d */
{SYS_ "WAITPID","si_waitpid",2},
#if !defined(ECL_MS_WINDOWS_HOST)
{SYS_ "KILLPID","si_killpid",2},
#else
{SYS_ "KILLPID",NULL,2},
#endif
{SYS_ "RUN-PROGRAM-INNER","si_run_program_inner",4},
{SYS_ "SPAWN-SUBPROCESS","si_spawn_subprocess",6},
#if defined(ECL_MS_WINDOWS_HOST)
{SYS_ "CLOSE-WINDOWS-HANDLE","si_close_windows_handle",1},
#else
{SYS_ "CLOSE-WINDOWS-HANDLE",NULL,-1},
#endif
/* ~ */

{EXT_ "*INVOKE-DEBUGGER-HOOK*",NULL,-1},

{EXT_ "*DOCUMENTATION-POOL*",NULL,-1},
{EXT_ "ANNOTATE",NULL,-1},
{EXT_ "GET-ANNOTATION",NULL,-1},
{EXT_ "REMOVE-ANNOTATION",NULL,-1},
{EXT_ "FUNCTION-LAMBDA-LIST",NULL,-1},
{EXT_ "DEFAULT-ANNOTATION-LOGIC",NULL,-1},
{EXT_ "OPTIONAL-ANNOTATION",NULL,-1},
{EXT_ "LOCATION",NULL,-1},

{EXT_ "LISP-IMPLEMENTATION-VCS-ID","ECL_NAME(si_lisp_implementation_vcs_id)",0},

{SYS_ "SIGNAL-SERVICING",NULL,-1},

{EXT_ "*DEFAULT-EXTERNAL-FORMAT*",NULL,-1},
{KEY_ "PASS-THROUGH",NULL,-1},

{EXT_ "WITH-BACKEND",NULL,-1},
{KEY_ "BYTECODES",NULL,1},
{KEY_ "C/C++",NULL,1},

{EXT_ "ARRAY-INDEX",NULL,-1},
{EXT_ "ANSI-STREAM",NULL,-1},
{EXT_ "VIRTUAL-STREAM",NULL,-1},

{EXT_ "COMPLEX-ARRAY",NULL,-1},

{SYS_ "SEQUENCE-START-END","si_sequence_start_end",4},
{SYS_ "SEQUENCE-COUNT","ECL_NAME(si_sequence_count)",1},
{SYS_ "SHRINK-VECTOR",NULL,-1},
{SYS_ "COPY-SUBARRAY","si_copy_subarray",5},

{SYS_ "CONS-CAR","cl_car",1},
{SYS_ "CONS-CDR","cl_cdr",1},

{EXT_ "COMPILER-TYPECASE",NULL,-1},

{SYS_ "ASSERT-FAILURE","ECL_NAME(si_assert_failure)",-2},
{SYS_ "CCASE-ERROR","ECL_NAME(si_ccase_error)",3},
{SYS_ "ECASE-ERROR","ECL_NAME(si_ecase_error)",2},
{SYS_ "ETYPECASE-ERROR","ECL_NAME(si_etypecase_error)",2},
{SYS_ "CTYPECASE-ERROR","ECL_NAME(si_ctypecase_error)",3},
{SYS_ "DO-CHECK-TYPE","ECL_NAME(si_do_check_type)",4},

/* #ifdef ECL_EXTERNALIZABLE */
{SYS_ "SERIALIZE",IF_EXTERNALIZABLE("si_serialize"),1},
{SYS_ "DESERIALIZE",IF_EXTERNALIZABLE("si_deserialize"),1},
/* #endif */

{EXT_ "ARRAY-ELEMENT-TYPE-BYTE-SIZE","si_array_element_type_byte_size",1},

/* #ifdef ECL_COMPLEX_FLOAT */
{SYS_ "COMPLEX-FLOAT-P","IF_COMPLEX_FLOAT(si_complex_float_p)",1},
{SYS_ "COMPLEX-FLOAT","IF_COMPLEX_FLOAT(si_complex_float)",2},
{SYS_ "COMPLEX-SINGLE-FLOAT",NULL,-1},
{SYS_ "COMPLEX-DOUBLE-FLOAT",NULL,-1},
{SYS_ "COMPLEX-LONG-FLOAT",NULL,-1},
/* #endif */

/* #ifdef ECL_SSE2 */
{EXT_ "SSE-PACK",NULL,-1},
{EXT_ "SSE-PACK-P",IF_SSE2("si_sse_pack_p"),1},
{EXT_ "SSE-PACK-AS-ELT-TYPE",IF_SSE2("si_sse_pack_as_elt_type"),2},
{EXT_ "VECTOR-TO-SSE-PACK",IF_SSE2("si_vector_to_sse_pack"),1},
{EXT_ "SSE-PACK-TO-VECTOR",IF_SSE2("si_sse_pack_to_vector"),2},
{EXT_ "INT-SSE-PACK",NULL,-1},
{EXT_ "FLOAT-SSE-PACK",NULL,-1},
{EXT_ "DOUBLE-SSE-PACK",NULL,-1},
{EXT_ "SSE-PACK-ELEMENT-TYPE",IF_SSE2("si_sse_pack_element_type"),1},
{EXT_ "*SSE-PACK-PRINT-MODE*",NULL,-1},
/* #endif ECL_SSE2 */

{EXT_ "UNIX-SIGNAL-RECEIVED",NULL,-1},
{EXT_ "UNIX-SIGNAL-RECEIVED-CODE",NULL,-1},
{KEY_ "CODE",NULL,-1},

{EXT_ "ASSUME-RIGHT-TYPE",NULL,-1},

{SYS_ "FLOAT-TO-DIGITS","si_float_to_digits",4},
{SYS_ "FLOAT-TO-STRING-FREE","si_float_to_string_free",4},
{SYS_ "INTEGER-TO-STRING","si_integer_to_string",5},

{SYS_ "PRINT-UNREADABLE-OBJECT-FUNCTION","si_print_unreadable_object_function",5},

{EXT_ "DUMP-C-BACKTRACE","si_dump_c_backtrace",1},

{EXT_ "+PROCESS-STANDARD-INPUT+",NULL,-1},
{EXT_ "+PROCESS-STANDARD-OUTPUT+",NULL,-1},
{EXT_ "+PROCESS-ERROR-OUTPUT+",NULL,-1},

{EXT_ "*HELP-MESSAGE*",NULL,-1},
{EXT_ "*LISP-INIT-FILE-LIST*",NULL,-1},
{EXT_ "+DEFAULT-COMMAND-ARG-RULES+",NULL,-1},
{EXT_ "COMMAND-ARGS",NULL,-1},
{EXT_ "*COMMAND-ARGS*",NULL,-1},
{EXT_ "PROCESS-COMMAND-ARGS",NULL,-1},
{EXT_ "*UNPROCESSED-ECL-COMMAND-ARGS*",NULL,-1},

/* #ifdef ECL_UNICODE */
{KEY_ "OCTETS",NULL,-1},
{EXT_ "CHARACTER-CODING-ERROR",NULL,-1},
{EXT_ "CHARACTER-CODING-ERROR-EXTERNAL-FORMAT",NULL,-1},
{EXT_ "CHARACTER-ENCODING-ERROR",NULL,-1},
{EXT_ "CHARACTER-ENCODING-ERROR-CODE",NULL,-1},
{EXT_ "CHARACTER-DECODING-ERROR",NULL,-1},
{EXT_ "CHARACTER-DECODING-ERROR-OCTETS",NULL,-1},
{EXT_ "STREAM-DECODING-ERROR",NULL,-1},
{EXT_ "STREAM-ENCODING-ERROR",NULL,-1},
{EXT_ "DECODING-ERROR",NULL,3},
{EXT_ "ENCODING-ERROR",NULL,3},
/* #endif ECL_UNICODE */

{SYS_ "PROPER-LIST-P","si_proper_list_p",1},
{SYS_ "TRACED-OLD-DEFINITION","ECL_NAME(si_traced_old_definition)",1},
{SYS_ "*TRACE-LIST*",NULL,-1},

{SYS_ "FUNCTION-BOUNDARY",NULL,-1},
{SYS_ "UNWIND-PROTECT-BOUNDARY",NULL,-1},

{EXT_ "*INSPECTOR-HOOK*",NULL,-1},

{KEY_ "RESOLVE-SYMLINKS",NULL,-1},

{SYS_ "LOAD-BYTECODES","si_load_bytecodes",4},

{KEY_ "SHARED",NULL,-1},
{KEY_ "PRIVATE",NULL,-1},

{EXT_ "MMAP","si_mmap",-2},
{EXT_ "MUNMAP","si_munmap",1},
{EXT_ "MMAP-ARRAY","si_mmap_array",1},

{SYS_ "GET-CDATA","si_get_cdata",1},
{SYS_ "ADD-CDATA","si_add_cdata",2},

/*
 * CDR-5 http://cdr.eurolisp.org/document/5/extra-num-types.html
 */

{EXT_ "NEGATIVE-FIXNUM",NULL,-1},
{EXT_ "NON-NEGATIVE-FIXNUM",NULL,-1},
{EXT_ "NON-POSITIVE-FIXNUM",NULL,-1},
{EXT_ "POSITIVE-FIXNUM",NULL,-1},
{EXT_ "NEGATIVE-FIXNUM-P","ECL_NAME(si_negative_fixnum_p)",1},
{EXT_ "POSITIVE-FIXNUM-P","ECL_NAME(si_positive_fixnum_p)",1},
{EXT_ "NON-NEGATIVE-FIXNUM-P","ECL_NAME(si_non_negative_fixnum_p)",1},
{EXT_ "NON-POSITIVE-FIXNUM-P","ECL_NAME(si_non_positive_fixnum_p)",1},

{EXT_ "NEGATIVE-INTEGER",NULL,-1},
{EXT_ "NON-NEGATIVE-INTEGER",NULL,-1},
{EXT_ "NON-POSITIVE-INTEGER",NULL,-1},
{EXT_ "POSITIVE-INTEGER",NULL,-1},
{EXT_ "NEGATIVE-INTEGER-P","ECL_NAME(si_negative_integer_p)",1},
{EXT_ "POSITIVE-INTEGER-P","ECL_NAME(si_positive_integer_p)",1},
{EXT_ "NON-NEGATIVE-INTEGER-P","ECL_NAME(si_non_negative_integer_p)",1},
{EXT_ "NON-POSITIVE-INTEGER-P","ECL_NAME(si_non_positive_integer_p)",1},

{EXT_ "NEGATIVE-RATIONAL",NULL,-1},
{EXT_ "NON-NEGATIVE-RATIONAL",NULL,-1},
{EXT_ "NON-POSITIVE-RATIONAL",NULL,-1},
{EXT_ "POSITIVE-RATIONAL",NULL,-1},
{EXT_ "NEGATIVE-RATIONAL-P","ECL_NAME(si_negative_rational_p)",1},
{EXT_ "POSITIVE-RATIONAL-P","ECL_NAME(si_positive_rational_p)",1},
{EXT_ "NON-NEGATIVE-RATIONAL-P","ECL_NAME(si_non_negative_rational_p)",1},
{EXT_ "NON-POSITIVE-RATIONAL-P","ECL_NAME(si_non_positive_rational_p)",1},

{EXT_ "NEGATIVE-RATIO",NULL,-1},
{EXT_ "NON-NEGATIVE-RATIO",NULL,-1},
{EXT_ "NON-POSITIVE-RATIO",NULL,-1},
{EXT_ "POSITIVE-RATIO",NULL,-1},
{EXT_ "NEGATIVE-RATIO-P","ECL_NAME(si_negative_ratio_p)",1},
{EXT_ "POSITIVE-RATIO-P","ECL_NAME(si_positive_ratio_p)",1},
{EXT_ "NON-NEGATIVE-RATIO-P","ECL_NAME(si_non_negative_ratio_p)",1},
{EXT_ "NON-POSITIVE-RATIO-P","ECL_NAME(si_non_positive_ratio_p)",1},

{EXT_ "NEGATIVE-REAL",NULL,-1},
{EXT_ "NON-NEGATIVE-REAL",NULL,-1},
{EXT_ "NON-POSITIVE-REAL",NULL,-1},
{EXT_ "POSITIVE-REAL",NULL,-1},
{EXT_ "NEGATIVE-REAL-P","ECL_NAME(si_negative_real_p)",1},
{EXT_ "POSITIVE-REAL-P","ECL_NAME(si_positive_real_p)",1},
{EXT_ "NON-NEGATIVE-REAL-P","ECL_NAME(si_non_negative_real_p)",1},
{EXT_ "NON-POSITIVE-REAL-P","ECL_NAME(si_non_positive_real_p)",1},

{EXT_ "NEGATIVE-FLOAT",NULL,-1},
{EXT_ "NON-NEGATIVE-FLOAT",NULL,-1},
{EXT_ "NON-POSITIVE-FLOAT",NULL,-1},
{EXT_ "POSITIVE-FLOAT",NULL,-1},
{EXT_ "NEGATIVE-FLOAT-P","ECL_NAME(si_negative_float_p)",1},
{EXT_ "POSITIVE-FLOAT-P","ECL_NAME(si_positive_float_p)",1},
{EXT_ "NON-NEGATIVE-FLOAT-P","ECL_NAME(si_non_negative_float_p)",1},
{EXT_ "NON-POSITIVE-FLOAT-P","ECL_NAME(si_non_positive_float_p)",1},

{EXT_ "NEGATIVE-SHORT-FLOAT",NULL,-1},
{EXT_ "NON-NEGATIVE-SHORT-FLOAT",NULL,-1},
{EXT_ "NON-POSITIVE-SHORT-FLOAT",NULL,-1},
{EXT_ "POSITIVE-SHORT-FLOAT",NULL,-1},
{EXT_ "NEGATIVE-SHORT-FLOAT-P","ECL_NAME(si_negative_short_float_p)",1},
{EXT_ "POSITIVE-SHORT-FLOAT-P","ECL_NAME(si_positive_short_float_p)",1},
{EXT_ "NON-NEGATIVE-SHORT-FLOAT-P","ECL_NAME(si_non_negative_short_float_p)",1},
{EXT_ "NON-POSITIVE-SHORT-FLOAT-P","ECL_NAME(si_non_positive_short_float_p)",1},

{EXT_ "NEGATIVE-SINGLE-FLOAT",NULL,-1},
{EXT_ "NON-NEGATIVE-SINGLE-FLOAT",NULL,-1},
{EXT_ "NON-POSITIVE-SINGLE-FLOAT",NULL,-1},
{EXT_ "POSITIVE-SINGLE-FLOAT",NULL,-1},
{EXT_ "NEGATIVE-SINGLE-FLOAT-P","ECL_NAME(si_negative_single_float_p)",1},
{EXT_ "POSITIVE-SINGLE-FLOAT-P","ECL_NAME(si_positive_single_float_p)",1},
{EXT_ "NON-NEGATIVE-SINGLE-FLOAT-P","ECL_NAME(si_non_negative_single_float_p)",1},
{EXT_ "NON-POSITIVE-SINGLE-FLOAT-P","ECL_NAME(si_non_positive_single_float_p)",1},

{EXT_ "NEGATIVE-DOUBLE-FLOAT",NULL,-1},
{EXT_ "NON-NEGATIVE-DOUBLE-FLOAT",NULL,-1},
{EXT_ "NON-POSITIVE-DOUBLE-FLOAT",NULL,-1},
{EXT_ "POSITIVE-DOUBLE-FLOAT",NULL,-1},
{EXT_ "NEGATIVE-DOUBLE-FLOAT-P","ECL_NAME(si_negative_double_float_p)",1},
{EXT_ "POSITIVE-DOUBLE-FLOAT-P","ECL_NAME(si_positive_double_float_p)",1},
{EXT_ "NON-NEGATIVE-DOUBLE-FLOAT-P","ECL_NAME(si_non_negative_double_float_p)",1},
{EXT_ "NON-POSITIVE-DOUBLE-FLOAT-P","ECL_NAME(si_non_positive_double_float_p)",1},

{EXT_ "NEGATIVE-LONG-FLOAT",NULL,-1},
{EXT_ "NON-NEGATIVE-LONG-FLOAT",NULL,-1},
{EXT_ "NON-POSITIVE-LONG-FLOAT",NULL,-1},
{EXT_ "POSITIVE-LONG-FLOAT",NULL,-1},
{EXT_ "NEGATIVE-LONG-FLOAT-P","ECL_NAME(si_negative_long_float_p)",1},
{EXT_ "POSITIVE-LONG-FLOAT-P","ECL_NAME(si_positive_long_float_p)",1},
{EXT_ "NON-NEGATIVE-LONG-FLOAT-P","ECL_NAME(si_non_negative_long_float_p)",1},
{EXT_ "NON-POSITIVE-LONG-FLOAT-P","ECL_NAME(si_non_positive_long_float_p)",1},

{EXT_ "ARRAY-INDEX-P","ECL_NAME(si_array_index_p)",1},

{EXT_ "SEQUENCE-STREAM",NULL,-1},
{EXT_ "MAKE-SEQUENCE-INPUT-STREAM","si_make_sequence_input_stream",-2},
{EXT_ "MAKE-SEQUENCE-OUTPUT-STREAM","si_make_sequence_output_stream",-2},

{EXT_ "CHMOD","si_chmod",2},

{SYS_ "MISSING-KEYWORD",NULL,-1},

{EXT_ "HASH-TABLE-CONTENT","si_hash_table_content",1},
{EXT_ "HASH-TABLE-FILL","si_hash_table_fill",2},

{EXT_ "RANDOM-STATE-ARRAY","si_random_state_array",1},

{SYS_ "REPORT-FUNCTION",NULL,-1},

{SYS_ "DO-DEFSETF","ECL_NAME(si_do_defsetf)",-3},
{SYS_ "DO-DEFINE-SETF-METHOD","ECL_NAME(si_do_define_setf_method)",2},

{SYS_ "SETF-DEFINITION","ECL_NAME(si_setf_definition)",2},

{EXT_ "ASSUME-NO-ERRORS",NULL,-1},
{EXT_ "ASSUME-TYPES-DONT-CHANGE",NULL,-1},
{EXT_ "CHECK-ARGUMENTS-TYPE",NULL,-1},
{EXT_ "INLINE-ACCESSORS",NULL,-1},
{EXT_ "INLINE-TYPE-CHECKS",NULL,-1},
{EXT_ "EVALUATE-FORMS",NULL,-1},
{EXT_ "TYPE-ASSERTIONS",NULL,-1},
{EXT_ "CHECK-STACK-OVERFLOW",NULL,-1},
{EXT_ "ARRAY-BOUNDS-CHECK",NULL,-1},

{KEY_ "VALUE",NULL,-1},
{KEY_ "KEY-AND-VALUE",NULL,-1},
{KEY_ "KEY-OR-VALUE",NULL,-1},
{KEY_ "WEAKNESS",NULL,-1},
{EXT_ "HASH-TABLE-WEAKNESS","si_hash_table_weakness",1},
{KEY_ "SYNCHRONIZED",NULL,-1},
{EXT_ "HASH-TABLE-SYNCHRONIZED-P","si_hash_table_synchronized_p",1},

{EXT_ "TRULY-THE",NULL,-1},
{EXT_ "CHECKED-VALUE",NULL,-1},

{EXT_ "INSTALL-BYTECODES-COMPILER",NULL,-1},
{EXT_ "INSTALL-C-COMPILER",NULL,-1},

{FFI_ "C-CHAR-BIT",NULL,-1},
{FFI_ "C-CHAR-MAX",NULL,-1},
{FFI_ "C-CHAR-MIN",NULL,-1},
{FFI_ "C-INT-MAX",NULL,-1}, /* See main.d */
{FFI_ "C-INT-MIN",NULL,-1}, /* See main.d */
{FFI_ "C-SHORT-MAX",NULL,-1},
{FFI_ "C-SHORT-MIN",NULL,-1},
{FFI_ "C-LONG-MAX",NULL,-1}, /* See main.d */
{FFI_ "C-LONG-MIN",NULL,-1}, /* See main.d */
{FFI_ "C-LONG-LONG-MAX",NULL,-1}, /* See main.d */
{FFI_ "C-UCHAR-MAX",NULL,-1},
{FFI_ "C-UINT-MAX",NULL,-1}, /* See main.d */
{FFI_ "C-USHORT-MAX",NULL,-1},
{FFI_ "C-ULONG-MAX",NULL,-1}, /* See main.d */
{FFI_ "C-ULONG-LONG-MAX",NULL,-1}, /* See main.d */
#ifdef ecl_long_long_t
{FFI_ "C-LONG-LONG-BIT",NULL,-1},
#else
{FFI_ "C-LONG-LONG-BIT",NULL,-1},
#endif

{FFI_ "*USE-DFFI*",NULL,-1},
{FFI_ "+NULL-CSTRING-POINTER+",NULL,-1},
{FFI_ "ALLOCATE-FOREIGN-OBJECT",NULL,-1},
{FFI_ "ALLOCATE-FOREIGN-STRING",NULL,-1},
{FFI_ "C-INLINE",NULL,-1},
{FFI_ "C-PROGN",NULL,-1},
{FFI_ "CALLBACK",NULL,-1},
{FFI_ "CHAR*",NULL,-1},
{FFI_ "CHAR-ARRAY-TO-POINTER",NULL,-1},
{FFI_ "CLINES",NULL,-1},
{FFI_ "CONVERT-FROM-CSTRING",NULL,-1},
{FFI_ "CONVERT-FROM-FOREIGN-STRING",NULL,-1},
{FFI_ "CONVERT-TO-CSTRING",NULL,-1},
{FFI_ "CONVERT-TO-FOREIGN-STRING",NULL,-1},
{FFI_ "DEF-ARRAY",NULL,-1},
{FFI_ "DEF-ARRAY-POINTER",NULL,-1},
{FFI_ "DEF-CONSTANT",NULL,-1},
{FFI_ "DEF-ENUM",NULL,-1},
{FFI_ "DEF-FOREIGN-TYPE",NULL,-1},
{FFI_ "DEF-FOREIGN-VAR",NULL,-1},
{FFI_ "DEF-FUNCTION",NULL,-1},
{FFI_ "DEF-STRUCT",NULL,-1},
{FFI_ "DEF-TYPE",NULL,-1},
{FFI_ "DEF-UNION",NULL,-1},
{FFI_ "DEFCALLBACK",NULL,-1},
{FFI_ "DEFCBODY",NULL,-1},
{FFI_ "DEFENTRY",NULL,-1},
{FFI_ "DEFINLINE",NULL,-1},
{FFI_ "DEFLA",NULL,-1},
{FFI_ "DEREF-ARRAY",NULL,-1},
{FFI_ "DEREF-POINTER",NULL,-1},
{FFI_ "DOUBLE",NULL,-1},
{FFI_ "ENSURE-CHAR-CHARACTER",NULL,-1},
{FFI_ "ENSURE-CHAR-INTEGER",NULL,-1},
{FFI_ "ENSURE-CHAR-STORABLE",NULL,-1},
{FFI_ "FIND-FOREIGN-LIBRARY",NULL,-1},
{FFI_ "FOREIGN-STRING-LENGTH",NULL,-1},
{FFI_ "FREE-CSTRING",NULL,-1},
{FFI_ "FREE-FOREIGN-OBJECT",NULL,-1},
{FFI_ "GET-SLOT-POINTER",NULL,-1},
{FFI_ "GET-SLOT-VALUE",NULL,-1},
{FFI_ "INT",NULL,-1},
{FFI_ "LOAD-FOREIGN-LIBRARY",NULL,-1},
{FFI_ "MAKE-NULL-POINTER",NULL,-1},
{FFI_ "MAKE-POINTER",NULL,-1},
{FFI_ "NULL-CHAR-P",NULL,-1},
{FFI_ "OBJECT",NULL,-1},
{FFI_ "POINTER-ADDRESS",NULL,-1},
{FFI_ "SIZE-OF-FOREIGN-TYPE",NULL,-1},
{FFI_ "VOID",NULL,-1},
{FFI_ "WITH-CAST-POINTER",NULL,-1},
{FFI_ "WITH-CSTRING",NULL,-1},
{FFI_ "WITH-CSTRINGS",NULL,-1},
{FFI_ "WITH-FOREIGN-OBJECT",NULL,-1},
{FFI_ "WITH-FOREIGN-OBJECTS",NULL,-1},
{FFI_ "WITH-FOREIGN-STRING",NULL,-1},
{FFI_ "WITH-FOREIGN-STRINGS",NULL,-1},

{SYS_ "BIND-SIMPLE-RESTARTS","ECL_NAME(si_bind_simple_restarts)",2},
{SYS_ "BIND-SIMPLE-HANDLERS","ECL_NAME(si_bind_simple_handlers)",2},
{EXT_ "CONSTANT-FORM-VALUE","si_constant_form_value",-2},
{EXT_ "CONSTANTP-INNER","si_constantp_inner",-2},
{SYS_ "MAKE-BACKQ-VECTOR","si_make_backq_vector",3},

{SYS_ "RATIOP","ECL_NAME(si_ratiop)",1},
{SYS_ "SHORT-FLOAT-P","ECL_NAME(si_short_float_p)",1},
{SYS_ "SINGLE-FLOAT-P","ECL_NAME(si_single_float_p)",1},
{SYS_ "DOUBLE-FLOAT-P","ECL_NAME(si_double_float_p)",1},
{SYS_ "LONG-FLOAT-P","ECL_NAME(si_long_float_p)",1},

{SYS_ "COPY-HASH-TABLE","si_copy_hash_table",1},

/* Tag for end of list */
{NULL,NULL,-1}};
