# Development Report for May 15, 2017

### Multi-stage builds fixes coming in 17.06-rc1

Some bugs were discovered in new multi-stage build feature, release in 17.05. 

When using an image name directly in `COPY --from` without defining a build stage, the data associated with that image was not properly cleaned up.

If a second was based on `scratch` image, the metadata from the previous stage didn't get reset, forcing the user to clear it manually with extra commands.

Fixes for these are merged for the next release, everyone is welcomed to test it once `17.06-rc1` is out.

- [Fix resetting image metadata between stages for scratch case](https://github.com/moby/moby/pull/33179)
- [Fix releasing implicit mounts](https://github.com/moby/moby/pull/33090)
- [Fix a case where using FROM scratch as NAME would fail](https://github.com/moby/moby/pull/32997)


### Quality: Dependency interface switch

Work continues on making the builder dependency interface more stable. This week methods for getting access to source image were swapped out to a new version that keeps a reference to image data until build job has complete.

Merged as part of this effort:

- [Expose GetImage interface for builder](https://github.com/moby/moby/pull/33054)

In review:
- [Refactor builder probe cache and container backend](https://github.com/moby/moby/pull/33061)
- [Refactor COPY/ADD dispatchers](https://github.com/moby/moby/pull/33116)


### New feature: Long running session

PR for [adding long-running session between daemon and cli](https://github.com/moby/moby/pull/32677) that enables advanced features like incremental context send, build credentials from the client, ssh forwarding etc.

@simonferquel updated a [grpc-only version of that interface](https://github.com/moby/moby/pull/33047) and mostly seems that consensus was achieved for using only grpc transport. @tonistiigi finished up persistent cache layer and garbage collection for file transfers. The PR now needs to be split up because CLI has moved. Once that is done, the main PR should be ready for review early this week.

### Merged: Specifying any remote ref in git checkout URLs

Building from git sources now allows [specifying any remote ref](https://github.com/moby/moby/pull/32502). For example, to build a pull request from GitHub you can use: `docker build git://github.com/moby/moby#pull/32502/head`.


### Proposals for new Dockerfile features that need design feedback:

[Add IMPORT/EXPORT commands to Dockerfile](https://github.com/moby/moby/issues/32100)

[Add `DOCKEROS/DOCKERARCH` default ARG to Dockerfile](https://github.com/moby/moby/issues/32487)

[Add support for `RUN --mount`](https://github.com/moby/moby/issues/32507)

[DAG image builder](https://github.com/moby/moby/issues/32550)

[Option to export the hash of the build context](https://github.com/moby/moby/issues/32963) (new)

[Allow --cache-from=*](https://github.com/moby/moby/issues/33002#issuecomment-299041162) (new)

If you are interested in implementing any of them, leave a comment on the specific issues.

### Other new builder features currently in code-review:

-

### Backlog:

[Build secrets](https://github.com/moby/moby/pull/30637) will be brought up again in next maintainer's meeting to evaluate how to move on with this, if any other proposals have changed the objective and if we should wait for swarm secrets to be available first.
