# Where those keys were obtained

# Distributions

## Alma Linux

https://repo.almalinux.org/almalinux/

## Alpine Linux

https://git.alpinelinux.org/aports/tree/main/alpine-keys

## Amazon Linux

- AL2: https://cdn.amazonlinux.com/_assets/11CF1F95C87F5B1A.asc
- AL2023: https://cdn.amazonlinux.com/_assets/E951904AD832C631.asc

## Anolis OS

https://mirrors.openanolis.cn/anolis/RPM-GPG-KEY-ANOLIS

## Azure Linux 2.0 (CBL-Mariner 2.0)

https://raw.githubusercontent.com/microsoft/azurelinux/refs/heads/2.0/SPECS/mariner-repos/MICROSOFT-RPM-GPG-KEY

https://raw.githubusercontent.com/microsoft/azurelinux/refs/heads/2.0/SPECS/mariner-repos/MICROSOFT-METADATA-GPG-KEY

## Azure Linux 3

https://raw.githubusercontent.com/microsoft/azurelinux/refs/heads/3.0/SPECS/azurelinux-repos/MICROSOFT-RPM-GPG-KEY (same RPM key of Azure Linux 2)

## Centos keys

https://www.centos.org/keys/

## Circle Linux

https://mirror.cclinux.org/pub/circle/8/RPM-GPG-KEY-circleofficial

## Fedora & Epel keys

https://src.fedoraproject.org/rpms/fedora-repos/tree/rawhide

## FreeBSD

https://cgit.freebsd.org/doc/plain/documentation/static/pgpkeys/cperciva.key
Colin Percival is the FreeBSD release engineer and at present FreeBSD releases are signed by him.

## Kicksecure & Whonix keys

https://www.kicksecure.com/keys/adrelanos.asc

https://www.kicksecure.com/keys/hulahoop.asc

## Kylin

Extracted from https://update.cs2c.com.cn/NS/V10/V10SP3-2403/os/adv/lic/base/x86_64/Packages/kylin-gpg-keys-1.0-2.4.p21.ky10.x86_64.rpm

## Mageia

http://mirrors.kernel.org/mageia/distrib/cauldron/x86_64/media/core/release/media_info/pubkey

## openEuler

  *  OBS generated key
     http://repo.openeuler.org/openEuler-22.03-LTS/OS/aarch64/RPM-GPG-KEY-openEuler
     http://repo.openeuler.org/openEuler-22.03-LTS/OS/x86_64/RPM-GPG-KEY-openEuler
  *  EulerMaker generated key
     https://repo.openeuler.org/openEuler-22.03-LTS-SP1/OS/aarch64/RPM-GPG-KEY-openEuler

## OpenMandriva

https://raw.githubusercontent.com/OpenMandrivaAssociation/openmandriva-repos/master/RPM-GPG-KEY-OpenMandriva

## OpenWRT

https://openwrt.org/docs/guide-user/security/signatures

## Oracle Linux

see bottom of https://yum.oracle.com/faq.html

## Qubes' repositories

https://keys.qubes-os.org/keys/

## Rocky Linux

https://dl.rockylinux.org/pub/rocky/RPM-GPG-KEY-Rocky-8

https://dl.rockylinux.org/pub/rocky/RPM-GPG-KEY-Rocky-8-Testing

https://dl.rockylinux.org/pub/rocky/RPM-GPG-KEY-Rocky-9

https://dl.rockylinux.org/pub/rocky/RPM-GPG-KEY-Rocky-9-Testing

https://dl.rockylinux.org/pub/rocky/RPM-GPG-KEY-Rocky-10

https://dl.rockylinux.org/pub/rocky/RPM-GPG-KEY-Rocky-10-Testing

https://dl.rockylinux.org/pub/rocky/RPM-GPG-KEY-rockyinfra

## RosaLinux

https://abf.io/import/rosa-repos/raw/rosa2019.1/RPM-GPG-KEY-ROSA

## EuroLinux

https://euro-linux.com/product-signing-keys/

## Red Hat

https://access.redhat.com/security/team/key

## Navy Linux

https://cdn.navylinux.org/RPM-GPG-KEY3-navy-official

## openSUSE

https://build.opensuse.org/projects/openSUSE:Factory/signing_keys

https://build.opensuse.org/projects/openSUSE:Backports/signing_keys

https://build.opensuse.org/projects/openSUSE:Backports:SLE-16.0/signing_keys

## postmarketOS

https://gitlab.com/postmarketOS/pmaports/-/tree/master/main/postmarketos-keys

## Scientific Linux

http://ftp1.scientificlinux.org/linux/scientific/7x/x86_64/os/RPM-GPG-KEY-sl

http://ftp1.scientificlinux.org/linux/scientific/7x/x86_64/os/RPM-GPG-KEY-sl7

## SUSE

https://www.suse.com/support/security/keys/

This repository contains the ALP (Adaptable Linux Platform) signing keys used also in openSUSE Leap 16.

# Third parties repos

## Adobe

https://get.adobe.com/cz/flashplayer/

## AnyDesk

https://keys.anydesk.com/repos/RPM-GPG-KEY

## Bacula

https://www.bacula.org/bacula-distribution-verification-public-keys/ (used for the Bacula suite in general)

https://www.bacula.org/downloads/baculum/baculum.pub (used for Baculum specifically)

## Brave

https://brave-browser.readthedocs.io/en/latest/installing-brave.html#linux

## BlueJeans

https://www.bluejeans.com/downloads

## CalcForge

https://www.calcforge.org/RPM-GPG-KEY-calcforge

## Copr

pushd keys/copr && ../../copr-gpg-download.py --isolate-files && popd

## Datto

https://cpkg.datto.com/DATTO-PKGS-GPG-KEY

https://cpkg.datto.com/DATTO-LEGACYDIST-PKGS-GPG-KEY

## Dell

https://linux.dell.com/files/pgp_pubkeys/

## Docker

https://download.docker.com/linux/fedora/gpg

https://download.docker.com/linux/debian/gpg

## Dropbox

https://linux.dropbox.com/fedora/rpm-public-key.asc

## Elastic

https://artifacts.elastic.co/GPG-KEY-elasticsearch

## Element

https://packages.element.io/

## FFmpeg

https://ffmpeg.org/ffmpeg-devel.asc

## Google

https://dl-ssl.google.com/linux/linux_signing_key.pub

## Google Cloud

https://packages.cloud.google.com/yum/doc/yum-key.gpg

https://packages.cloud.google.com/yum/doc/rpm-package-key.gpg

## I2P

https://geti2p.net/_static/idk.key.asc

https://geti2p.net/_static/zzz.key.asc

## IUS

https://repo.ius.io/RPM-GPG-KEY-IUS-6

https://repo.ius.io/RPM-GPG-KEY-IUS-7

## Intel

https://yum.repos.intel.com/intel-gpg-keys/GPG-PUB-KEY-INTEL-SW-PRODUCTS-2019.PUB

https://www.intel.com/content/www/us/en/security-center/pgp-public-key.html

## Jenkins

https://pkg.jenkins.io/redhat-stable/jenkins.io-2023.key

https://pkg.jenkins.io/redhat-stable/jenkins.io.key (used for releases between 2020 and 2023, see https://www.jenkins.io/blog/2023/03/27/repository-signing-keys-changing/)

https://kohsuke.org/about/pgp/ (used by pre-2020 releases, see https://www.jenkins.io/blog/2020/07/27/repository-signing-keys-changing/ for more information)

## JPackage

http://www.jpackage.org/jpackage.asc

## Kubernetes

https://pkgs.k8s.io/core:/stable:/v1.28/rpm/repodata/repomd.xml.key

https://kubernetes.io/blog/2023/08/15/pkgs-k8s-io-introduction/

## LibreWolf

https://rpm.librewolf.net/pubkey.gpg

## MakeMKV

https://www.makemkv.com/makemkv_pub.txt

## MariaDB

https://mariadb.org/download/

## Microsoft

https://packages.microsoft.com/keys/microsoft.asc

https://packages.microsoft.com/keys/microsoft-2025.asc

https://packages.microsoft.com/keys/msopentech.asc

## mkp224o

https://github.com/cathugger/mkp224o/issues/78#issuecomment-1142068306

## Monero

https://raw.githubusercontent.com/monero-project/monero/master/utils/gpg_keys/binaryfate.asc

## Mullvad

https://mullvad.net/en/help/verifying-signatures/

## MySQL

https://repo.mysql.com/RPM-GPG-KEY-mysql

## PostgreSQL RPM Building Project

https://apt.postgresql.org/pub/repos/yum/

## Remi's repositories

https://git.remirepo.net/cgit/rpms/remi-release.git/plain/RPM-GPG-KEY-remi

https://git.remirepo.net/cgit/rpms/remi-release.git/plain/RPM-GPG-KEY-remi2017

https://git.remirepo.net/cgit/rpms/remi-release.git/plain/RPM-GPG-KEY-remi2018

https://git.remirepo.net/cgit/rpms/remi-release.git/plain/RPM-GPG-KEY-remi2019

https://git.remirepo.net/cgit/rpms/remi-release.git/plain/RPM-GPG-KEY-remi2020

https://git.remirepo.net/cgit/rpms/remi-release.git/plain/RPM-GPG-KEY-remi2021

https://git.remirepo.net/cgit/rpms/remi-release.git/plain/RPM-GPG-KEY-remi2022

https://git.remirepo.net/cgit/rpms/remi-release.git/plain/RPM-GPG-KEY-remi2023

## RpmFusion

http://rpmfusion.org/keys

https://pkgs.rpmfusion.org/cgit/free/rpmfusion-free-release.git/tree/

https://pkgs.rpmfusion.org/cgit/nonfree/rpmfusion-nonfree-release.git/tree/

## Skype

https://repo.skype.com/data/SKYPE-GPG-KEY

## SME Server

http://mirror.canada.pialasse.com/releases/10/smeos/x86_64/

## TeamViewer

https://community.teamviewer.com/English/kb/articles/30708-install-teamviewer-on-red-hat-and-centos

https://download.teamviewer.com/download/linux/signature/TeamViewer2017.asc

## UnitedRPMs

https://github.com/UnitedRPMs/unitedrpms/blob/master/URPMS-GPG-PUBLICKEY-Fedora-24

## VeraCrypt

https://www.veracrypt.fr/en/Digital%20Signatures.html#VerifyPGPSignature

## VideoLAN

https://download.videolan.org/pub/keys/7180713BE58D1ADC.asc

## VirtualBox

https://www.virtualbox.org/download/oracle_vbox.asc

## yt-dlp

https://raw.githubusercontent.com/yt-dlp/yt-dlp/master/public.key

## Zimbra

https://files.zimbra.com/downloads/security/public.key

## Zoom

https://zoom.us/linux/download/pubkey

## How to verify the GPG key

Run `gpg2 key_file` and compare the output with fingerprints on pages above.

## TODO

Add more gpg keys from this list https://rpmfusion.org/FedoraThirdPartyRepos
