#ifndef __label_field_slider
#define __label_field_slider

#include "font.h"
#include "label.h"
#include "field.h"
#include "slider.h"
#include "filled_button.h"

#include <string>
#include <sstream>
#include <fstream>
#include <iostream>

extern font fnt;

template <typename T> struct val_handler {
  virtual void operator() (const T& t) = 0;
};

template <typename T> class label_field_slider : public widget, change_listener< slider<T> >, change_listener<field> {

  filled_button fbtn;
  label lbl;
  field fld;
  slider<T> sld;

  val_handler<T>& vhan;

  void advance_right (int& x, widget& w) {
    static const int XSPACING = 10;
    const box<int>& e = w.get_extents ();
    x += (e.width + XSPACING);
  }

  public:

    label_field_slider (int x, int y, const std::string& t, int wf, int ws, int hs, val_handler<T>& vh) : lbl (t), fld (wf), sld (ws, hs), vhan (vh) {

      set_pos (x, y);

      sld.add_listener (this);
      fld.set_listener (this);

      add_child (&lbl);
      lbl.add_child (&fbtn);
      lbl.add_child (&fld);
      lbl.add_child (&sld);
      lbl.set_moveable (1);

    }

    void update () {
      lbl.update ();
      fld.update ();
      int x, y; get_pos (x, y); set_pos (x, y);
    }

    void set_pos (int x, int y) {

      widget::set_pos (x, y);

      fbtn.set_pos (x, y + fnt.lift);
      advance_right (x, fbtn);

      lbl.set_pos (x, y);
      advance_right (x, lbl);

      sld.set_pos (x, y);
      advance_right (x, sld);

      fld.set_pos (x, y);

    }

    void update_pos () {
        int x1, y1; fbtn.get_pos (x1, y1);
        int x2, y2; lbl.get_pos (x2, y2);
        widget::set_pos (x1, y2);
    }

    void save (std::ofstream& file) {
      int x, y; get_pos (x, y);
      file << get_name () << ' ' << x << ' ' << y << std::endl;
    }

    int handle_input () {
      int t = fbtn.handle_input ();
      int l = lbl.handle_input ();
      if (l) update_pos ();
      t |= l;
      t |= fld.handle_input ();
      t |= sld.handle_input ();
      return t;
    }

    void draw () {
      fbtn.draw ();
      lbl.draw ();
      fld.draw ();
      sld.draw ();
    }

    void changed (slider<T>& s) {
      T v = s.get_val ();
      fld.set_text (v);
      vhan (v);
    }

    void changed (field& f) {
      T val = f;
      sld.set_val (val);
      vhan (sld.get_val ());
    }

    void set_color (float r, float g, float b) {
      fbtn.set_color (r, g, b);
      lbl.set_color (r, g, b);
      fld.set_color (r, g, b);
      sld.set_color (r, g, b);
    }

    const color& get_color () const {return fbtn.get_color ();}

    void set_limits (T lo, T hi) {
      sld.set_limits (lo, hi);
    }

    void get_limits (T& lo, T& hi) {
      sld.get_limits (lo, hi);
    }

    void set_val (const T& t) {
      sld.set_val (t);
    }

    void set_button_listener (click_listener* l) {
      fbtn.set_listener (l);
    }

    const std::string& get_text () const {return lbl.get_text();}
};

#endif
