/*
 * Diagnostics - a unified framework for code annotation, logging,
 * program monitoring, and unit-testing.
 *
 * Copyright (C) 2009 Christian Schallhart <christian@schallhart.net>,
 *                    Michael Tautschnig <tautschnig@forsyte.de>
 *               2008 model.in.tum.de group, FORSYTE group
 *               2006-2007 model.in.tum.de group
 *               2002-2005 Christian Schallhart
 *  
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */


/**
 * @file diagnostics/frame/logging_config.cpp
 *
 * $Id: logging_config.cpp,v 1.6 2005/06/23 09:54:19 esdentem Exp $
 *
 * @author Christian Schallhart
 *
 * @brief [LEVEL: beta] Implementation of @ref diagnostics::Logging_Config
 */

#include <diagnostics/frame/logging_config.hpp>

#include <diagnostics/frame/logging_config_exception.hpp>

#include <diagnostics/frame/logging_implementation.hpp>
#include <diagnostics/frame/logging_mutex.hpp>

DIAGNOSTICS_NAMESPACE_BEGIN;

void Logging_Config::register_logger(Logger * const logger)
{
    DIAGNOSTICS_LOGGING_FACILITY_LOCK_GUARD(guard);
    if(DIAGNOSTICS_LOGGING_FACILITY_LOCK_IS_NESTED(guard))
		throw Logging_Config_Exception("Recursive Lock: in Logging_Config::register_logger");
    INTERNAL_NAMESPACE::Logging_Implementation::instance()->register_logger(logger);
}



void Logging_Config::unregister_logger(Logger * const logger)
{
    DIAGNOSTICS_LOGGING_FACILITY_LOCK_GUARD(guard);
    if(DIAGNOSTICS_LOGGING_FACILITY_LOCK_IS_NESTED(guard))
		throw Logging_Config_Exception("Recursive Lock: in Logging_Config::unregister_logger");
    INTERNAL_NAMESPACE::Logging_Implementation::instance()->unregister_logger(logger);
}


void Logging_Config::init()
{
    DIAGNOSTICS_LOGGING_FACILITY_LOCK_GUARD(guard);
    if(DIAGNOSTICS_LOGGING_FACILITY_LOCK_IS_NESTED(guard))
		throw Logging_Config_Exception("Recursive Lock: in Logging_Config::init");
    INTERNAL_NAMESPACE::Logging_Implementation::instance();
}


DIAGNOSTICS_NAMESPACE_END;

// vim:ts=4:sw=4
