/*
* Copyright (C) 2019 ~ 2020 Uniontech Software Technology Co.,Ltd.
*
* Author:     chenhaifeng  <chenhaifeng@uniontech.com>
*
* Maintainer: chenhaifeng  <chenhaifeng@uniontech.com>
*
* This program is free software: you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation, either version 3 of the License, or
* any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License
* along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/
#include "test_cweekdaybackgrounditem.h"

test_CWeekDayBackgroundItem::test_CWeekDayBackgroundItem()
{
}

void test_CWeekDayBackgroundItem::SetUp()
{
    m_weekItem = new CWeekDayBackgroundItem();
}

void test_CWeekDayBackgroundItem::TearDown()
{
    delete m_weekItem;
    m_weekItem = nullptr;
}

//showFocus
TEST_F(test_CWeekDayBackgroundItem, showFocus)
{
    m_weekItem->setShowFocus(true);
    ASSERT_TRUE(m_weekItem->showFocus());
    m_weekItem->setShowFocus(false);
    ASSERT_FALSE(m_weekItem->showFocus());
}

//setItemFocus
TEST_F(test_CWeekDayBackgroundItem, setItemFocus)
{
    m_weekItem->setItemFocus(true);
}

//hasNextSubItem
TEST_F(test_CWeekDayBackgroundItem, hasNextSubItem)
{
    bool hasNextSub;
    hasNextSub = m_weekItem->hasNextSubItem();
    ASSERT_FALSE(hasNextSub);
}

//drawDividingLine
TEST_F(test_CWeekDayBackgroundItem, drawDividingLine)
{
    m_weekItem->setDrawDividingLine(false);
    ASSERT_FALSE(m_weekItem->drawDividingLine());
    m_weekItem->setDrawDividingLine(true);
    ASSERT_TRUE(m_weekItem->drawDividingLine());
}
