#ifndef _UTIL_H
#define _UTIL_H

// Some utilities for reading and writing to temporary files.

#include <string>

// Make a file in /tmp, unlink it, and write <contents> to it.
// Returns the opened file descriptor, or -1 on failure.
int make_tempfile(const std::string &contents);

// Opposite of make_tempfile(). Returns false on failure.
bool read_tempfile_and_close(int fd, std::string *contents);

// Same as read_tempfile_and_close(), without the close.
bool read_tempfile(int fd, std::string *contents);

// Close a file descriptor, taking care of EINTR on the way.
// log_perror() if it fails; apart from that, behaves as close().
int safe_close(int fd);

#endif  // !defined(_UTIL_H
