#!/usr/bin/python

import os
import sys

csound = "../../csound"
flags = "-d -W -m0"

testFiles = [
"0dbfs",
"abs",
"a",
"active",
"active_k",
"active_scale",
"adds",
"adsr",
"adsyn",
"adsynt2",
"adsynt",
###"aftouch",
"alpass",
"alwayson",
"ampdb",
"ampdbfs",
"ampmidi",
"ampmidid",
"areson",
"aresonk",
"array_array_math",
###"array",
"array_scalar_math",
"array_udo",
"assign",
"atone",
"atonek",
"atonex",
##"ATSadd",
##"ATSaddnz",
##"ATSbufread",
##"ATScross",
##"ATSinfo",
##"ATSinterpread",
##"ATSpartialtap",
##"ATSread",
##"ATSreadnz",
##"ATSsinnoi",
"babo",
"babo_expert",
"balance",
"bamboo",
"barmodel",
"bbcutm",
"bbcuts",
"b",
"betarand",
"bexprnd",
"bformenc1",
"bformenc",
"binit",
"biquad-2",
"biquad",
"birnd",
"bitshift",
"bitwise",
"bqrez",
"butterbp",
"butterbr",
"butterhp",
"butterlp",
"buzz",
"cabasa",
"cauchy",
"cauchyi",
"ceil",
"cell",
"cent",
"centroid",
"cggoto",
###"chanctrl",
"changed",
"chebyshevpoly",
"checkbox",
"chnclear",
"chnget",
"chnmix",
"chnset",
"chuap",
"cigoto",
"ckgoto",
"clear",
"clfilt_highpass",
"clfilt_lowpass",
"clip",
"clockoff",
"clockon",
"cngoto",
"comb",
"combinv",
"compileorc",
"compilestr",
###"compress",
"connect",
"convolve",
"copya2ftab",
"copyf2array",
"cos",
"cosh",
"cosinv",
"cossegb",
"cosseg",
###"cossegr",
"cps2pch_19et",
"cps2pch",
"cps2pch_ftable",
###"cpsmidib",
###"cpsmidi",
###"cpsmidinn2",
"cpsmidinn",
"cpsoct",
"cpspch",
###"cpstmid",
"cpstun",
"cpstuni",
"cpsxpch_105et",
"cpsxpch",
"cpsxpch_pierce",
"cpumeter",
"cpuprc",
"cross2",
"crossfm",
"crunch",
"csbeats",
###"ctrl7",
"cuserrnd",
"dam",
"dam_expanded",
"date",
"dates",
"dbamp",
"db",
"dbfsamp",
"dcblock2",
"dcblock",
"dconv",
"define_args",
"define",
"delay1",
"delay",
"delayk",
"delayr",
"delayw",
"deltap3",
"deltap",
"deltapi",
"deltapn",
"deltapx",
"deltapxw",
"denorm",
"diff",
"diskgrain",
"diskin2",
"diskin",
"dispfft",
"display",
"distort1",
"distort",
"divides",
"divz",
"doppler",
"downsamp",
"dripwater",
##"dssi4cs",
##"dssiactivate",
##"dssiaudio",
##"dssictls",
##"dssiinit",
##"dssilist",
##"dssiplay_mono",
##"dssiplay_stereo",
###"dumpk-2",
###"dumpk2",
###"dumpk3",
###"dumpk4",
###"dumpk",
"duserrnd",
"dust2",
"dust",
"e",
"else",
"elseif",
"endif",
"endin",
"endop",
"envlpx",
###"envlpxr",
"eqfil",
"equal",
"equals",
"event",
"event_i",
"event_named",
###"exitnow",
"exp",
"expcurve",
"expon",
"exprand",
"exprandi",
"expsega",
"expsegba",
"expsegb",
"expseg",
###"expsegr",
###"farey7shuffled",
"fareyleni",
"ficlose",
"filebit",
"filelen",
"filenchnls",
"filepeak",
"filesr",
"filevalid",
"fillarray",
"filter2",
"fin",
"fiopen",
"flanger",
"flashtxt",
##"FLbox",
##"FLbutBank",
##"FLbutton",
##"FLcount",
##"FLexecButton",
##"FLhvsBox",
##"FLjoy",
##"FLkeyIn",
##"FLknob-2",
##"FLknob",
##"FLmouse",
"flooper2",
"flooper",
"floor",
##"FLpanel",
##"FLpanel-sensekey2",
##"FLpanel-sensekey",
##"FLroller",
##"FLsavesnap",
##"FLsavesnap_simple",
##"FLscroll",
##"FLsetcolor",
##"FLsetText",
##"FLsetVal",
##"FLslidBnk2",
##"FLslidBnk2Setk",
##"FLslidBnk",
##"FLslider-2",
##"FLslider",
##"FLtabs",
##"FLtext",
###"fluid-2",
###"fluidAllOut",
###"fluidCCi",
###"fluidCCk",
###"fluidcomplex",
###"fluid",
###"fluidEngine",
###"fluidLoad",
###"fluidNote",
###"fluidOut",
###"fluidProgramSelect",
###"fluidSetInterpMethod",
##"FLvalue",
##"FLvslidBnk",
##"FLxyin-2",
##"FLxyin",
"fmb3",
"fmbell",
"fmmetal",
"fmpercfl",
"fmrhode",
"fmvoice",
"fmwurlie",
"fof2-2",
"fof2",
"fof",
"fofilter",
"fog",
"fold",
"follow2",
"follow",
"foscil",
"foscili",
"fout",
"fout_ftable",
"fouti",
###"foutir",
"fout_poly",
"fprintks-2",
"fprintks",
"fprints",
"frac",
###"fractalnoise",
"freeverb",
"ftchnls",
"ftconv",
"ftfree",
"ftgen-2",
"ftgen",
"ftgenonce",
"ftgentmp",
"ftlen",
"ftlptim",
"ftmorf",
"ftsave",
"ftsr",
"gain",
"gainslider",
"gauss",
"gaussi",
"gbuzz",
"gen01computed",
"gen01",
"gen02",
"gen03",
"gen04",
"gen05",
"gen06",
"gen07",
"gen08",
"gen09",
"gen09square",
"gen10",
"gen11",
"gen12",
"gen13",
"gen14",
"gen15",
"gen16",
###"gen17",
"gen18",
"gen19",
"gen20",
"gen21",
"gen23",
"gen24",
"gen25",
"gen27",
"gen28",
"gen30",
"gen32",
"gen33",
"gen34",
"gen40",
"gen41",
"gen42",
"gen49",
###"gen51",
"gen52",
"genarray",
"genarray_i",
"gendy-2",
"gendyc",
"gendy",
"gendyx-2",
"gendyx",
"genexp",
"genfarey-2",
"genfarey",
"gensone",
"gentanh",
"genwave",
"getcfg",
"gogobel",
"goto",
"grain2",
"grain3",
"grain",
"granule",
"greaterequal",
"greaterthan",
"guiro",
"harmon3",
"harmon",
"hilbert_barberpole",
"hilbert",
"hrtfearly",
"hrtfer",
"hrtfmove2",
"hrtfmove",
"hrtfstat-2",
"hrtfstat",
"hsboscil",
###"hsboscil_midi",
###"hvs1",
###"hvs2-2",
###"hvs2",
"ifthen",
"igoto",
"ihold",
###"imageopcodes",
"imageopcodesdemo2",
###"inch",
"include",
###"in",
###"initc7",
"init",
"inleta",
"inletk",
###"inq",
###"ins",
###"insremot",
###"insremotM",
"instr",
"int",
"integ",
"interp",
"invalue",
"i_statement",
###"jacko",
###"JackoInfo",
###"JackoInit",
###"jacktransport",
"jitter2",
"jitter",
###"joystick-2",
###"joystick",
"jspline",
"kgoto",
"leftbrace",
"lenarray",
"lessequal",
"lessthan",
"lfo",
"limit",
"line",
"linen",
###"linenr",
"lineto",
"linrand",
"linsegb",
"linseg",
###"linsegr",
"locsend_quad",
"locsend_stereo",
"locsig_quad",
"locsig_stereo",
"log10",
"log2",
"logbtwo",
"log",
"logcurve",
###"logicOR",
"loop_le",
"loop_lt",
"loopseg",
"loopsegp",
"looptseg",
"loopxseg",
"lorenz",
###"lorismorph",
###"lorisplay",
###"lorisread",
"loscil3",
"loscil",
"lowpass2",
"lowres",
"lowresx",
"lpf18",
"lpfreson",
"lphasor",
"lposcil3",
"lposcila",
"lposcil",
"lposcilsa2",
"lposcilsa",
"lpread",
"lpreson-2",
"lpreson",
"lpshold",
"lpsholdp",
###"luamoog",
###"luaopcode",
"maca",
"mac",
###"madsr-2",
###"madsr",
"mandel",
"mandol",
"maparray",
"marimba",
###"massign",
"maxabsaccum",
"maxabs",
"maxaccum",
"maxalloc",
"maxarray",
"max",
###"max_k",
"mclock",
"m",
###"mdelay",
"median",
"mediank",
"metro-2",
"metro",
###"midic7",
###"midichannelaftertouch",
"midichn_advanced",
###"midichn",
###"midicontrolchange",
###"midictrl",
###"mididefault",
###"midiin",
###"midinoteoff",
###"midinoteoncps",
###"midinoteonkey",
###"midinoteonoct",
###"midinoteonpch",
###"midion2",
###"midion_scale",
###"midion_simple",
###"midiout",
###"midipitchbend",
###"midipolyaftertouch",
###"midiprogramchange",
###"miditempo",
###"midremot",
"minabsaccum",
"minabs",
"minaccum",
"minarray",
"mincer",
"min",
"mirror",
##"Mixer",
"mode",
"modmatrix",
###"modulus",
"monitor",
"moog",
"moogladder",
"moogvcf2",
"moogvcf",
###"moscil",
"mp3in",
"mp3len",
"mpulse",
"multiplies",
"multitap",
"mute",
###"mxadsr",
###"nchnls",
###"nchnls_i",
"nestedap",
"nlfilt2",
"nlfilt",
"noise-2",
"noise",
###"noteondur2",
###"noteondur",
"notequal",
###"notnum_complex",
###"notnum",
"nreverb",
"nreverb_ftable",
"nrpn",
"nsamp",
"ntrpol",
"octave",
"octcps",
###"octmidib",
###"octmidi",
"octpch",
"opa",
"opand",
"opcode_example",
"oscbnk",
"oscil1",
"oscil1i",
"oscil3",
"oscil",
"oscili",
"oscilikt",
"osciliktp",
"oscilikts",
"osciln",
"oscils",
###"OSCmidircv",
###"OSCmidisend",
"outc",
###"outch-2",
"outch",
"out",
###"outiat",
###"outic",
###"outipb",
###"outipc",
###"outkat",
###"outkc",
###"outkpb",
###"outkpc",
###"outkpc_fltk",
"outleta",
"outletk",
"outq1",
"outq2",
"outq3",
"outq4",
"outq",
"outrg",
"outs1",
"outs2",
"outs",
"outvalue",
###"p5g",
"pan2",
"pan",
"pareq",
"partials",
###"partikkel-2",
###"partikkel",
###"PartikkelExample1",
"partikkel_softsync",
"partikkelsync",
"passign",
"pcauchy",
###"pchbend",
###"pchmidib",
###"pchmidi",
"pchoct",
###"pconvolve",
"pcount",
"p",
"pdclip",
"pdhalf",
"pdhalfy",
"peak",
###"pgmassign_advanced",
###"pgmassign",
###"pgmassign_ignore",
"phaser1",
"phaser2",
"phasorbnk",
"phasor",
"pindex-2",
###"pindex",
"pinkish",
"pitchamdf",
"pitch",
"planet",
"plate",
"plltrack",
"pluck",
"poisson",
###"polyaft",
"polynomial",
"pop",
"port",
###"portk",
"poscil3",
"poscil3-file",
"poscil",
"pow",
"powershape",
"powoftwo",
"prealloc",
"prepiano",
"print",
"printf",
"printk2",
"printk",
"printks",
"prints",
"product",
"pset",
###"pset-midi",
"ptable",
"ptablei",
"ptrack",
"push",
"puts",
"pvadd",
"pvbufread",
"pvcross",
"pvinterp",
"pvoc",
"pvread",
"pvsadsyn",
"pvsanal",
"pvsarp2",
"pvsbandp",
"pvsbandr",
###"pvsbin",
"pvsblur",
"pvsbuffer",
"pvsbufread2",
"pvsbufread",
"pvscale",
"pvscent",
"pvscross",
"pvsdiskin",
"pvsdisp",
"pvsfilter",
"pvsfread",
"pvsfreeze",
"pvsftr",
"pvsftw",
"pvsfwrite",
"pvsgain",
"pvshift",
"pvsifd",
"pvsinfo",
"pvslock",
"pvsmaska",
"pvsmix",
"pvsmooth",
"pvsmorph2",
"pvsmorph",
"pvsosc",
###"pvspitch",
"pvstanal",
"pvsvoc",
"pvswarp",
"pvsynth",
"pwd",
"q",
###"qinf",
###"qnan",
"raises",
"rand",
"randh",
"randi",
"random",
"randomh",
"randomi",
"rbjeq",
"r",
"readclock",
"readf",
"readfi",
"readk-2",
"readk2",
"readk3",
"readk4",
"readscore",
"readscratch",
"reinit",
"repluck",
"reson",
"resonk",
###"resonr",
"resonx",
"resonxk",
"resony",
###"resonz",
"resyn",
"reverb",
###"reverbsc",
###"rewindscore",
"rezzy",
###"rms",
"rnd31",
"rnd31_krate",
"rnd31_seed7",
###"rnd31_time",
"rnd",
"round",
"rspline",
"samphold",
"sandpaper",
"scalearray",
"scans-2",
"scans",
"schedkwhen",
"schedkwhennamed",
"schedule",
"schedwhen",
"scogen",
"scoreline",
"scoreline_i",
"s",
"seed",
"sekere",
"semitone",
###"sensekey",
"seqtime2",
###"seqtime",
"serialBegin",
"serialRead",
"serialWrite",
"setctrl",
"setscorepos",
"shaker",
"signalflowgraph",
"signum",
"sin",
"sinh",
"sininv",
"sinsyn",
"sleighbells",
"slicearray",
"sndloop",
"sndwarp",
"sndwarpst",
"soundin",
"space_quad",
"space_stereo",
"spat3d_quad",
"spat3d_stereo",
"spat3dt",
"spat3d_UHJ",
"spdist",
"sprintf",
"sprintfk",
"spsend",
"spsend_quad",
"spsend_stereo",
"sqrt",
"sr",
"stack",
"statevar",
"stix",
"strcat",
"strcatk",
"strchar",
"strcmp",
"strcpyk",
"streson",
"strget",
"strindexk",
"strlower",
"strrindex",
"strset",
"strsub",
"subinstr",
"subinstr_named",
"subtracts",
"sumarray",
"sum",
"svfilter",
"syncgrain",
"syncloop",
"syncphasor",
"syncphasor-CZresonance",
"system",
"tab",
"tablecopy",
"table",
"tablefilter",
"tablei",
"tableikt",
"tableimix",
"tableiw",
"tablekt",
"tablemix",
"tableng",
"tableseg",
"tablexkt",
"tablexseg",
"tabmorpha",
"tabmorphak",
"tabmorph",
"tabmorphi",
"tabsum",
"tambourine",
"tan",
"tanh",
"taninv2",
"taninv",
"tbvcf",
"t",
"tempest",
"tempo",
"temposcal",
"tempoval",
"tigoto",
"timedseq",
"timeinstk",
"timeinsts",
"timek",
###times_complex",
"times",
"timout",
"tival",
"tlineto",
"tone",
"tonek",
"tonex",
"toot10",
"toot1",
"toot2",
"toot3",
"toot4",
"toot5",
"toot6",
"toot7",
"toot8",
"toot9",
"tradsyn",
"trandom",
"transegb",
"transeg",
###"transegr",
"trcross",
"trfilter",
"trhighest",
"trigger",
"trigseq",
"trirand",
"trlowest",
"trmix",
"trscale",
"trshift",
"trsplit",
"turnoff",
"unirand",
"until",
"upsamp",
"urd",
"vadd",
"vadd_i",
"vaddv",
"vaget",
"valpass-2",
"valpass",
"vaset",
"vbap4",
"vbap4move",
"vbap8",
###"vbap8move",
"vbap",
"vbapg",
"vbapgmove",
"vbaplsinit",
"vbapmove",
"vcella",
"vco2",
"vco2ft",
"vco2ift",
"vco2init",
"vco",
###"vcomb",
"vcopy",
"v",
"vdelay3",
"vdelay",
"vdelayx",
"vdelayxq",
"vdelayxs",
"vdelayxw",
###"vdelayxwq",
"vdelayxws",
"vdivv",
###"veloc",
"vexp",
"vexp_i",
"vexpseg",
"vexpv",
"vibes",
"vibrato",
"vibr",
"vincr-complex",
"vincr",
###"virtual",
"vlinseg",
"vlowres",
"vmap",
"vmult-2",
"vmult",
"vmult_i",
"vmultv",
"voice",
"vosim",
"vpow-2",
"vpow",
"vpow_i-2",
"vpow_i",
"vpowv",
"vpvoc",
"vrandh",
"vrandi",
###"vst4cs",
"vsubv",
###"vtable1k",
"vtablei",
"vtablek",
##"vtablewa",
"vtablewk",
"waveset",
"weibull",
"wgbow",
"wgbowedbar",
"wgbrass",
"wgclar",
"wgflute",
"wgpluck2",
"wgpluck_brighter",
"wgpluck",
"wguide1",
"wguide2",
###"wii",
"wrap",
"wterrain",
"xadsr",
"x",
"xscanmap",
"xscans",
"xscanu",
###"xtratim-2",
###"xtratim",
###"xyin",
"zacl",
"zakinit",
"zamod",
"zar",
"zarg",
"zaw",
"zawm",
"zir",
"ziw",
"ziwm",
"zkcl",
"zkmod",
"zkr",
"zkw",
"zkwm",
]

if len(sys.argv) == 2:
    csound = sys.argv[1]
else:
    print "Testing git version"


print "Using Csound Command: " + csound    

try:
    os.remove("Old_Output")
except OSError:
    pass

try:
    os.remove("CheckSums")
except OSError:
    pass

try:
    os.rename("Output", "Old_Output")
except OSError:
    pass

for filename in testFiles:

    replaceText = (csound, flags, filename, filename)
    csCommand = "%s %s %s.csd -o ./%s.wav >> Output 2>&1"%replaceText
  
    md5sumCommand = "md5sum -b %s.wav >> CheckSums"%filename

    print csCommand
    os.system(csCommand)
    os.system(md5sumCommand)

    try:
        os.remove(filename + ".wav")
    except OSError:
        print "Error: %s.wav was not generated"%filename
    
print "********Comparing checksums"
os.system("diff CheckSums SAFESums")
print "********Comparing output"
os.system("diff Output Old_Output")
