/* Copyright © Triad National Security, LLC, and others.

   This interface contains all functions that deal with JSON: OCI, CDI, and
   friends. */

#define _GNU_SOURCE
#pragma once
#include "config.h"

#include CJSON_H

#include "core.h"


/** Types **/

/* General CDI configuration. */
struct cdi_config {
   char **spec_dirs;  // directories to search for CDI spec files
   bool res_all_p;    // inject all resources found
   char **ids;        // user-requested resources
};


/** Function prototypes **/

struct env_var *cdi_envs_get(const char *id);
void cdi_init(struct cdi_config *cf);
void cdi_hooks_install(struct container *c);
char *cdi_resid_canonicalize(const char *id);
char **cdi_spec_dirs_default();
void json_init(void);
