include(manual.h)dnl
HEADER(starch)

SECTION(NAME)
BOLD(starch) - STandalone application ARCHiver

SECTION(SYNOPSIS)
CODE(starch [options] PARAM(sfx_path))

SECTION(DESCRIPTION)

BOLD(Starch) is a script that creates standalone application archives in the
form of self-extracting executables (CODE(SFX)). Users may specify the command,
executables, libraries, data, and environment scripts associated with the
application by specifying the appropriate command line options or by using a
configuration file.  BOLD(starch) is particularly useful for distributed
computing, in that it makes an executable portable across different
operating system variants.

SECTION(OPTIONS)

To create a CODE(SFX), simply specify the name of the CODE(SFX) to create along
with the PARAM(command) to execute and any other dependencies such as
PARAM(executables), PARAM(libraries), PARAM(data), or PARAM(environment)
scripts.
PARA
If a PARAM(command) is specified, but no PARAM(executable) is passed, then the
first token in the PARAM(command) will be used as the executable.
PARA
By default, CODE(starch) will use CODE(ldd) to detect any necessary libraries
from the specified set of PARAM(executables) and include them in the CODE(SFX).
OPTIONS_BEGIN
OPTION_FLAG_SHORT(A)Do not automatically detect library dependencies.
OPTION_ARG_SHORT(C, cfg)Use configuration file.
OPTION_ARG_SHORT(c, cmd)Specify command to execute.
OPTION_ARG_SHORT(d, npath:opath)Add data (new path:old path).
OPTION_ARG_SHORT(e, env)Add environment script.
OPTION_ARG_SHORT(l, lib)Add library.
OPTION_ARG_SHORT(x, exe)Add executable.
OPTION_FLAG_SHORT(h)Show help message and exit.
OPTION_FLAG_SHORT(v)Display verbose messages (default: False).
OPTIONS_END
Once a CODE(SFX) is generated, you can use it as a normal executable.

SECTION(CONFIGURATION FILE)
The command line options may be stored in a configuration file and passed to
starch using the CODE(starch -C) option.  The format of the configuration file is as
follows:
LONGCODE_BEGIN
[starch]
executables = echo date hostname
libraries   = libz.so
data        = hosts.txt:/etc/hosts localtime:/etc/localtime images:/usr/share/pixmaps
command     = echo $(hostname) $(date $@)
LONGCODE_END

SECTION(ENVIRONMENT VARIABLES)

The following environment variables will affect the execution of the CODE(SFX)
generated by CODE(starch):

SUBSECTION(SFX_DIR)
Determines the target directory where the CODE(SFX) will be extracted.  By
default this is CODE(/tmp/$hostname.$user.$basename.dir).

SUBSECTION(SFX_EXTRACT_ONLY)
Only extract the CODE(SFX).  By default it is extracted and executed.

SUBSECTION(SFX_EXTRACT_FORCE)
Extract the CODE(SFX) even if the CODE(SFX_DIR) exists. This is disabled by
default to as an optimization to avoid unnecessarily extracting.

SUBSECTION(SFX_KEEP)
Keep extracted files.  By default the files will be removed after execution.

SUBSECTION(SFX_UNIQUE)

Use CODE(mktempd) to generate a unique CODE(SFX_DIR) target directory. This
will prevent CODE(SFX_KEEP) from working properly since the names will change
in between invocations.

SECTION(EXIT STATUS)
On success, returns zero.  On failure, returns non-zero.

SECTION(EXAMPLES)

Package the date program:
LONGCODE_BEGIN
    $ starch -c date -x date date.sfx
LONGCODE_END

Package the date program using a configuration file:
LONGCODE_BEGIN
    $ cat data.cfg
    [starch]
    executables = date
    command = date
    $ starch -C date.cfg date.sfx
LONGCODE_END

Run standalone date program with parameters:
LONGCODE_BEGIN
    $ ./date.sfx +%s
LONGCODE_END

Only extract the archive:
LONGCODE_BEGIN
    $ env SFX_EXTRACT_ONLY=1 ./date.sfx
LONGCODE_END

Run and keep extracted directory:
LONGCODE_BEGIN
    $ env SFX_KEEP=1 ./date.sfx
LONGCODE_END

Run with unique directory:
LONGCODE_BEGIN
    $ env SFX_UNIQUE=1 ./date.sfx
LONGCODE_END

Advanced example involving a complex shell command:
LONGCODE_BEGIN
    $ starch -v -x tar -x rm  -c 'tar_test() { for f in $@; do if ! tar xvf $f; then exit 1; fi; done; rm $@'; }; tar_test' extract_and_remove.sfx
    $ ./extract_and_remove.sfx *.tar.gz
LONGCODE_END

SECTION(COPYRIGHT)

COPYRIGHT_BOILERPLATE

SECTION(SEE ALSO)

SEE_ALSO_MAKEFLOW

FOOTER
