{ -*- buffer-read-only: t -*-

  Copyright 2015-2024 Michalis Kamburelis.

  This file is part of "Castle Game Engine".

  "Castle Game Engine" is free software; see the file COPYING.txt,
  included in this distribution, for details about the copyright.

  "Castle Game Engine" is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

  ----------------------------------------------------------------------------
}

{ Automatically generated node properties.

  Do not edit this file manually!
  To add new properties:
  - add them to the text files in tools/internal/x3d-nodes-to-pascal/nodes-specification/ ,
  - and regenerate include files by running x3d-nodes-to-pascal }

{$ifdef read_interface}

  strict private
    function GetHorizontal: Boolean;
    procedure SetHorizontal(const Value: Boolean);
{$ifndef CASTLE_SLIM_NODES}
    function GetLanguage: String;
    procedure SetLanguage(const Value: String);
{$endif not CASTLE_SLIM_NODES}
{$ifndef CASTLE_SLIM_NODES}
    function GetLeftToRight: Boolean;
    procedure SetLeftToRight(const Value: Boolean);
{$endif not CASTLE_SLIM_NODES}
    function GetSize: Single;
    procedure SetSize(const Value: Single);
    function GetSpacing: Single;
    procedure SetSpacing(const Value: Single);
    function GetStyle: TX3DFontStyle;
    procedure SetStyle(const Value: TX3DFontStyle);
{$ifndef CASTLE_SLIM_NODES}
    function GetTopToBottom: Boolean;
    procedure SetTopToBottom(const Value: Boolean);
{$endif not CASTLE_SLIM_NODES}
    function GetBlending: Boolean;
    procedure SetBlending(const Value: Boolean);
  public
    { Create node fields and events. }
    procedure CreateNode; override;
    class function ClassX3DType: String; override;

    strict private FFdFamily: TMFString;
    { Internal wrapper for property @code(Family). This wrapper API may change, we advise to access simpler @code(Family) instead, if it is defined (TODO: for now, some field types do not have a simpler counterpart). }
    public property FdFamily: TMFString read FFdFamily;

    strict private FFdHorizontal: TSFBool;
    { Internal wrapper for property @code(Horizontal). This wrapper API may change, we advise to access simpler @code(Horizontal) instead, if it is defined (TODO: for now, some field types do not have a simpler counterpart). }
    public property FdHorizontal: TSFBool read FFdHorizontal;
    {  }
    property Horizontal: Boolean read GetHorizontal write SetHorizontal;

    strict private FFdJustify: TMFString;
    { Internal wrapper for property @code(Justify). This wrapper API may change, we advise to access simpler @code(Justify) instead, if it is defined (TODO: for now, some field types do not have a simpler counterpart). }
    public property FdJustify: TMFString read FFdJustify;

{$ifndef CASTLE_SLIM_NODES}
    strict private FFdLanguage: TSFString;
    { Internal wrapper for property @code(Language). This wrapper API may change, we advise to access simpler @code(Language) instead, if it is defined (TODO: for now, some field types do not have a simpler counterpart). }
    public property FdLanguage: TSFString read FFdLanguage;
{$endif not CASTLE_SLIM_NODES}
{$ifndef CASTLE_SLIM_NODES}
    {  }
    property Language: String read GetLanguage write SetLanguage;
{$endif not CASTLE_SLIM_NODES}

{$ifndef CASTLE_SLIM_NODES}
    strict private FFdLeftToRight: TSFBool;
    { Internal wrapper for property @code(LeftToRight). This wrapper API may change, we advise to access simpler @code(LeftToRight) instead, if it is defined (TODO: for now, some field types do not have a simpler counterpart). }
    public property FdLeftToRight: TSFBool read FFdLeftToRight;
{$endif not CASTLE_SLIM_NODES}
{$ifndef CASTLE_SLIM_NODES}
    {  }
    property LeftToRight: Boolean read GetLeftToRight write SetLeftToRight;
{$endif not CASTLE_SLIM_NODES}

    strict private FFdSize: TSFFloat;
    { Internal wrapper for property @code(Size). This wrapper API may change, we advise to access simpler @code(Size) instead, if it is defined (TODO: for now, some field types do not have a simpler counterpart). }
    public property FdSize: TSFFloat read FFdSize;
    {  }
    property Size: Single read GetSize write SetSize;

    strict private FFdSpacing: TSFFloat;
    { Internal wrapper for property @code(Spacing). This wrapper API may change, we advise to access simpler @code(Spacing) instead, if it is defined (TODO: for now, some field types do not have a simpler counterpart). }
    public property FdSpacing: TSFFloat read FFdSpacing;
    {  }
    property Spacing: Single read GetSpacing write SetSpacing;

    strict private FFdStyle: TSFStringEnum;
    { Internal wrapper for property @code(Style). This wrapper API may change, we advise to access simpler @code(Style) instead, if it is defined (TODO: for now, some field types do not have a simpler counterpart). }
    public property FdStyle: TSFStringEnum read FFdStyle;
    {  }
    property Style: TX3DFontStyle read GetStyle write SetStyle;

{$ifndef CASTLE_SLIM_NODES}
    strict private FFdTopToBottom: TSFBool;
    { Internal wrapper for property @code(TopToBottom). This wrapper API may change, we advise to access simpler @code(TopToBottom) instead, if it is defined (TODO: for now, some field types do not have a simpler counterpart). }
    public property FdTopToBottom: TSFBool read FFdTopToBottom;
{$endif not CASTLE_SLIM_NODES}
{$ifndef CASTLE_SLIM_NODES}
    {  }
    property TopToBottom: Boolean read GetTopToBottom write SetTopToBottom;
{$endif not CASTLE_SLIM_NODES}

    strict private FFdBlending: TSFBool;
    { Internal wrapper for property @code(Blending). This wrapper API may change, we advise to access simpler @code(Blending) instead, if it is defined (TODO: for now, some field types do not have a simpler counterpart). }
    public property FdBlending: TSFBool read FFdBlending;
    {  }
    property Blending: Boolean read GetBlending write SetBlending;

{$endif read_interface}

{$ifdef read_implementation}

{ TFontStyleNode ----------------------------------------------- }

function TFontStyleNode.GetHorizontal: Boolean;
begin
  Result := FdHorizontal.Value;
end;

procedure TFontStyleNode.SetHorizontal(const Value: Boolean);
begin
  FdHorizontal.Send(Value);
end;

{$ifndef CASTLE_SLIM_NODES}
function TFontStyleNode.GetLanguage: String;
begin
  Result := FdLanguage.Value;
end;

procedure TFontStyleNode.SetLanguage(const Value: String);
begin
  FdLanguage.Send(Value);
end;

{$endif not CASTLE_SLIM_NODES}
{$ifndef CASTLE_SLIM_NODES}
function TFontStyleNode.GetLeftToRight: Boolean;
begin
  Result := FdLeftToRight.Value;
end;

procedure TFontStyleNode.SetLeftToRight(const Value: Boolean);
begin
  FdLeftToRight.Send(Value);
end;

{$endif not CASTLE_SLIM_NODES}
function TFontStyleNode.GetSize: Single;
begin
  Result := FdSize.Value;
end;

procedure TFontStyleNode.SetSize(const Value: Single);
begin
  FdSize.Send(Value);
end;

function TFontStyleNode.GetSpacing: Single;
begin
  Result := FdSpacing.Value;
end;

procedure TFontStyleNode.SetSpacing(const Value: Single);
begin
  FdSpacing.Send(Value);
end;

function TFontStyleNode.GetStyle: TX3DFontStyle;
begin
  Result := TX3DFontStyle(FdStyle.EnumValue);
end;

procedure TFontStyleNode.SetStyle(const Value: TX3DFontStyle);
begin
  FdStyle.SendEnumValue(Ord(Value));
end;

{$ifndef CASTLE_SLIM_NODES}
function TFontStyleNode.GetTopToBottom: Boolean;
begin
  Result := FdTopToBottom.Value;
end;

procedure TFontStyleNode.SetTopToBottom(const Value: Boolean);
begin
  FdTopToBottom.Send(Value);
end;

{$endif not CASTLE_SLIM_NODES}
function TFontStyleNode.GetBlending: Boolean;
begin
  Result := FdBlending.Value;
end;

procedure TFontStyleNode.SetBlending(const Value: Boolean);
begin
  FdBlending.Send(Value);
end;

class function TFontStyleNode.ClassX3DType: String;
begin
  Result := 'FontStyle';
end;

procedure TFontStyleNode.CreateNode;
begin
  inherited;

  FFdFamily := TMFString.Create(Self, False, 'family', ['SERIF']);
   FdFamily.ChangeAlways := chFontStyleFontChanged;
  AddField(FFdFamily);

  FFdHorizontal := TSFBool.Create(Self, False, 'horizontal', true);
   FdHorizontal.ChangeAlways := chFontStyle;
  AddField(FFdHorizontal);

  FFdJustify := TMFString.Create(Self, False, 'justify', ['BEGIN']);
   FdJustify.ChangeAlways := chFontStyle;
  AddField(FFdJustify);

{$ifndef CASTLE_SLIM_NODES}
  FFdLanguage := TSFString.Create(Self, False, 'language', '');
   FdLanguage.ChangeAlways := chFontStyle;
  AddField(FFdLanguage);
{$endif not CASTLE_SLIM_NODES}

{$ifndef CASTLE_SLIM_NODES}
  FFdLeftToRight := TSFBool.Create(Self, False, 'leftToRight', true);
   FdLeftToRight.ChangeAlways := chFontStyle;
  AddField(FFdLeftToRight);
{$endif not CASTLE_SLIM_NODES}

  FFdSize := TSFFloat.Create(Self, False, 'size', 1.0);
   FdSize.ChangeAlways := chFontStyle;
   FdSize.MustBeNonnegative := true;
  AddField(FFdSize);

  FFdSpacing := TSFFloat.Create(Self, False, 'spacing', 1.0);
   FdSpacing.ChangeAlways := chFontStyle;
   FdSpacing.MustBeNonnegative := true;
  AddField(FFdSpacing);

  FFdStyle := TSFStringEnum.Create(Self, False, 'style', @FontStyleNames, Ord(High(FontStyleNames)) + 1, Ord(fsPlain));
   FdStyle.ChangeAlways := chFontStyleFontChanged;
  AddField(FFdStyle);

{$ifndef CASTLE_SLIM_NODES}
  FFdTopToBottom := TSFBool.Create(Self, False, 'topToBottom', true);
   FdTopToBottom.ChangeAlways := chFontStyle;
  AddField(FFdTopToBottom);
{$endif not CASTLE_SLIM_NODES}

  FFdBlending := TSFBool.Create(Self, False, 'blending', true);
   FdBlending.ChangeAlways := chVisibleNonGeometry;
  AddField(FFdBlending);
end;

{$endif read_implementation}
