#include <iostream>
#include <tchar.h>

#pragma link "CastleWindow"

#include "CastleWindow.hpp"
#include "CastleApplicationProperties.hpp"
#include "CastleLog.hpp"

#include "GameInitialize.h"

/* Configure ApplicationProperties, start logging.
   For Pascal projects, these calls are autogenerated in castleautogenerated.pas .
   None of these are critical for the project to really work,
   but we show how to express in C++ 100% of the API available from Pascal. */
void EarlyInitialization()
{
	ApplicationProperties()->ApplicationName = "CastleCppWindow";
	ApplicationProperties()->Caption = "C++ Builder Demo Using TCastleWindow";
	ApplicationProperties()->Version = "0.1";
	if (!IsLibrary) {
		Application()->ParseStandardParameters();
	}
	InitializeLog();
}

/* Note: We define FMXMain, not _tmain,
   because for C++ Builder we recommend to define applications
   using TCastleWindow as "FMX application". Reasons:

   - This is the way to avoid console on Windows.
	 Unlike Delphi/Pascal, where the {$apptype console} / {$apptype gui}
	 determines application type (and it is independent from VCL / VFMX / other),
	 with C++ Builder it seems that using a framework like FMX is the only way
	 to avoid console.

   - On non-Windows (like Linux), TCastleWindow uses FMX under the hood.
*/

//int _tmain(int argc, _TCHAR* argv[])
extern "C" int FMXmain()
{
	EarlyInitialization();

	/* Sets Application()->MainWindow, Application()->OnApplicationInitialize */
	GameInitialize();

	/* Open Application()->MainWindow and run application loop */
	Application()->MainWindow->OpenAndRun();

	return 0;
}

// TODO: How to request from C++ to use dedicated GPU on laptops?
// We do this in Pascal, see https://castle-engine.io/dedicated_gpu

