.\" Copyright 1994 NEC Corporation, Tokyo, Japan.
.\"
.\" Permission to use, copy, modify, distribute and sell this software
.\" and its documentation for any purpose is hereby granted without
.\" fee, provided that the above copyright notice appear in all copies
.\" and that both that copyright notice and this permission notice
.\" appear in supporting documentation, and that the name of NEC
.\" Corporation not be used in advertising or publicity pertaining to
.\" distribution of the software without specific, written prior
.\" permission.  NEC Corporation makes no representations about the
.\" suitability of this software for any purpose.  It is provided "as
.\" is" without express or implied warranty.
.\"
.\" NEC CORPORATION DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
.\" INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN 
.\" NO EVENT SHALL NEC CORPORATION BE LIABLE FOR ANY SPECIAL, INDIRECT OR
.\" CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF 
.\" USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR 
.\" OTHER TORTUOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR 
.\" PERFORMANCE OF THIS SOFTWARE. 
.\"
.\" $Id: RkCvtHan.man,v 1.1.1.1 2002/10/19 08:27:47 aida_s Exp $ NEC;
.TH "RKCVTHAN" "3"
.SH "NAME"
\f4RkCvtHan\f1 / \f4RkwCvtHan\f1 \- convert double-width symbols, alphanumeric characters, hiragana, and katakana to single-width characters
.SH "SYNOPSIS"
.nf
.ft 4
#include <canna/RK.h>
int RkCvtHan(dst, maxdst, src, srclen)
unsigned char *dst;
int maxdst;
unsigned char *src;
int srclen;
int RkwCvtHan(dst, maxdst, src, srclen)
wchar_t *dst;
int maxdst;
wchar_t *src;
int srclen;
.ft 1
.fi
.SH "DESCRIPTION"
\f2RkCvtHan\f1 converts the \f2srclen\f1 bytes of double-width symbol, alphanumeric characters, hiragana, and katakana data to single-width characters, starting at the area \f2src\f1.  A null character in \f2src\f1 is not interpreted as the end of the string.  The conversion result is stored in the area \f2dst\f1.  Characters that are not subject to conversion are copied as they are.  The conversion result is truncated to adjust to character boundaries in the EUC code when its byte length exceeds \f2maxdst\f1 -1.  \f2dst\f1 is padded with null characters at the end if possible.  EUC code is used to represent both \f2src\f1 and \f2dst\f1. 
.P
\f2RkwCvtHan\f1 is the wchar_t version of \f2RkCvtHan\f1.  Arguments which specify the length are regarded as they count the character length instead of byte length.
.P
\f4NULL\f1 can be specified in \f2dst\f1.  \f4NULL\f1 overrides the entire conversion result.
.SH "RETURN VALUE"
This function returns the byte length (or character length for RkwCvtHan) of the conversion result, or returns \f40\f1 if the value of \f2maxdst\f1 is invalid.
