
inline MemoryStream::MemoryStream(std::string const &bufSize,
                                  std::ios::openmode openMode, size_t access)
:
    MemoryStream(bufSize, false, openMode, access)
{}

inline MemoryStream::MemoryStream(int id, std::ios::openmode openMode)
:
    MemoryStream(id, false, openMode)       // 3.cc
{}

inline void MemoryStream::open(char const *bufSize, bool erase, 
                               std::ios::openmode openMode, size_t access)
{
    static_cast<MemoryBuf &>(*this) = 
                            MemoryBuf{ bufSize, erase, openMode, access };
}

inline void MemoryStream::open(char const *bufSize,
                               std::ios::openmode openMode, size_t access)
{
    open(bufSize, false, openMode, access);
}

inline void MemoryStream::open(int id, bool erase,
                               std::ios::openmode openMode)
{
    static_cast<MemoryBuf &>(*this) = MemoryBuf{ id, erase, openMode };
}

inline void MemoryStream::open(int id, std::ios::openmode openMode)
{
    open(id, false, openMode);
}

inline void MemoryStream::setErase(bool erase)
{
    static_cast<MemoryBuf &>(*this).setErase(erase);
}









