/*
 * Decompiled with CFR 0.152.
 */
package com.kreative.rsrc;

import com.kreative.ksfl.KSFLUtilities;
import com.kreative.rsrc.MacResource;
import com.kreative.rsrc.MacResourceAlreadyExistsException;
import com.kreative.rsrc.MacResourceProvider;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;

public class MacResourceArray
extends MacResourceProvider {
    private byte[] arr;
    private int resMap;
    private int typeList;
    private int nameList;
    private int resData;
    private int resMapLen;
    private int resDataLen;
    private String textEncoding = "MACROMAN";
    private static final int INSERTED_TYPE_RECORD = 1;
    private static final int INSERTED_OBJECT_RECORD = 2;
    private static final int INSERTED_NAME = 3;
    private static final int INSERTED_DATA = 4;
    private static final int REMOVED_TYPE_RECORD = 1;
    private static final int REMOVED_OBJECT_RECORD = 2;
    private static final int REMOVED_NAME = 3;
    private static final int REMOVED_DATA = 4;

    private String gps(byte[] a, int b) {
        try {
            return KSFLUtilities.getPString(a, b, this.textEncoding);
        }
        catch (UnsupportedEncodingException uue) {
            return KSFLUtilities.getPString(a, b);
        }
    }

    private byte[] gb(String a) {
        try {
            return a.getBytes(this.textEncoding);
        }
        catch (UnsupportedEncodingException uue) {
            return a.getBytes();
        }
    }

    private int[] locateType(int type) {
        int m = KSFLUtilities.getShort(this.arr, this.typeList) + 1;
        int i = 0;
        while (i < m) {
            int t = KSFLUtilities.getInt(this.arr, this.typeList + 2 + 8 * i);
            if (t == type) {
                int cnt = KSFLUtilities.getShort(this.arr, this.typeList + 2 + 8 * i + 4) + 1;
                int lst = this.typeList + KSFLUtilities.getShort(this.arr, this.typeList + 2 + 8 * i + 6);
                return new int[]{this.typeList + 2 + 8 * i, cnt, lst};
            }
            ++i;
        }
        return null;
    }

    private int[] locate(int type, short id) {
        int[] t = this.locateType(type);
        if (t != null) {
            int i = 0;
            while (i < t[1]) {
                short thisid = KSFLUtilities.getShort(this.arr, t[2] + 12 * i);
                if (thisid == id) {
                    short n = KSFLUtilities.getShort(this.arr, t[2] + 12 * i + 2);
                    int d = KSFLUtilities.getInt(this.arr, t[2] + 12 * i + 4) & 0xFFFFFF;
                    return new int[]{t[0], t[1], t[2], t[2] + 12 * i, n < 0 ? 0 : this.nameList + n, d < 0 ? 0 : this.resData + d};
                }
                ++i;
            }
        }
        return null;
    }

    private int[] locate(int type, String name) {
        int[] t = this.locateType(type);
        if (t != null) {
            int i = 0;
            while (i < t[1]) {
                short n = KSFLUtilities.getShort(this.arr, t[2] + 12 * i + 2);
                if (n >= 0 && this.gps(this.arr, this.nameList + n).equals(name)) {
                    int d = KSFLUtilities.getInt(this.arr, t[2] + 12 * i + 4) & 0xFFFFFF;
                    return new int[]{t[0], t[1], t[2], t[2] + 12 * i, n < 0 ? 0 : this.nameList + n, d < 0 ? 0 : this.resData + d};
                }
                ++i;
            }
        }
        return null;
    }

    private void cut(int[] loc, int offset, int length, int what, int type, short id) {
        boolean typeListAdjusted = false;
        boolean nameListAdjusted = false;
        boolean resDataAdjusted = false;
        this.arr = KSFLUtilities.cut(this.arr, offset, length);
        if (this.resMap > offset) {
            this.resMap -= length;
        }
        if (this.typeList > offset) {
            this.typeList -= length;
            typeListAdjusted = true;
        }
        if (this.nameList > offset) {
            this.nameList -= length;
            nameListAdjusted = true;
        }
        if (this.resData > offset) {
            this.resData -= length;
            resDataAdjusted = true;
        }
        if (what == 1 || what == 2 || what == 3) {
            this.resMapLen -= length;
        }
        if (what == 4) {
            this.resDataLen -= length;
        }
        if (loc != null) {
            if (loc.length > 0 && loc[0] > offset) {
                loc[0] = loc[0] - length;
            }
            if (loc.length > 1 && what == 2) {
                loc[1] = loc[1] - 1;
            }
            if (loc.length > 2 && loc[2] > offset) {
                loc[2] = loc[2] - length;
            }
            if (loc.length > 3 && loc[3] > offset) {
                loc[3] = loc[3] - length;
            }
            if (loc.length > 4 && loc[4] > offset) {
                loc[4] = loc[4] - length;
            }
            if (loc.length > 5 && loc[5] > offset) {
                loc[5] = loc[5] - length;
            }
        }
        KSFLUtilities.putInt(this.arr, 0, this.resData);
        KSFLUtilities.putInt(this.arr, 4, this.resMap);
        KSFLUtilities.putInt(this.arr, 8, this.resDataLen);
        KSFLUtilities.putInt(this.arr, 12, this.resMapLen);
        KSFLUtilities.putInt(this.arr, this.resMap + 0, this.resData);
        KSFLUtilities.putInt(this.arr, this.resMap + 4, this.resMap);
        KSFLUtilities.putInt(this.arr, this.resMap + 8, this.resDataLen);
        KSFLUtilities.putInt(this.arr, this.resMap + 12, this.resMapLen);
        KSFLUtilities.putShort(this.arr, this.resMap + 24, (short)(this.typeList - this.resMap));
        KSFLUtilities.putShort(this.arr, this.resMap + 26, (short)(this.nameList - this.resMap));
        int numtypes = KSFLUtilities.getShort(this.arr, this.typeList) + 1;
        if (what == 1) {
            KSFLUtilities.putShort(this.arr, this.typeList, (short)(--numtypes - 1));
        }
        int i = 0;
        while (i < numtypes) {
            int thistype = KSFLUtilities.getInt(this.arr, this.typeList + 2 + 8 * i);
            int numrefs = KSFLUtilities.getShort(this.arr, this.typeList + 2 + 8 * i + 4) + 1;
            if (what == 2 && thistype == type) {
                KSFLUtilities.putShort(this.arr, this.typeList + 2 + 8 * i + 4, (short)(--numrefs - 1));
            }
            int reflist = this.typeList + KSFLUtilities.getShort(this.arr, this.typeList + 2 + 8 * i + 6);
            if (!typeListAdjusted && reflist > offset) {
                KSFLUtilities.putShort(this.arr, this.typeList + 2 + 8 * i + 6, (short)((reflist -= length) - this.typeList));
            }
            int j = 0;
            while (j < numrefs) {
                short name = KSFLUtilities.getShort(this.arr, reflist + 12 * j + 2);
                int data = KSFLUtilities.getInt(this.arr, reflist + 12 * j + 4) & 0xFFFFFF;
                if (name >= 0 && !nameListAdjusted && this.nameList + name > offset) {
                    KSFLUtilities.putShort(this.arr, reflist + 12 * j + 2, (short)(name - length));
                }
                if (data >= 0 && !resDataAdjusted && this.resData + data > offset) {
                    KSFLUtilities.putInt(this.arr, reflist + 12 * j + 4, data - length & 0xFFFFFF | this.arr[reflist + 12 * j + 4] << 24);
                }
                ++j;
            }
            ++i;
        }
    }

    private void paste(int[] loc, int offset, byte[] stuff, int what, int type, short id) {
        boolean typeListAdjusted = false;
        boolean nameListAdjusted = false;
        boolean resDataAdjusted = false;
        this.arr = KSFLUtilities.paste(this.arr, offset, stuff);
        if (this.resMap >= offset) {
            this.resMap += stuff.length;
        }
        if (this.typeList >= offset) {
            this.typeList += stuff.length;
            typeListAdjusted = true;
        }
        if (this.nameList > offset || this.nameList == offset && what != 3) {
            this.nameList += stuff.length;
            nameListAdjusted = true;
        }
        if (this.resData > offset || this.resData == offset && what != 4) {
            this.resData += stuff.length;
            resDataAdjusted = true;
        }
        if (what == 1 || what == 2 || what == 3) {
            this.resMapLen += stuff.length;
        }
        if (what == 4) {
            this.resDataLen += stuff.length;
        }
        if (loc != null) {
            if (loc.length > 0 && (loc[0] > offset || loc[0] == offset && what != 1)) {
                loc[0] = loc[0] + stuff.length;
            }
            if (loc.length > 1 && what == 2) {
                loc[1] = loc[1] + 1;
            }
            if (loc.length > 2 && (loc[2] > offset || loc[2] == offset && what != 2)) {
                loc[2] = loc[2] + stuff.length;
            }
            if (loc.length > 3 && (loc[3] > offset || loc[3] == offset && what != 2)) {
                loc[3] = loc[3] + stuff.length;
            }
            if (loc.length > 4 && (loc[4] > offset || loc[4] == offset && what != 3)) {
                loc[4] = loc[4] + stuff.length;
            }
            if (loc.length > 5 && (loc[5] > offset || loc[5] == offset && what != 4)) {
                loc[5] = loc[5] + stuff.length;
            }
        }
        KSFLUtilities.putInt(this.arr, 0, this.resData);
        KSFLUtilities.putInt(this.arr, 4, this.resMap);
        KSFLUtilities.putInt(this.arr, 8, this.resDataLen);
        KSFLUtilities.putInt(this.arr, 12, this.resMapLen);
        KSFLUtilities.putInt(this.arr, this.resMap + 0, this.resData);
        KSFLUtilities.putInt(this.arr, this.resMap + 4, this.resMap);
        KSFLUtilities.putInt(this.arr, this.resMap + 8, this.resDataLen);
        KSFLUtilities.putInt(this.arr, this.resMap + 12, this.resMapLen);
        KSFLUtilities.putShort(this.arr, this.resMap + 24, (short)(this.typeList - this.resMap));
        KSFLUtilities.putShort(this.arr, this.resMap + 26, (short)(this.nameList - this.resMap));
        int numtypes = KSFLUtilities.getShort(this.arr, this.typeList) + 1;
        if (what == 1) {
            KSFLUtilities.putShort(this.arr, this.typeList, (short)(++numtypes - 1));
        }
        int i = 0;
        while (i < numtypes) {
            int thistype = KSFLUtilities.getInt(this.arr, this.typeList + 2 + 8 * i);
            int numrefs = KSFLUtilities.getShort(this.arr, this.typeList + 2 + 8 * i + 4) + 1;
            if (what == 2 && thistype == type) {
                KSFLUtilities.putShort(this.arr, this.typeList + 2 + 8 * i + 4, (short)(++numrefs - 1));
            }
            int reflist = this.typeList + KSFLUtilities.getShort(this.arr, this.typeList + 2 + 8 * i + 6);
            if (!(typeListAdjusted || reflist <= offset && (reflist != offset || what == 2 && thistype == type))) {
                KSFLUtilities.putShort(this.arr, this.typeList + 2 + 8 * i + 6, (short)((reflist += stuff.length) - this.typeList));
            }
            int j = 0;
            while (j < numrefs) {
                short thisid = KSFLUtilities.getShort(this.arr, reflist + 12 * j);
                short name = KSFLUtilities.getShort(this.arr, reflist + 12 * j + 2);
                int data = KSFLUtilities.getInt(this.arr, reflist + 12 * j + 4) & 0xFFFFFF;
                if (!(name < 0 || nameListAdjusted || this.nameList + name <= offset && (this.nameList + name != offset || what == 3 && thistype == type && thisid == id))) {
                    KSFLUtilities.putShort(this.arr, reflist + 12 * j + 2, (short)(name + stuff.length));
                }
                if (!(data < 0 || resDataAdjusted || this.resData + data <= offset && (this.resData + data != offset || what == 4 && thistype == type && thisid == id))) {
                    KSFLUtilities.putInt(this.arr, reflist + 12 * j + 4, data + stuff.length & 0xFFFFFF | this.arr[reflist + 12 * j + 4] << 24);
                }
                ++j;
            }
            ++i;
        }
    }

    public MacResourceArray() {
        this.arr = new byte[286];
        KSFLUtilities.putInt(this.arr, 0, 256);
        KSFLUtilities.putInt(this.arr, 4, 256);
        KSFLUtilities.putInt(this.arr, 8, 0);
        KSFLUtilities.putInt(this.arr, 12, 30);
        KSFLUtilities.putInt(this.arr, 256, 256);
        KSFLUtilities.putInt(this.arr, 260, 256);
        KSFLUtilities.putInt(this.arr, 264, 0);
        KSFLUtilities.putInt(this.arr, 268, 30);
        KSFLUtilities.putInt(this.arr, 272, 0);
        KSFLUtilities.putShort(this.arr, 276, (short)0);
        KSFLUtilities.putShort(this.arr, 278, (short)0);
        KSFLUtilities.putShort(this.arr, 280, (short)28);
        KSFLUtilities.putShort(this.arr, 282, (short)30);
        KSFLUtilities.putShort(this.arr, 284, (short)-1);
        this.resData = 256;
        this.resMap = 256;
        this.resDataLen = 0;
        this.resMapLen = 30;
        this.typeList = 284;
        this.nameList = 286;
    }

    public MacResourceArray(byte[] stuff) {
        this.arr = stuff;
        this.resData = KSFLUtilities.getInt(stuff, 0);
        this.resMap = KSFLUtilities.getInt(stuff, 4);
        this.resDataLen = KSFLUtilities.getInt(stuff, 8);
        this.resMapLen = KSFLUtilities.getInt(stuff, 12);
        this.typeList = this.resMap + KSFLUtilities.getShort(stuff, this.resMap + 24);
        this.nameList = this.resMap + KSFLUtilities.getShort(stuff, this.resMap + 26);
    }

    public synchronized String getTextEncoding() {
        return this.textEncoding;
    }

    public synchronized void setTextEncoding(String encoding) {
        this.textEncoding = encoding;
    }

    public byte[] getBytes() {
        return this.arr;
    }

    @Override
    public boolean isReadOnly() {
        return false;
    }

    @Override
    public synchronized void flush() {
    }

    @Override
    public synchronized void close() {
    }

    @Override
    public synchronized short getResourceMapAttributes() {
        return KSFLUtilities.getShort(this.arr, this.resMap + 22);
    }

    @Override
    public synchronized void setResourceMapAttributes(short attr) {
        KSFLUtilities.putShort(this.arr, this.resMap + 22, attr);
    }

    @Override
    public synchronized boolean add(MacResource r) throws MacResourceAlreadyExistsException {
        if (this.locate(r.type, r.id) != null) {
            throw new MacResourceAlreadyExistsException();
        }
        if (this.locateType(r.type) == null) {
            byte[] th = new byte[8];
            KSFLUtilities.putInt(th, 0, r.type);
            KSFLUtilities.putShort(th, 4, (short)-1);
            KSFLUtilities.putShort(th, 6, (short)(this.nameList - this.typeList));
            int lasttype = this.typeList + 2 + 8 * (KSFLUtilities.getShort(this.arr, this.typeList) + 1);
            this.paste(null, lasttype, th, 1, r.type, r.id);
        }
        int[] t = this.locateType(r.type);
        byte[] ref = new byte[12];
        KSFLUtilities.putShort(ref, 0, r.id);
        KSFLUtilities.putShort(ref, 2, r.name != null && r.name.length() > 0 ? (short)(this.resMap + this.resMapLen - this.nameList) : (short)-1);
        KSFLUtilities.putInt(ref, 4, this.resDataLen);
        ref[4] = r.getAttributes();
        KSFLUtilities.putInt(ref, 8, 0);
        this.paste(null, t[2] + 12 * t[1], ref, 2, r.type, r.id);
        if (r.name != null && r.name.length() > 0) {
            byte[] n = this.gb(r.name);
            if (n.length > 255) {
                n = KSFLUtilities.copy(n, 0, 255);
            }
            n = KSFLUtilities.paste(n, 0, new byte[]{(byte)n.length});
            this.paste(null, this.resMap + this.resMapLen, n, 3, r.type, r.id);
        }
        byte[] d = KSFLUtilities.paste(r.data, 0, 4);
        KSFLUtilities.putInt(d, 0, r.data.length);
        this.paste(null, this.resData + this.resDataLen, d, 4, r.type, r.id);
        return true;
    }

    @Override
    public synchronized boolean contains(int type, short id) {
        return this.locate(type, id) != null;
    }

    @Override
    public synchronized boolean contains(int type, String name) {
        return this.locate(type, name) != null;
    }

    @Override
    public synchronized MacResource get(int type, short id) {
        int[] l = this.locate(type, id);
        if (l != null) {
            return new MacResource(KSFLUtilities.getInt(this.arr, l[0]), KSFLUtilities.getShort(this.arr, l[3]), this.arr[l[3] + 4], l[4] > 0 ? this.gps(this.arr, l[4]) : "", l[5] > 0 ? KSFLUtilities.copy(this.arr, l[5] + 4, KSFLUtilities.getInt(this.arr, l[5])) : new byte[]{});
        }
        return null;
    }

    @Override
    public synchronized MacResource get(int type, String name) {
        int[] l = this.locate(type, name);
        if (l != null) {
            return new MacResource(KSFLUtilities.getInt(this.arr, l[0]), KSFLUtilities.getShort(this.arr, l[3]), this.arr[l[3] + 4], l[4] > 0 ? this.gps(this.arr, l[4]) : "", l[5] > 0 ? KSFLUtilities.copy(this.arr, l[5] + 4, KSFLUtilities.getInt(this.arr, l[5])) : new byte[]{});
        }
        return null;
    }

    @Override
    public synchronized MacResource getAttributes(int type, short id) {
        int[] l = this.locate(type, id);
        if (l != null) {
            return new MacResource(KSFLUtilities.getInt(this.arr, l[0]), KSFLUtilities.getShort(this.arr, l[3]), this.arr[l[3] + 4], l[4] > 0 ? this.gps(this.arr, l[4]) : "", new byte[0]);
        }
        return null;
    }

    @Override
    public synchronized MacResource getAttributes(int type, String name) {
        int[] l = this.locate(type, name);
        if (l != null) {
            return new MacResource(KSFLUtilities.getInt(this.arr, l[0]), KSFLUtilities.getShort(this.arr, l[3]), this.arr[l[3] + 4], l[4] > 0 ? this.gps(this.arr, l[4]) : "", new byte[0]);
        }
        return null;
    }

    @Override
    public synchronized byte[] getData(int type, short id) {
        int[] l = this.locate(type, id);
        if (l != null) {
            return l[5] > 0 ? KSFLUtilities.copy(this.arr, l[5] + 4, KSFLUtilities.getInt(this.arr, l[5])) : new byte[]{};
        }
        return null;
    }

    @Override
    public synchronized byte[] getData(int type, String name) {
        int[] l = this.locate(type, name);
        if (l != null) {
            return l[5] > 0 ? KSFLUtilities.copy(this.arr, l[5] + 4, KSFLUtilities.getInt(this.arr, l[5])) : new byte[]{};
        }
        return null;
    }

    @Override
    public synchronized boolean remove(int type, short id) {
        int[] loc = this.locate(type, id);
        if (loc != null) {
            if (loc[5] > 0) {
                int dlen = KSFLUtilities.getInt(this.arr, loc[5]) + 4;
                this.cut(loc, loc[5], dlen, 4, type, id);
            }
            if (loc[4] > 0) {
                int nlen = (this.arr[loc[4]] & 0xFF) + 1;
                this.cut(loc, loc[4], nlen, 3, type, id);
            }
            this.cut(loc, loc[3], 12, 2, type, id);
            if (loc[1] <= 0) {
                this.cut(loc, loc[0], 8, 1, type, id);
            }
            return true;
        }
        return false;
    }

    @Override
    public synchronized boolean remove(int type, String name) {
        int[] loc = this.locate(type, name);
        if (loc != null) {
            short id = KSFLUtilities.getShort(this.arr, loc[3]);
            if (loc[5] > 0) {
                int dlen = KSFLUtilities.getInt(this.arr, loc[5]) + 4;
                this.cut(loc, loc[5], dlen, 4, type, id);
            }
            if (loc[4] > 0) {
                int nlen = (this.arr[loc[4]] & 0xFF) + 1;
                this.cut(loc, loc[4], nlen, 3, type, id);
            }
            this.cut(loc, loc[3], 12, 2, type, id);
            if (loc[1] <= 0) {
                this.cut(loc, loc[0], 8, 1, type, id);
            }
            return true;
        }
        return false;
    }

    @Override
    public synchronized boolean set(int type, short id, MacResource r) throws MacResourceAlreadyExistsException {
        if (!this.contains(type, id)) {
            return false;
        }
        if (r.name == null) {
            r.name = "";
        }
        if (r.data == null) {
            r.data = new byte[0];
        }
        return this.setAttributes(type, id, r) && this.setData(r.type, r.id, r.data);
    }

    @Override
    public synchronized boolean set(int type, String name, MacResource r) throws MacResourceAlreadyExistsException {
        short id = this.getIDFromName(type, name);
        if (!this.contains(type, id)) {
            return false;
        }
        if (r.name == null) {
            r.name = "";
        }
        if (r.data == null) {
            r.data = new byte[0];
        }
        return this.setAttributes(type, id, r) && this.setData(r.type, r.id, r.data);
    }

    @Override
    public synchronized boolean setAttributes(int type, short id, MacResource r) throws MacResourceAlreadyExistsException {
        int[] loc = this.locate(type, id);
        if (loc != null) {
            int[] loce = this.locate(r.type, r.id);
            if (loce != null && (loce[0] != loc[0] || loce[1] != loc[1] || loce[2] != loc[2] || loce[3] != loc[3] || loce[4] != loc[4] || loce[5] != loc[5])) {
                throw new MacResourceAlreadyExistsException();
            }
            if (type != r.type) {
                if (this.locateType(r.type) == null) {
                    byte[] th = new byte[8];
                    KSFLUtilities.putInt(th, 0, r.type);
                    KSFLUtilities.putShort(th, 4, (short)-1);
                    KSFLUtilities.putShort(th, 6, (short)(this.nameList - this.typeList));
                    int lasttype = this.typeList + 2 + 8 * (KSFLUtilities.getShort(this.arr, this.typeList) + 1);
                    this.paste(loc, lasttype, th, 1, r.type, r.id);
                }
                int[] t = this.locateType(r.type);
                byte[] ref = new byte[12];
                KSFLUtilities.putShort(ref, 0, r.id);
                KSFLUtilities.putShort(ref, 2, loc[4] > 0 ? (short)(loc[4] - this.nameList) : (short)-1);
                KSFLUtilities.putInt(ref, 4, loc[5] > 0 ? loc[5] - this.resData : -1);
                ref[4] = r.getAttributes();
                KSFLUtilities.putInt(ref, 8, 0);
                this.paste(loc, t[2] + 12 * t[1], ref, 2, r.type, r.id);
                this.cut(loc, loc[3], 12, 2, type, id);
                if (KSFLUtilities.getShort(this.arr, loc[0] + 4) < 0) {
                    this.cut(loc, loc[0], 8, 1, type, id);
                }
            } else {
                KSFLUtilities.putShort(this.arr, loc[3], r.id);
                this.arr[loc[3] + 4] = r.getAttributes();
            }
            if (r.name != null && r.name.length() > 0) {
                byte[] n = this.gb(r.name);
                if (n.length > 255) {
                    n = KSFLUtilities.copy(n, 0, 255);
                }
                n = KSFLUtilities.paste(n, 0, new byte[]{(byte)n.length});
                if (loc[4] > 0) {
                    this.paste(loc, loc[4], n, 3, r.type, r.id);
                    this.cut(loc, loc[4] + n.length, (this.arr[loc[4] + n.length] & 0xFF) + 1, 3, r.type, r.id);
                } else {
                    KSFLUtilities.putShort(this.arr, loc[3] + 2, (short)(this.resMap + this.resMapLen - this.nameList));
                    this.paste(loc, this.resMap + this.resMapLen, n, 3, r.type, r.id);
                }
            } else if (loc[4] > 0) {
                this.cut(loc, loc[4], (this.arr[loc[4]] & 0xFF) + 1, 3, r.type, r.id);
                KSFLUtilities.putShort(this.arr, loc[3] + 2, (short)-1);
                loc[4] = 0;
            }
            return true;
        }
        return false;
    }

    @Override
    public synchronized boolean setAttributes(int type, String name, MacResource r) throws MacResourceAlreadyExistsException {
        int[] loc = this.locate(type, name);
        if (loc != null) {
            int[] loce = this.locate(r.type, r.id);
            if (loce != null && (loce[0] != loc[0] || loce[1] != loc[1] || loce[2] != loc[2] || loce[3] != loc[3] || loce[4] != loc[4] || loce[5] != loc[5])) {
                throw new MacResourceAlreadyExistsException();
            }
            short id = KSFLUtilities.getShort(this.arr, loc[3]);
            if (type != r.type) {
                if (this.locateType(r.type) == null) {
                    byte[] th = new byte[8];
                    KSFLUtilities.putInt(th, 0, r.type);
                    KSFLUtilities.putShort(th, 4, (short)-1);
                    KSFLUtilities.putShort(th, 6, (short)(this.nameList - this.typeList));
                    int lasttype = this.typeList + 2 + 8 * (KSFLUtilities.getShort(this.arr, this.typeList) + 1);
                    this.paste(loc, lasttype, th, 1, r.type, r.id);
                }
                int[] t = this.locateType(r.type);
                byte[] ref = new byte[12];
                KSFLUtilities.putShort(ref, 0, r.id);
                KSFLUtilities.putShort(ref, 2, loc[4] > 0 ? (short)(loc[4] - this.nameList) : (short)-1);
                KSFLUtilities.putInt(ref, 4, loc[5] > 0 ? loc[5] - this.resData : -1);
                ref[4] = r.getAttributes();
                KSFLUtilities.putInt(ref, 8, 0);
                this.paste(loc, t[2] + 12 * t[1], ref, 2, r.type, r.id);
                this.cut(loc, loc[3], 12, 2, type, id);
                if (KSFLUtilities.getShort(this.arr, loc[0] + 4) < 0) {
                    this.cut(loc, loc[0], 8, 1, type, id);
                }
            } else {
                KSFLUtilities.putShort(this.arr, loc[3], r.id);
                this.arr[loc[3] + 4] = r.getAttributes();
            }
            if (r.name != null && r.name.length() > 0) {
                byte[] n = this.gb(r.name);
                if (n.length > 255) {
                    n = KSFLUtilities.copy(n, 0, 255);
                }
                n = KSFLUtilities.paste(n, 0, new byte[]{(byte)n.length});
                if (loc[4] > 0) {
                    this.paste(loc, loc[4], n, 3, r.type, r.id);
                    this.cut(loc, loc[4] + n.length, (this.arr[loc[4] + n.length] & 0xFF) + 1, 3, r.type, r.id);
                } else {
                    KSFLUtilities.putShort(this.arr, loc[3] + 2, (short)(this.resMap + this.resMapLen - this.nameList));
                    this.paste(loc, this.resMap + this.resMapLen, n, 3, r.type, r.id);
                }
            } else if (loc[4] > 0) {
                this.cut(loc, loc[4], (this.arr[loc[4]] & 0xFF) + 1, 3, r.type, r.id);
                KSFLUtilities.putShort(this.arr, loc[3] + 2, (short)-1);
                loc[4] = 0;
            }
            return true;
        }
        return false;
    }

    @Override
    public synchronized boolean setData(int type, short id, byte[] data) {
        int[] loc = this.locate(type, id);
        if (loc != null) {
            if (loc[5] > 0) {
                int dlen = KSFLUtilities.getInt(this.arr, loc[5]) + 4;
                this.cut(loc, loc[5], dlen, 4, type, id);
            } else {
                loc[5] = this.resData + this.resDataLen;
            }
            byte[] d = KSFLUtilities.paste(data, 0, 4);
            KSFLUtilities.putInt(d, 0, data.length);
            this.paste(loc, loc[5], d, 4, type, id);
            return true;
        }
        return false;
    }

    @Override
    public synchronized boolean setData(int type, String name, byte[] data) {
        int[] loc = this.locate(type, name);
        if (loc != null) {
            short id = KSFLUtilities.getShort(this.arr, loc[3]);
            if (loc[5] > 0) {
                int dlen = KSFLUtilities.getInt(this.arr, loc[5]) + 4;
                this.cut(loc, loc[5], dlen, 4, type, id);
            } else {
                loc[5] = this.resData + this.resDataLen;
            }
            byte[] d = KSFLUtilities.paste(data, 0, 4);
            KSFLUtilities.putInt(d, 0, data.length);
            this.paste(loc, loc[5], d, 4, type, id);
            return true;
        }
        return false;
    }

    @Override
    public synchronized int getTypeCount() {
        return KSFLUtilities.getShort(this.arr, this.typeList) + 1;
    }

    @Override
    public synchronized int getType(int index) {
        return KSFLUtilities.getInt(this.arr, this.typeList + 2 + 8 * index);
    }

    @Override
    public synchronized int[] getTypes() {
        int m = KSFLUtilities.getShort(this.arr, this.typeList) + 1;
        int[] a = new int[m];
        int i = 0;
        while (i < m) {
            a[i] = KSFLUtilities.getInt(this.arr, this.typeList + 2 + 8 * i);
            ++i;
        }
        return a;
    }

    @Override
    public synchronized int getResourceCount(int type) {
        int[] t = this.locateType(type);
        if (t != null) {
            return t[1];
        }
        return 0;
    }

    @Override
    public synchronized short getID(int type, int index) {
        int[] t = this.locateType(type);
        if (t != null) {
            return KSFLUtilities.getShort(this.arr, t[2] + 12 * index);
        }
        return 0;
    }

    @Override
    public synchronized short[] getIDs(int type) {
        int[] t = this.locateType(type);
        if (t != null) {
            short[] a = new short[t[1]];
            int i = 0;
            while (i < t[1]) {
                a[i] = KSFLUtilities.getShort(this.arr, t[2] + 12 * i);
                ++i;
            }
            return a;
        }
        return new short[0];
    }

    @Override
    public String getName(int type, int index) {
        int[] t = this.locateType(type);
        if (t != null) {
            short n = KSFLUtilities.getShort(this.arr, t[2] + 12 * index + 2);
            if (n < 0) {
                return "";
            }
            return this.gps(this.arr, this.nameList + n);
        }
        return "";
    }

    @Override
    public String[] getNames(int type) {
        ArrayList<String> a = new ArrayList<String>();
        int[] t = this.locateType(type);
        if (t != null) {
            int i = 0;
            while (i < t[1]) {
                short n = KSFLUtilities.getShort(this.arr, t[2] + 12 * i + 2);
                if (n < 0) {
                    a.add("");
                } else {
                    a.add(this.gps(this.arr, this.nameList + n));
                }
                ++i;
            }
        }
        return a.toArray(new String[0]);
    }

    @Override
    public synchronized short getNextAvailableID(int type, short start) {
        ArrayList<Short> a = new ArrayList<Short>();
        int[] t = this.locateType(type);
        if (t != null) {
            int i = 0;
            while (i < t[1]) {
                a.add(KSFLUtilities.getShort(this.arr, t[2] + 12 * i));
                ++i;
            }
        }
        short next = start;
        while (a.contains(next)) {
            next = (short)(next + 1);
        }
        return next;
    }

    @Override
    public synchronized String getNameFromID(int type, short id) {
        int[] l = this.locate(type, id);
        if (l != null) {
            return l[4] > 0 ? this.gps(this.arr, l[4]) : "";
        }
        return "";
    }

    @Override
    public synchronized short getIDFromName(int type, String name) {
        int[] l = this.locate(type, name);
        if (l != null) {
            return KSFLUtilities.getShort(this.arr, l[3]);
        }
        return 0;
    }
}

