from mpl_toolkits.basemap import Basemap
import numpy as np
import matplotlib.pyplot as plt
lon_0 = -105; lat_0 = 40
m = Basemap(projection='aeqd',lat_0=lat_0,lon_0=lon_0)
# fill background.
m.drawmapboundary(fill_color='aqua')
# draw coasts and fill continents.
m.drawcoastlines(linewidth=0.5)
m.fillcontinents(color='coral',lake_color='aqua')
# 20 degree graticule.
m.drawparallels(np.arange(-80,81,20))
m.drawmeridians(np.arange(-180,180,20))
# draw a black dot at the center.
xpt, ypt = m(lon_0, lat_0)
m.plot([xpt],[ypt],'ko') 
# draw the title.
plt.title('Whole World Azimuthal Equidistant Projection')
plt.show()
