#!/usr/bin/env sh

# $1 is the name of a file like tmp-device-info as generated by
# ./bootstrap  (via ./devtools/gen-avr-lib-tree.sh).
# The first row of :-separated values is an mcu as potentially supported
# by avr-gcc / AVR-LibC.

# When $1 is not a regular file, then $1 is taken as a list of MCUs.

# Print to stdout a list of all lines with  _vect  in them,
# including the sourrounding context of 1 line before and after,
# where the text comes from pre-processing
#
#	# include <avr/io.h>
#
# The output is something like (for atmega8):
#
#	::atmega8::
#	/* External Interrupt Request 0 */
#	#define INT0_vect_num 1
#	#define INT0_vect _VECTOR(1)
#	--
#	/* External Interrupt Request 1 */
#	#define INT1_vect_num 2
#	#define INT1_vect _VECTOR(2)
#	--

dinfo=$1

if [ -f "${dinfo}" ]; then
    mcus=$(awk -F: '{ print $1 }' ${dinfo})
else
    mcus="${dinfo}"
fi

for mcu in $mcus
do
    echo "::$mcu::"

    # Preprocess the device header avr/io.h.
    # We use assembly so ATtiny11 etc. work as well without diagnostic.
    # -E:  Preprocess only.
    # -CC: Keep comments, even the ones in macro definitions.
    # -g3: DWARF3 or higher includes all macro definitions.
    echo "#include <avr/io.h>" \
	| ${CC-avr-gcc} -mmcu=${mcu} -x assembler-with-cpp - -E -CC -g3 2>&1 \
	| grep -C1 "define.*_vect[ \t_]"
done

