# -*- coding: utf-8 -*-
# Generated by Django 1.9 on 2016-01-25 17:57

import autoradio.spots.models
from django.db import migrations, models


class Migration(migrations.Migration):

    initial = True

    dependencies = [
    ]

    operations = [
        migrations.CreateModel(
            name='Configure',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('sezione', models.CharField(default=b'spot', editable=False, max_length=50, unique=True)),
                ('active', models.BooleanField(default=True, help_text='activate/deactivate the intere spot class', verbose_name='Activate Spot')),
                ('emission_starttime', models.TimeField(blank=True, help_text='The start time from wich the spot will be active', null=True, verbose_name='Programmed start time')),
                ('emission_endtime', models.TimeField(blank=True, help_text='The end time the spot will be active', null=True, verbose_name='Programmed end time')),
            ],
        ),
        migrations.CreateModel(
            name='Fascia',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(help_text='The name of commercial break', max_length=50, unique=True)),
                ('emission_time', models.TimeField(help_text='This is the date and time when the commercial break will be on air', unique=True)),
                ('active', models.BooleanField(default=True, help_text='Activate the commercial break for emission', verbose_name='Active')),
                ('emission_done', models.DateTimeField(editable=False, null=True, verbose_name='Emission done')),
            ],
        ),
        migrations.CreateModel(
            name='Giorno',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(choices=[('luned\xec', 'luned\xec'), ('marted\xec', 'marted\xec'), ('mercoled\xec', 'mercoled\xec'), ('gioved\xec', 'gioved\xec'), ('venerd\xec', 'venerd\xec'), ('sabato', 'sabato'), ('domenica', 'domenica')], help_text='weekday name', max_length=20, unique=True)),
            ],
        ),
        migrations.CreateModel(
            name='Spot',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('spot', models.CharField(help_text='The name of the spot', max_length=80, unique=True, verbose_name='Spot Name')),
                ('file', autoradio.spots.models.DeletingFileField(help_text='The spot file to upload', max_length=255, upload_to=b'spots', verbose_name='File')),
                ('rec_date', models.DateTimeField(help_text='When the spot was done (for reference only)', verbose_name='Record date')),
                ('active', models.BooleanField(default=True, help_text='Activate the spot for emission', verbose_name='Active')),
                ('start_date', models.DateTimeField(blank=True, help_text='The spot will be scheduled starting from this date', null=True, verbose_name='Programmed starting date')),
                ('end_date', models.DateTimeField(blank=True, help_text='The spot will be scheduled ending this date', null=True, verbose_name='Programmed ending date')),
                ('priorita', models.IntegerField(default=50, help_text='The order of the spots in commercial breaks will be ordered by this numer', verbose_name='Priority')),
                ('prologo', models.BooleanField(default=False, help_text='This spot will be the firt in commercial breaks to introduce the others', verbose_name='Prologue')),
                ('epilogo', models.BooleanField(default=False, help_text='This spot will be the last in commercial breaks to leave-taking', verbose_name='Epilogue')),
                ('fasce', models.ManyToManyField(blank=True, help_text='The spot will be included in those commercial break', to='spots.Fascia')),
                ('giorni', models.ManyToManyField(blank=True, help_text='The spot will be scheduled those weekdays', to='spots.Giorno', verbose_name='Programmed days')),
            ],
        ),
    ]
