/*******************************************************************************
 * Copyright (c) 2000, 2010 IBM Corporation and others.
 *
 * This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License 2.0
 * which accompanies this distribution, and is available at
 * https://www.eclipse.org/legal/epl-2.0/
 *
 * SPDX-License-Identifier: EPL-2.0
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.aspectj.org.eclipse.jdt.internal.core;

import org.aspectj.org.eclipse.jdt.core.IAnnotation;
import org.aspectj.org.eclipse.jdt.core.ISourceRange;
import org.aspectj.org.eclipse.jdt.core.SourceRange;

public class AnnotatableInfo extends MemberElementInfo {

	/*
	 * The annotations of this annotatble. Empty if none.
	 */
	protected IAnnotation[] annotations = Annotation.NO_ANNOTATIONS;

	/**
	 * The start position of this member's name in the its
	 * openable's buffer.
	 */
	protected int nameStart= -1;

	/**
	 * The last position of this member's name in the its
	 * openable's buffer.
	 */
	protected int nameEnd= -1;

	/**
	 * @see org.aspectj.org.eclipse.jdt.internal.compiler.env.ISourceType#getNameSourceEnd()
	 * @see org.aspectj.org.eclipse.jdt.internal.compiler.env.ISourceMethod#getNameSourceEnd()
	 * @see org.aspectj.org.eclipse.jdt.internal.compiler.env.ISourceField#getNameSourceEnd()
	 */
	@Override
	public int getNameSourceEnd() {
		return this.nameEnd;
	}
	/**
	 * @see org.aspectj.org.eclipse.jdt.internal.compiler.env.ISourceType#getNameSourceStart()
	 * @see org.aspectj.org.eclipse.jdt.internal.compiler.env.ISourceMethod#getNameSourceStart()
	 * @see org.aspectj.org.eclipse.jdt.internal.compiler.env.ISourceField#getNameSourceStart()
	 */
	@Override
	public int getNameSourceStart() {
		return this.nameStart;
	}
	/**
	 * Sets the last position of this member's name, relative
	 * to its openable's source buffer.
	 */
	protected void setNameSourceEnd(int end) {
		this.nameEnd= end;
	}
	/**
	 * Sets the start position of this member's name, relative
	 * to its openable's source buffer.
	 */
	protected void setNameSourceStart(int start) {
		this.nameStart= start;
	}
	protected ISourceRange getNameRange() {
		return new SourceRange(this.nameStart, this.nameEnd - this.nameStart + 1);
	}
}
