/*
 * This file was automatically generated by EvoSuite
 * Thu Sep 20 12:04:19 GMT 2018
 */

package uk.ac.sanger.artemis.components;

import org.junit.Test;
import static org.junit.Assert.*;
import static org.evosuite.runtime.EvoAssertions.*;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.datatransfer.Clipboard;
import java.awt.image.BufferedImage;
import org.evosuite.runtime.EvoRunner;
import org.evosuite.runtime.EvoRunnerParameters;
import org.junit.runner.RunWith;
import uk.ac.sanger.artemis.EntryGroup;
import uk.ac.sanger.artemis.Selection;
import uk.ac.sanger.artemis.SelectionChangeEvent;
import uk.ac.sanger.artemis.SimpleEntryGroup;
import uk.ac.sanger.artemis.components.SelectionInfoDisplay;

@RunWith(EvoRunner.class) @EvoRunnerParameters(mockJVMNonDeterminism = true, useVFS = true, useVNET = true, resetStaticState = true, useJEE = true) 
public class SelectionInfoDisplay_ESTest extends SelectionInfoDisplay_ESTest_scaffolding {

  @Test(timeout = 4000)
  public void test0()  throws Throwable  {
      Clipboard clipboard0 = new Clipboard((String) null);
      Selection selection0 = new Selection(clipboard0);
      SimpleEntryGroup simpleEntryGroup0 = new SimpleEntryGroup();
      String string0 = SelectionInfoDisplay.markerRangeText(selection0, simpleEntryGroup0);
      assertEquals("", string0);
  }

  @Test(timeout = 4000)
  public void test1()  throws Throwable  {
      SimpleEntryGroup simpleEntryGroup0 = new SimpleEntryGroup();
      Clipboard clipboard0 = new Clipboard("AP}i;^}DZZjq");
      Selection selection0 = new Selection(clipboard0);
      SelectionInfoDisplay selectionInfoDisplay0 = new SelectionInfoDisplay(simpleEntryGroup0, selection0);
      // Undeclared exception!
      try { 
        selectionInfoDisplay0.paintComponent((Graphics) null);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("javax.swing.JComponent", e);
      }
  }

  @Test(timeout = 4000)
  public void test2()  throws Throwable  {
      SimpleEntryGroup simpleEntryGroup0 = new SimpleEntryGroup();
      // Undeclared exception!
      try { 
        SelectionInfoDisplay.markerRangeText((Selection) null, simpleEntryGroup0);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.components.SelectionInfoDisplay", e);
      }
  }

  @Test(timeout = 4000)
  public void test3()  throws Throwable  {
      SelectionInfoDisplay selectionInfoDisplay0 = null;
      try {
        selectionInfoDisplay0 = new SelectionInfoDisplay((EntryGroup) null, (Selection) null);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.components.SelectionInfoDisplay", e);
      }
  }

  @Test(timeout = 4000)
  public void test4()  throws Throwable  {
      SimpleEntryGroup simpleEntryGroup0 = new SimpleEntryGroup();
      Clipboard clipboard0 = new Clipboard("\"V1OTrJS\f+");
      Selection selection0 = new Selection(clipboard0);
      SelectionInfoDisplay selectionInfoDisplay0 = new SelectionInfoDisplay(simpleEntryGroup0, selection0);
      BufferedImage bufferedImage0 = new BufferedImage(3, 3, 1);
      Graphics graphics2D0 = bufferedImage0.getGraphics();
      selectionInfoDisplay0.paintComponent(graphics2D0);
      assertEquals((-16777216), graphics2D0.getColor().getRGB());
  }

  @Test(timeout = 4000)
  public void test5()  throws Throwable  {
      SimpleEntryGroup simpleEntryGroup0 = new SimpleEntryGroup();
      Clipboard clipboard0 = new Clipboard("\"V1OTrJS\f+");
      Selection selection0 = new Selection(clipboard0);
      SelectionInfoDisplay selectionInfoDisplay0 = new SelectionInfoDisplay(simpleEntryGroup0, selection0);
      Dimension dimension0 = selectionInfoDisplay0.getPreferredSize();
      assertEquals(10, dimension0.width);
  }

  @Test(timeout = 4000)
  public void test6()  throws Throwable  {
      SimpleEntryGroup simpleEntryGroup0 = new SimpleEntryGroup();
      Clipboard clipboard0 = new Clipboard("\"V1OTrJS\f+");
      Selection selection0 = new Selection(clipboard0);
      SelectionInfoDisplay selectionInfoDisplay0 = new SelectionInfoDisplay(simpleEntryGroup0, selection0);
      Dimension dimension0 = selectionInfoDisplay0.getMinimumSize();
      SelectionChangeEvent selectionChangeEvent0 = new SelectionChangeEvent(dimension0, 15);
      selectionInfoDisplay0.selectionChanged(selectionChangeEvent0);
      assertEquals(10, dimension0.width);
      assertEquals(10.0, dimension0.getWidth(), 0.01);
  }
}
