/**
 *  @file       mc.h
 *  @ingroup    global_mc
 *  @brief      The foundation header for MC. 
 *  @note       This is the main header file for all of MC.
 *              This is the only file that needs to be included
 *              in the problem-specific main driver program.
 *  @version    $Id: mc.h,v 1.14 2010/08/12 05:18:13 fetk Exp $ 
 *  @author     Michael Holst
 *
 *  @attention
 *  @verbatim
 *
 * MC = < Manifold Code >
 * Copyright (C) 1994-- Michael Holst
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 * @endverbatim
 */

#ifndef _MC_H_
#define _MC_H_

#include <mc/mc_base.h>

#include <mc/bam.h>
#include <mc/aprx.h>
#include <mc/pde.h>
#include <mc/gem.h>
#include <mc/nam.h>
#include <mc/dyn.h>
#include <mc/mcsh.h>

#endif /* _MC_H_ */

