/* decidewin.c - decision dialog
 *
 * Copyright 2010 Petteri Hintsanen <petterih@iki.fi>
 *
 * This file is part of abx.
 *
 * abx is free software: you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * abx is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 * or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public
 * License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with abx.  If not, see <http://www.gnu.org/licenses/>.
 */

#include "gtkui.h"
#include "test.h"

static GtkWidget *dialog;

/*
 * Handle button responses.  Close test and display result window, if
 * the current trial is the last one.
 */
static void
response_handler(GtkWidget *widget, gint response, gpointer data)
{
    switch (response) {
    case 0:
    case 1:
        set_guess(current_trial, response);
        gtk_widget_hide_all(dialog);
        if (current_trial == num_test_trials() - 1) {
            /* test over */
            show_result_window();
            close_test();
            current_trial = -1;
            update_main_window();
        } else {
            /* proceed to the next trial */
            current_trial++;
            update_main_window();
        }
        break;
    case GTK_RESPONSE_DELETE_EVENT:
    case GTK_RESPONSE_CANCEL:
        gtk_widget_hide_all(dialog);
        break;
    }
}

/*
 * Build and show decide dialog with the given parent window.
 */
void
show_decide_dialog(GtkWindow *parent)
{
    if (dialog) {
        gtk_widget_show_all(dialog);
    } else {
        dialog = (gtk_message_dialog_new
                  (parent, GTK_DIALOG_DESTROY_WITH_PARENT,
                   GTK_MESSAGE_QUESTION, GTK_BUTTONS_NONE, "Decide X"));
        gtk_window_set_title(GTK_WINDOW(dialog), "Decision");
        gtk_message_dialog_format_secondary_text
            (GTK_MESSAGE_DIALOG(dialog), "Which one is X, A or B?");
        
        gtk_dialog_add_button(GTK_DIALOG(dialog), "_A", 0);
        gtk_dialog_add_button(GTK_DIALOG(dialog), "_B", 1);
        gtk_dialog_add_button(GTK_DIALOG(dialog),
                              GTK_STOCK_CANCEL, GTK_RESPONSE_CANCEL);
        g_signal_connect(dialog, "response",
                         G_CALLBACK(response_handler), NULL);
        gtk_widget_show_all(dialog);
    }
}

void
hide_decide_dialog(void)
{
    if (dialog) {
        gtk_widget_hide_all(dialog);
    }
}
