/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.lib.ui.components;

import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.swing.JComponent;
import javax.swing.border.Border;
import org.graalvm.visualvm.lib.ui.components.ImageBlenderPanel;

public class ComponentMorpher
extends JComponent
implements ComponentListener,
Accessible {
    private ImageBlenderPanel blenderPanel;
    private JComponent component1;
    private JComponent component2;
    private JComponent currentComponent;
    private JComponent endComponent;
    private JComponent startComponent;
    private boolean isMorphing = false;
    private float heightDelta;
    private int morphingDelay;
    private int morphingStep;
    private int morphingSteps;

    public ComponentMorpher(JComponent component1, JComponent component2) {
        this(component1, component2, 10, 15);
    }

    public ComponentMorpher(JComponent component1, JComponent component2, int morphingSteps, int morphingDelay) {
        this.component1 = component1;
        this.component2 = component2;
        this.setMorphingSteps(morphingSteps);
        this.setMorphingDelay(morphingDelay);
        this.setLayout(null);
        this.setCurrentComponent(component1);
        this.addComponentListener(this);
    }

    @Override
    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new AccessibleComponentMorpher();
        }
        return this.accessibleContext;
    }

    @Override
    public void setBorder(Border border) {
        super.setBorder(border);
        this.setClientPreferredSize(this.currentComponent.getPreferredSize());
    }

    public boolean isExpanded() {
        return this.currentComponent == this.component2;
    }

    public boolean isMorphing() {
        return this.isMorphing;
    }

    public void setMorphingDelay(int morphingDelay) {
        this.morphingDelay = morphingDelay;
    }

    public int getMorphingDelay() {
        return this.morphingDelay;
    }

    public void setMorphingSteps(int morphingSteps) {
        this.morphingSteps = morphingSteps;
    }

    public int getMorphingSteps() {
        return this.morphingSteps;
    }

    @Override
    public void componentHidden(ComponentEvent e) {
    }

    @Override
    public void componentMoved(ComponentEvent e) {
    }

    @Override
    public void componentResized(ComponentEvent e) {
        if (!this.isMorphing && this.currentComponent != null) {
            this.setCurrentComponent(this.currentComponent);
            this.revalidate();
        }
    }

    @Override
    public void componentShown(ComponentEvent e) {
    }

    public void expand() {
        if (this.currentComponent != this.component2) {
            this.setCurrentComponent(this.component2);
        }
    }

    public void morph() {
        if (!this.isMorphing()) {
            new MorpherThread().start();
        }
    }

    public void morphingStep() {
        if (this.morphingStep > this.morphingSteps) {
            return;
        }
        if (this.endComponent.getSize().height != this.endComponent.getPreferredSize().height) {
            this.endComponent.setSize(new Dimension(this.getClientSize().width, this.endComponent.getPreferredSize().height));
            this.heightDelta = (float)(this.endComponent.getSize().height - this.startComponent.getSize().height) / (float)(this.morphingStep == 0 ? this.morphingSteps : this.morphingSteps - this.morphingStep + 1);
        }
        if (this.morphingStep == 0) {
            if (this.endComponent == this.component2) {
                this.setCurrentComponent(this.endComponent);
            }
            this.setClientPreferredSize(this.startComponent.getSize());
        } else if (this.morphingStep == this.morphingSteps) {
            if (this.endComponent == this.component1) {
                this.setCurrentComponent(this.endComponent);
            }
            this.setClientPreferredSize(this.endComponent.getSize());
            this.isMorphing = false;
        } else {
            this.setClientPreferredSize(new Dimension(this.endComponent.getSize().width, this.startComponent.getSize().height + (int)((float)this.morphingStep * this.heightDelta)));
        }
        this.revalidate();
        ++this.morphingStep;
    }

    public void refreshLayout() {
        if (this.currentComponent != null) {
            this.setCurrentComponent(this.currentComponent);
        }
        this.revalidate();
    }

    public void reset() {
        if (this.currentComponent != this.component1) {
            this.setCurrentComponent(this.component1);
        }
    }

    public void setupMorphing() {
        this.startComponent = this.layoutComponent(this.currentComponent == this.component1 ? this.component1 : this.component2);
        this.endComponent = this.layoutComponent(this.currentComponent == this.component1 ? this.component2 : this.component1);
        this.heightDelta = (float)(this.endComponent.getSize().height - this.startComponent.getSize().height) / (float)this.morphingSteps;
        this.morphingStep = 0;
        this.isMorphing = true;
        this.setCurrentComponent(this.startComponent);
    }

    private void setClientPreferredSize(Dimension size) {
        Insets insets = this.getInsets();
        this.setPreferredSize(new Dimension(size.width + insets.left + insets.right, size.height + insets.top + insets.bottom));
    }

    private Dimension getClientSize() {
        Dimension size = this.getSize();
        Insets insets = this.getInsets();
        return new Dimension(size.width - insets.left - insets.right, size.height - insets.top - insets.bottom);
    }

    private void setCurrentComponent(JComponent component) {
        boolean sameComponents;
        boolean bl = sameComponents = component == this.currentComponent;
        if (!sameComponents && this.currentComponent != null) {
            this.remove(this.currentComponent);
        }
        this.currentComponent = component = this.layoutComponent(component);
        if (!sameComponents) {
            this.add(this.currentComponent);
        }
        Insets insets = this.getInsets();
        this.currentComponent.setLocation(insets.left, insets.top);
        this.setClientPreferredSize(component.getSize());
    }

    private JComponent layoutComponent(JComponent component) {
        if (this.getClientSize().width > 0) {
            component.setSize(this.getClientSize());
            component.validate();
            component.setSize(new Dimension(this.getClientSize().width, component.getPreferredSize().height));
            component.validate();
        }
        return component;
    }

    protected class AccessibleComponentMorpher
    extends JComponent.AccessibleJComponent {
        protected AccessibleComponentMorpher() {
            super(ComponentMorpher.this);
        }

        @Override
        public AccessibleRole getAccessibleRole() {
            return AccessibleRole.PUSH_BUTTON;
        }
    }

    private class MorpherThread
    extends Thread {
        private MorpherThread() {
        }

        @Override
        public void run() {
            ComponentMorpher.this.setupMorphing();
            while (ComponentMorpher.this.isMorphing()) {
                ComponentMorpher.this.morphingStep();
                try {
                    Thread.sleep(ComponentMorpher.this.morphingDelay);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }
}

