/*
 * Decompiled with CFR 0.152.
 */
package net.sf.sdedit.ui.components.navigator;

import java.util.LinkedList;
import java.util.ListIterator;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.tree.TreePath;

public class TreeNavigatorNode {
    private String title;
    private Icon icon;
    private JComponent component;
    private LinkedList<TreeNavigatorNode> children = new LinkedList();
    private TreeNavigatorNode parent;

    public TreeNavigatorNode(String title, Icon icon, JComponent component) {
        this.title = title;
        this.icon = icon;
        this.component = component;
    }

    public TreePath getTreePath() {
        if (this.parent != null) {
            return this.parent.getTreePath().pathByAddingChild(this);
        }
        return new TreePath(this);
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public TreeNavigatorNode getParent() {
        return this.parent;
    }

    public String getTitle() {
        return this.title;
    }

    public Icon getIcon() {
        return this.icon;
    }

    public JComponent getComponent() {
        return this.component;
    }

    public int addChild(TreeNavigatorNode child, TreeNavigatorNode previousSibling) {
        int pos;
        if (previousSibling == null) {
            pos = this.children.size();
            this.children.add(child);
        } else {
            pos = this.children.indexOf(previousSibling) + 1;
            if (pos < this.children.size() - 1) {
                LinkedList<TreeNavigatorNode> tail = new LinkedList<TreeNavigatorNode>();
                for (TreeNavigatorNode node : this.children.subList(pos, this.children.size())) {
                    tail.add(node);
                }
                this.children.set(pos, child);
                this.children.add(null);
                int i = 0;
                for (TreeNavigatorNode tailNode : tail) {
                    this.children.set(pos + i + 1, tailNode);
                }
            }
        }
        child.parent = this;
        return pos;
    }

    public void removeChild(TreeNavigatorNode child) {
        this.children.remove(child);
    }

    public void removeChildByComponent(JComponent component) {
        ListIterator iter = this.children.listIterator();
        while (iter.hasNext()) {
            TreeNavigatorNode next = (TreeNavigatorNode)iter.next();
            if (next.getComponent() != component) continue;
            iter.remove();
            break;
        }
    }

    public boolean equals(Object o) {
        TreeNavigatorNode tnn = (TreeNavigatorNode)o;
        return tnn.component == this.component;
    }

    public TreeNavigatorNode[] getChildren() {
        return this.children.toArray(new TreeNavigatorNode[this.children.size()]);
    }

    public TreeNavigatorNode getChild(int index) {
        return this.children.get(index);
    }

    public int getChildCount() {
        return this.children.size();
    }
}

