/*
 * Decompiled with CFR 0.152.
 */
package org.thymeleaf.context;

import org.thymeleaf.context.IContext;
import org.thymeleaf.context.IEngineContext;
import org.thymeleaf.context.IWebContext;
import org.thymeleaf.web.IWebExchange;
import org.thymeleaf.web.servlet.IServletWebExchange;

public final class Contexts {
    private Contexts() {
    }

    public static boolean isEngineContext(IContext context) {
        return context instanceof IEngineContext;
    }

    public static IEngineContext asEngineContext(IContext context) {
        return (IEngineContext)context;
    }

    public static boolean isWebContext(IContext context) {
        return context instanceof IWebContext;
    }

    public static IWebContext asWebContext(IContext context) {
        return (IWebContext)context;
    }

    public static IWebExchange getWebExchange(IContext context) {
        return Contexts.asWebContext(context).getExchange();
    }

    public static boolean isServletWebContext(IContext context) {
        return Contexts.isWebContext(context) && Contexts.asWebContext(context).getExchange() instanceof IServletWebExchange;
    }

    public static IServletWebExchange getServletWebExchange(IContext context) {
        return (IServletWebExchange)Contexts.asWebContext(context).getExchange();
    }
}

