/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.ds;

import java.io.Serializable;
import java.sql.SQLException;
import javax.naming.NamingException;
import javax.naming.Reference;
import javax.naming.Referenceable;
import javax.sql.XAConnection;
import javax.sql.XADataSource;
import org.firebirdsql.ds.DataSourceFactory;
import org.firebirdsql.ds.FBAbstractCommonDataSource;
import org.firebirdsql.ds.FBXAConnection;
import org.firebirdsql.gds.impl.GDSFactory;
import org.firebirdsql.gds.impl.GDSType;
import org.firebirdsql.gds.ng.LockCloseable;
import org.firebirdsql.jaybird.xca.FBConnectionRequestInfo;
import org.firebirdsql.jaybird.xca.FBManagedConnection;
import org.firebirdsql.jaybird.xca.FBManagedConnectionFactory;
import org.firebirdsql.jaybird.xca.XcaConnectionEvent;
import org.firebirdsql.jaybird.xca.XcaConnectionEventListener;
import org.firebirdsql.jaybird.xca.XcaConnectionManager;
import org.firebirdsql.jdbc.FBConnection;
import org.firebirdsql.jdbc.FBDataSource;
import org.firebirdsql.jdbc.FirebirdConnection;

public class FBXADataSource
extends FBAbstractCommonDataSource
implements XADataSource,
Referenceable {
    private static final System.Logger LOG = System.getLogger(FBXADataSource.class.getName());
    private volatile FBDataSource internalDs;

    @Override
    public XAConnection getXAConnection() throws SQLException {
        return this.getXAConnection(this.getUser(), this.getPassword());
    }

    @Override
    public XAConnection getXAConnection(String user, String password) throws SQLException {
        if (this.internalDs == null) {
            this.initialize();
        }
        FBConnection connection = (FBConnection)this.internalDs.getConnection(user, password);
        return new FBXAConnection(connection);
    }

    private void initialize() throws SQLException {
        try (LockCloseable ignored = this.withLock();){
            if (this.internalDs != null) {
                return;
            }
            GDSType gdsType = GDSType.getType(this.getType());
            if (gdsType == null) {
                gdsType = GDSFactory.getDefaultGDSType();
            }
            FBManagedConnectionFactory mcf = new FBManagedConnectionFactory(gdsType, this.getConnectionProperties());
            mcf.setDefaultConnectionManager(new XAConnectionManager());
            this.internalDs = (FBDataSource)mcf.createConnectionFactory();
            this.internalDs.setLogWriter(this.getLogWriter());
        }
    }

    @Override
    protected void checkNotStarted() throws IllegalStateException {
        if (this.internalDs != null) {
            throw new IllegalStateException("DataSource already in use. Change of this property is not allowed");
        }
    }

    @Override
    public Reference getReference() throws NamingException {
        Reference ref = new Reference(FBXADataSource.class.getName(), DataSourceFactory.class.getName(), null);
        FBAbstractCommonDataSource.updateReference(ref, this);
        return ref;
    }

    private static class XAConnectionManager
    implements XcaConnectionManager,
    XcaConnectionEventListener,
    Serializable {
        private static final long serialVersionUID = 7926533334548378200L;

        private XAConnectionManager() {
        }

        @Override
        public FirebirdConnection allocateConnection(FBManagedConnectionFactory mcf, FBConnectionRequestInfo cxRequestInfo) throws SQLException {
            FBManagedConnection mc = mcf.createManagedConnection(cxRequestInfo);
            mc.setManagedEnvironment(true);
            mc.addConnectionEventListener(this);
            return mc.getConnection();
        }

        @Override
        public void connectionClosed(XcaConnectionEvent ce) {
            this.destroyConnection(ce);
        }

        @Override
        public void connectionErrorOccurred(XcaConnectionEvent ce) {
            this.destroyConnection(ce);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void destroyConnection(XcaConnectionEvent ce) {
            FBManagedConnection mc = ce.getSource();
            try {
                mc.destroy(ce);
            }
            catch (SQLException e) {
                LOG.log(System.Logger.Level.WARNING, "Ignored exception closing unmanaged connection", (Throwable)e);
            }
            finally {
                mc.removeConnectionEventListener(this);
            }
        }
    }
}

