/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.ermodel.implementation;

import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;
import schemacrawler.ermodel.model.ERModel;
import schemacrawler.ermodel.model.Entity;
import schemacrawler.ermodel.model.EntitySubtype;
import schemacrawler.ermodel.model.EntityType;
import schemacrawler.ermodel.model.Relationship;
import schemacrawler.ermodel.model.RelationshipCardinality;
import schemacrawler.schema.NamedObjectKey;
import schemacrawler.schema.Table;
import schemacrawler.schema.TableReference;

public class MutableERModel
implements ERModel {
    private static final long serialVersionUID = -1912075263587495283L;
    private static final EnumSet<EntityType> VALID_ENTITY_TYPES = EnumSet.of(EntityType.strong_entity, EntityType.weak_entity, EntityType.subtype);
    private final Map<NamedObjectKey, Table> tablesMap = new HashMap<NamedObjectKey, Table>();
    private final Map<NamedObjectKey, Entity> entitiesMap = new HashMap<NamedObjectKey, Entity>();
    private final Map<NamedObjectKey, Relationship> relationshipsMap = new HashMap<NamedObjectKey, Relationship>();
    private final Map<NamedObjectKey, Relationship> weakRelationshipsMap = new HashMap<NamedObjectKey, Relationship>();

    @Override
    public Collection<Entity> getEntities() {
        return List.copyOf(this.entitiesMap.values().stream().filter(entity -> VALID_ENTITY_TYPES.contains(entity.getType())).sorted().toList());
    }

    @Override
    public Collection<Entity> getEntitiesByType(EntityType entityType) {
        if (entityType == null) {
            return Collections.emptySet();
        }
        return List.copyOf(this.entitiesMap.values().stream().filter(entity -> ((EntityType)((Object)((Object)entity.getType()))).equals((Object)entityType)).sorted().toList());
    }

    @Override
    public Collection<Relationship> getRelationships() {
        return List.copyOf(this.relationshipsMap.values().stream().sorted().toList());
    }

    @Override
    public Collection<Relationship> getRelationshipsByType(RelationshipCardinality cardinality) {
        if (cardinality == null) {
            return Collections.emptySet();
        }
        return List.copyOf(this.relationshipsMap.values().stream().filter(relationship -> ((RelationshipCardinality)((Object)((Object)relationship.getType()))).equals((Object)cardinality)).sorted().toList());
    }

    @Override
    public Collection<EntitySubtype> getSubtypesOf(Entity supertype) {
        if (supertype == null) {
            return Collections.emptySet();
        }
        return List.copyOf(this.getSubtypes().stream().filter(subtype -> subtype.getSupertype().equals(supertype)).sorted().toList());
    }

    @Override
    public Collection<Table> getTables() {
        return List.copyOf(this.tablesMap.values().stream().sorted().toList());
    }

    @Override
    public Collection<Table> getUnmodeledTables() {
        return this.tablesMap.keySet().stream().filter(key -> {
            Entity entity = this.entitiesMap.get(key);
            return entity == null || !VALID_ENTITY_TYPES.contains(entity.getType());
        }).filter(Predicate.not(key -> this.relationshipsMap.containsKey(key))).map(key -> this.tablesMap.get(key)).sorted().toList();
    }

    @Override
    public Collection<Relationship> getWeakRelationships() {
        return List.copyOf(this.weakRelationshipsMap.values().stream().sorted().toList());
    }

    @Override
    public Optional<Relationship> lookupByBridgeTable(Table table) {
        if (table == null) {
            return Optional.empty();
        }
        NamedObjectKey key = table.key();
        return this.relationshipsMap.values().stream().filter(relationship -> relationship.key().equals(key)).findFirst();
    }

    @Override
    public Optional<Relationship> lookupByBridgeTableName(String tableName) {
        return this.relationshipsMap.values().stream().filter(relationship -> relationship.getFullName().equals(tableName)).findFirst();
    }

    @Override
    public Optional<Relationship> lookupByTableReference(TableReference tableRef) {
        if (tableRef == null) {
            return Optional.empty();
        }
        return Optional.ofNullable(this.relationshipsMap.get(tableRef.key()));
    }

    @Override
    public Optional<Relationship> lookupByTableReferenceName(String tableRefName) {
        if (tableRefName == null) {
            return Optional.empty();
        }
        return this.relationshipsMap.values().stream().filter(relationship -> relationship.getFullName().equals(tableRefName)).findFirst();
    }

    @Override
    public Optional<Entity> lookupEntity(String entityName) {
        return this.entitiesMap.values().stream().filter(entity -> entity.getFullName().equals(entityName)).findFirst();
    }

    @Override
    public Optional<Entity> lookupEntity(Table table) {
        if (table == null) {
            return Optional.empty();
        }
        NamedObjectKey key = table.key();
        return Optional.ofNullable(this.entitiesMap.get(key));
    }

    void addEntity(Entity entity) {
        if (entity != null) {
            this.entitiesMap.put(entity.key(), entity);
        }
    }

    void addRelationship(Relationship relationship) {
        if (relationship != null) {
            this.relationshipsMap.put(relationship.key(), relationship);
        }
    }

    void addTable(Table table) {
        if (table != null) {
            this.tablesMap.put(table.key(), table);
        }
    }

    void addWeakRelationship(Relationship relationship) {
        if (relationship != null) {
            this.weakRelationshipsMap.put(relationship.key(), relationship);
        }
    }

    private Collection<EntitySubtype> getSubtypes() {
        return this.entitiesMap.values().stream().filter(entity -> EntityType.subtype.equals(entity.getType())).map(entity -> (EntitySubtype)entity).toList();
    }
}

