/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.internal.grpc.xds;

import java.util.concurrent.TimeUnit;
import net.snowflake.client.jdbc.internal.google.common.annotations.VisibleForTesting;
import net.snowflake.client.jdbc.internal.google.common.base.Preconditions;
import net.snowflake.client.jdbc.internal.grpc.CallCredentials;
import net.snowflake.client.jdbc.internal.grpc.CallOptions;
import net.snowflake.client.jdbc.internal.grpc.ChannelCredentials;
import net.snowflake.client.jdbc.internal.grpc.ClientCall;
import net.snowflake.client.jdbc.internal.grpc.Context;
import net.snowflake.client.jdbc.internal.grpc.Grpc;
import net.snowflake.client.jdbc.internal.grpc.ManagedChannel;
import net.snowflake.client.jdbc.internal.grpc.ManagedChannelBuilder;
import net.snowflake.client.jdbc.internal.grpc.Metadata;
import net.snowflake.client.jdbc.internal.grpc.MethodDescriptor;
import net.snowflake.client.jdbc.internal.grpc.Status;
import net.snowflake.client.jdbc.internal.grpc.xds.client.Bootstrapper;
import net.snowflake.client.jdbc.internal.grpc.xds.client.XdsTransportFactory;

final class GrpcXdsTransportFactory
implements XdsTransportFactory {
    private final CallCredentials callCredentials;

    GrpcXdsTransportFactory(CallCredentials callCredentials) {
        this.callCredentials = callCredentials;
    }

    @Override
    public XdsTransportFactory.XdsTransport create(Bootstrapper.ServerInfo serverInfo) {
        return new GrpcXdsTransport(serverInfo, this.callCredentials);
    }

    @VisibleForTesting
    public XdsTransportFactory.XdsTransport createForTest(ManagedChannel channel) {
        return new GrpcXdsTransport(channel, this.callCredentials);
    }

    private static class EventHandlerToCallListenerAdapter<T>
    extends ClientCall.Listener<T> {
        private final XdsTransportFactory.EventHandler<T> handler;

        EventHandlerToCallListenerAdapter(XdsTransportFactory.EventHandler<T> eventHandler) {
            this.handler = Preconditions.checkNotNull(eventHandler, "eventHandler");
        }

        @Override
        public void onHeaders(Metadata headers) {
        }

        @Override
        public void onMessage(T message) {
            this.handler.onRecvMessage(message);
        }

        @Override
        public void onClose(Status status, Metadata trailers) {
            this.handler.onStatusReceived(status);
        }

        @Override
        public void onReady() {
            this.handler.onReady();
        }
    }

    @VisibleForTesting
    static class GrpcXdsTransport
    implements XdsTransportFactory.XdsTransport {
        private final ManagedChannel channel;
        private final CallCredentials callCredentials;

        public GrpcXdsTransport(Bootstrapper.ServerInfo serverInfo) {
            this(serverInfo, null);
        }

        @VisibleForTesting
        public GrpcXdsTransport(ManagedChannel channel) {
            this(channel, null);
        }

        public GrpcXdsTransport(Bootstrapper.ServerInfo serverInfo, CallCredentials callCredentials) {
            String target = serverInfo.target();
            ChannelCredentials channelCredentials = (ChannelCredentials)serverInfo.implSpecificConfig();
            this.channel = ((ManagedChannelBuilder)Grpc.newChannelBuilder(target, channelCredentials).keepAliveTime(5L, TimeUnit.MINUTES)).build();
            this.callCredentials = callCredentials;
        }

        @VisibleForTesting
        public GrpcXdsTransport(ManagedChannel channel, CallCredentials callCredentials) {
            this.channel = Preconditions.checkNotNull(channel, "channel");
            this.callCredentials = callCredentials;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public <ReqT, RespT> XdsTransportFactory.StreamingCall<ReqT, RespT> createStreamingCall(String fullMethodName, MethodDescriptor.Marshaller<ReqT> reqMarshaller, MethodDescriptor.Marshaller<RespT> respMarshaller) {
            Context prevContext = Context.ROOT.attach();
            try {
                XdsStreamingCall<ReqT, RespT> xdsStreamingCall = new XdsStreamingCall<ReqT, RespT>(fullMethodName, reqMarshaller, respMarshaller, this.callCredentials);
                return xdsStreamingCall;
            }
            finally {
                Context.ROOT.detach(prevContext);
            }
        }

        @Override
        public void shutdown() {
            this.channel.shutdown();
        }

        private class XdsStreamingCall<ReqT, RespT>
        implements XdsTransportFactory.StreamingCall<ReqT, RespT> {
            private final ClientCall<ReqT, RespT> call;

            public XdsStreamingCall(String methodName, MethodDescriptor.Marshaller<ReqT> reqMarshaller, MethodDescriptor.Marshaller<RespT> respMarshaller, CallCredentials callCredentials) {
                this.call = GrpcXdsTransport.this.channel.newCall(MethodDescriptor.newBuilder().setFullMethodName(methodName).setType(MethodDescriptor.MethodType.BIDI_STREAMING).setRequestMarshaller(reqMarshaller).setResponseMarshaller(respMarshaller).build(), CallOptions.DEFAULT.withCallCredentials(callCredentials));
            }

            @Override
            public void start(XdsTransportFactory.EventHandler<RespT> eventHandler) {
                this.call.start(new EventHandlerToCallListenerAdapter<RespT>(eventHandler), new Metadata());
                this.call.request(1);
            }

            @Override
            public void sendMessage(ReqT message) {
                this.call.sendMessage(message);
            }

            @Override
            public void startRecvMessage() {
                this.call.request(1);
            }

            @Override
            public void sendError(Exception e) {
                this.call.cancel("Cancelled by XdsClientImpl", e);
            }

            @Override
            public boolean isReady() {
                return this.call.isReady();
            }
        }
    }
}

