/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.internal.google.api.gax.grpc;

import net.snowflake.client.jdbc.internal.google.api.gax.grpc.CallOptionsUtil;
import net.snowflake.client.jdbc.internal.google.api.gax.grpc.GrpcCallContext;
import net.snowflake.client.jdbc.internal.google.api.gax.grpc.ResponseMetadataHandler;
import net.snowflake.client.jdbc.internal.google.api.gax.rpc.ApiCallContext;
import net.snowflake.client.jdbc.internal.google.common.base.Preconditions;
import net.snowflake.client.jdbc.internal.grpc.Metadata;

public class GrpcResponseMetadata
implements ResponseMetadataHandler {
    private volatile Metadata responseMetadata;
    private volatile Metadata trailingMetadata;

    public GrpcCallContext addHandlers(ApiCallContext apiCallContext) {
        if (Preconditions.checkNotNull(apiCallContext) instanceof GrpcCallContext) {
            return this.addHandlers((GrpcCallContext)apiCallContext);
        }
        throw new IllegalArgumentException("context must be an instance of GrpcCallContext, but found " + apiCallContext.getClass().getName());
    }

    public GrpcCallContext createContextWithHandlers() {
        return this.addHandlers(GrpcCallContext.createDefault());
    }

    private GrpcCallContext addHandlers(GrpcCallContext grpcCallContext) {
        return Preconditions.checkNotNull(grpcCallContext).withCallOptions(CallOptionsUtil.putMetadataHandlerOption(grpcCallContext.getCallOptions(), this));
    }

    public Metadata getMetadata() {
        return this.responseMetadata;
    }

    public Metadata getTrailingMetadata() {
        return this.trailingMetadata;
    }

    @Override
    public void onHeaders(Metadata metadata) {
        this.responseMetadata = metadata;
    }

    @Override
    public void onTrailers(Metadata metadata) {
        this.trailingMetadata = metadata;
    }
}

