/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.core.arrow;

import java.math.BigDecimal;
import java.math.BigInteger;
import net.snowflake.client.core.DataConversionContext;
import net.snowflake.client.core.SFException;
import net.snowflake.client.core.arrow.AbstractArrowVectorConverter;
import net.snowflake.client.jdbc.ErrorCode;
import net.snowflake.client.jdbc.SnowflakeType;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.ValueVector;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.complex.StructVector;

class DecfloatToDecimalConverter
extends AbstractArrowVectorConverter {
    private StructVector vector;

    public DecfloatToDecimalConverter(ValueVector vector, int idx, DataConversionContext context) {
        super(SnowflakeType.DECFLOAT.name(), vector, idx, context);
        this.vector = (StructVector)vector;
    }

    @Override
    public BigDecimal toBigDecimal(int index) {
        if (this.isNull(index)) {
            return null;
        }
        Object value = this.vector.getObject(index);
        byte[] significandBytes = (byte[])value.get("significand");
        short exponent = (Short)value.get("exponent");
        BigInteger significand = new BigInteger(significandBytes);
        return new BigDecimal(significand, -exponent);
    }

    @Override
    public double toDouble(int rowIndex) throws SFException {
        if (this.isNull(rowIndex)) {
            return 0.0;
        }
        return this.toBigDecimal(rowIndex).doubleValue();
    }

    @Override
    public float toFloat(int rowIndex) throws SFException {
        if (this.isNull(rowIndex)) {
            return 0.0f;
        }
        return this.toBigDecimal(rowIndex).floatValue();
    }

    @Override
    public short toShort(int rowIndex) throws SFException {
        if (this.isNull(rowIndex)) {
            return 0;
        }
        BigDecimal bigDecimal = this.toBigDecimal(rowIndex);
        if (bigDecimal.scale() == 0) {
            short shortVal = bigDecimal.shortValue();
            if ((long)shortVal == bigDecimal.longValue()) {
                return shortVal;
            }
            throw new SFException(ErrorCode.INVALID_VALUE_CONVERT, this.logicalTypeStr, "Short", bigDecimal.toPlainString());
        }
        throw new SFException(ErrorCode.INVALID_VALUE_CONVERT, this.logicalTypeStr, "Short", bigDecimal.toPlainString());
    }

    @Override
    public int toInt(int rowIndex) throws SFException {
        if (this.isNull(rowIndex)) {
            return 0;
        }
        BigDecimal bigDecimal = this.toBigDecimal(rowIndex);
        if (bigDecimal.scale() == 0) {
            int intVal = bigDecimal.intValue();
            if ((long)intVal == bigDecimal.longValue()) {
                return intVal;
            }
            throw new SFException(ErrorCode.INVALID_VALUE_CONVERT, this.logicalTypeStr, "Integer", bigDecimal.toPlainString());
        }
        throw new SFException(ErrorCode.INVALID_VALUE_CONVERT, this.logicalTypeStr, "Integer", bigDecimal.toPlainString());
    }

    @Override
    public long toLong(int rowIndex) throws SFException {
        if (this.isNull(rowIndex)) {
            return 0L;
        }
        BigDecimal bigDecimal = this.toBigDecimal(rowIndex);
        if (bigDecimal.scale() == 0) {
            BigInteger intVal = bigDecimal.toBigIntegerExact();
            if (intVal.bitLength() <= 63) {
                return intVal.longValue();
            }
            throw new SFException(ErrorCode.INVALID_VALUE_CONVERT, this.logicalTypeStr, "Long", bigDecimal.toPlainString());
        }
        throw new SFException(ErrorCode.INVALID_VALUE_CONVERT, this.logicalTypeStr, "Long", bigDecimal.toPlainString());
    }

    @Override
    public Object toObject(int index) throws SFException {
        return this.toBigDecimal(index);
    }

    @Override
    public String toString(int index) throws SFException {
        if (this.isNull(index)) {
            return null;
        }
        return this.toBigDecimal(index).toEngineeringString();
    }

    @Override
    public byte[] toBytes(int index) throws SFException {
        throw new SFException(ErrorCode.INVALID_VALUE_CONVERT, this.logicalTypeStr, "byte array", null);
    }

    @Override
    public boolean toBoolean(int rowIndex) throws SFException {
        throw new SFException(ErrorCode.INVALID_VALUE_CONVERT, this.logicalTypeStr, "boolean", null);
    }
}

