/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.gds.ng.wire.version19;

import java.sql.SQLException;
import java.util.Optional;
import org.firebirdsql.gds.BlobParameterBuffer;
import org.firebirdsql.gds.ng.FbBlob;
import org.firebirdsql.gds.ng.FbTransaction;
import org.firebirdsql.gds.ng.wire.FbWireTransaction;
import org.firebirdsql.gds.ng.wire.InlineBlob;
import org.firebirdsql.gds.ng.wire.InlineBlobCache;
import org.firebirdsql.gds.ng.wire.ProtocolDescriptor;
import org.firebirdsql.gds.ng.wire.WireDatabaseConnection;
import org.firebirdsql.gds.ng.wire.version18.V18Database;

public class V19Database
extends V18Database {
    private final InlineBlobCache blobCache = new InlineBlobCache(this);

    protected V19Database(WireDatabaseConnection connection, ProtocolDescriptor descriptor) {
        super(connection, descriptor);
    }

    protected void registerInlineBlob(FbWireTransaction transaction, InlineBlob inlineBlob) {
        this.blobCache.add(transaction, inlineBlob);
    }

    @Override
    public FbBlob createBlobForInput(FbTransaction transaction, BlobParameterBuffer blobParameterBuffer, long blobId) throws SQLException {
        Optional<InlineBlob> cachedBlob;
        boolean useCache;
        boolean bl = useCache = blobParameterBuffer == null || blobParameterBuffer.isEmpty();
        if (useCache && (cachedBlob = this.blobCache.getAndRemove(transaction, blobId)).isPresent()) {
            return cachedBlob.get();
        }
        return super.createBlobForInput(transaction, blobParameterBuffer, blobId);
    }
}

