/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.internal.google.cloud.storage;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.GatheringByteChannel;
import java.nio.channels.WritableByteChannel;
import net.snowflake.client.jdbc.internal.google.cloud.storage.WritableByteChannelSession;

interface UnbufferedWritableByteChannelSession<ResultT>
extends WritableByteChannelSession<UnbufferedWritableByteChannel, ResultT> {

    public static interface UnbufferedWritableByteChannel
    extends WritableByteChannel,
    GatheringByteChannel {
        @Override
        default public int write(ByteBuffer src) throws IOException {
            return Math.toIntExact(this.write(new ByteBuffer[]{src}, 0, 1));
        }

        @Override
        default public long write(ByteBuffer[] srcs) throws IOException {
            return this.write(srcs, 0, srcs.length);
        }

        default public int writeAndClose(ByteBuffer src) throws IOException {
            return Math.toIntExact(this.writeAndClose(new ByteBuffer[]{src}, 0, 1));
        }

        default public long writeAndClose(ByteBuffer[] srcs) throws IOException {
            return this.writeAndClose(srcs, 0, srcs.length);
        }

        default public long writeAndClose(ByteBuffer[] srcs, int offset, int length) throws IOException {
            long write = this.write(srcs, offset, length);
            this.close();
            return write;
        }
    }
}

