/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.diagnostic;

import java.net.InetSocketAddress;
import java.net.Proxy;
import java.util.regex.Pattern;
import net.snowflake.client.jdbc.diagnostic.SnowflakeEndpoint;
import net.snowflake.client.log.SFLogger;
import net.snowflake.client.log.SFLoggerFactory;

class ProxyConfig {
    private String proxyHost;
    private int proxyPort;
    private String nonProxyHosts;
    private String jvmHttpProxyHost = System.getProperty("http.proxyHost") == null ? "" : System.getProperty("http.proxyHost");
    private String jvmHttpsProxyHost = System.getProperty("https.proxyHost") == null ? "" : System.getProperty("https.proxyHost");
    private int jvmHttpProxyPort = System.getProperty("http.proxyPort") == null ? -1 : Integer.parseInt(System.getProperty("http.proxyPort"));
    private int jvmHttpsProxyPort = System.getProperty("https.proxyPort") == null ? -1 : Integer.parseInt(System.getProperty("https.proxyPort"));
    private String jvmNonProxyHosts = System.getProperty("http.nonProxyHosts") == null ? "" : System.getProperty("http.nonProxyHosts");
    private String finalHttpProxyHost = "";
    private String finalHttpsProxyHost = "";
    private int finalHttpProxyPort = -1;
    private int finalHttpsProxyPort = -1;
    private String finalNonProxyHosts = "";
    private boolean isProxyEnabled = false;
    private boolean isProxyEnabledOnJvm = false;
    private final String JVM_HTTP_PROXY_HOST = "http.proxyHost";
    private final String JVM_HTTPS_PROXY_HOST = "https.proxyHost";
    private final String JVM_HTTP_PROXY_PORT = "http.proxyPort";
    private final String JVM_HTTPS_PROXY_PORT = "https.proxyPort";
    private final String JVM_HTTP_NON_PROXY_HOSTS = "http.nonProxyHosts";
    private static final SFLogger logger = SFLoggerFactory.getLogger(ProxyConfig.class);

    public String getHttpProxyHost() {
        return this.finalHttpProxyHost;
    }

    public String getHttpsProxyHost() {
        return this.finalHttpsProxyHost;
    }

    public int getHttpProxyPort() {
        return this.finalHttpProxyPort;
    }

    public int getHttpsProxyPort() {
        return this.finalHttpsProxyPort;
    }

    public String getNonProxyHosts() {
        return this.finalNonProxyHosts;
    }

    public void setProxyHost(String proxyHost) {
        this.proxyHost = proxyHost;
    }

    public void setProxyPort(int proxyPort) {
        this.proxyPort = proxyPort;
    }

    public void setNonProxyHosts(String nonProxyHosts) {
        this.nonProxyHosts = nonProxyHosts;
    }

    public ProxyConfig(String proxyHost, int proxyPort, String nonProxyHosts) {
        this.proxyHost = proxyHost == null ? "" : proxyHost;
        this.proxyPort = proxyPort;
        this.nonProxyHosts = nonProxyHosts == null ? "" : nonProxyHosts;
        this.resolveProxyConfigurations();
    }

    public ProxyConfig() {
        this(null, -1, null);
    }

    public boolean isProxyEnabled() {
        return this.isProxyEnabled;
    }

    public boolean isProxyEnabledOnJvm() {
        return this.isProxyEnabledOnJvm;
    }

    private void resolveProxyConfigurations() {
        StringBuilder sb = new StringBuilder();
        logger.info("Resolving proxy configurations", new Object[0]);
        sb.append("Proxy Configurations picked up from ");
        if (!this.proxyHost.isEmpty() && this.proxyPort != -1) {
            this.finalHttpProxyHost = this.proxyHost;
            this.finalHttpsProxyHost = this.proxyHost;
            this.finalHttpProxyPort = this.proxyPort;
            this.finalHttpsProxyPort = this.proxyPort;
            this.finalNonProxyHosts = this.nonProxyHosts;
            this.isProxyEnabled = true;
            sb.append("connection parameters:\n");
            sb.append("proxyHost: ").append(this.proxyHost).append("\n");
            sb.append("proxyPort: ").append(this.proxyPort).append("\n");
            sb.append("nonProxyHosts: ").append(this.nonProxyHosts);
        } else if (!this.jvmHttpProxyHost.isEmpty() && this.jvmHttpProxyPort != -1 || !this.jvmHttpsProxyHost.isEmpty() && this.jvmHttpsProxyPort != -1) {
            this.finalHttpProxyHost = this.jvmHttpProxyHost;
            this.finalHttpProxyPort = this.jvmHttpProxyPort;
            this.finalHttpsProxyHost = this.jvmHttpsProxyHost;
            this.finalHttpsProxyPort = this.jvmHttpsProxyPort;
            this.finalNonProxyHosts = this.jvmNonProxyHosts;
            this.isProxyEnabled = true;
            this.isProxyEnabledOnJvm = true;
            sb.append("JVM arguments:\n");
            sb.append("-D").append("http.proxyHost").append("=").append(this.jvmHttpProxyHost).append("\n");
            sb.append("-D").append("http.proxyPort").append("=").append(this.jvmHttpProxyPort).append("\n");
            sb.append("-D").append("https.proxyHost").append("=").append(this.jvmHttpsProxyHost).append("\n");
            sb.append("-D").append("https.proxyPort").append("=").append(this.jvmHttpsProxyPort).append("\n");
        }
        logger.info(sb.toString(), new Object[0]);
    }

    protected boolean isBypassProxy(String hostname) {
        String[] nonProxyHostsArray;
        String nonProxyHosts = this.getNonProxyHosts().replace(".", "\\.").replace("*", ".*");
        for (String i : nonProxyHostsArray = nonProxyHosts.split("\\|")) {
            if (!Pattern.compile(i).matcher(hostname).matches()) continue;
            return true;
        }
        return false;
    }

    public Proxy getProxy(SnowflakeEndpoint endpoint) {
        if (!this.isProxyEnabled || this.isBypassProxy(endpoint.getHost())) {
            return Proxy.NO_PROXY;
        }
        if (endpoint.isSslEnabled()) {
            return this.isHttpsProxyEnabled() ? new Proxy(Proxy.Type.HTTP, new InetSocketAddress(this.finalHttpsProxyHost, this.finalHttpsProxyPort)) : Proxy.NO_PROXY;
        }
        return this.isHttpProxyEnabled() ? new Proxy(Proxy.Type.HTTP, new InetSocketAddress(this.finalHttpProxyHost, this.finalHttpProxyPort)) : Proxy.NO_PROXY;
    }

    private boolean isHttpProxyEnabled() {
        return !this.finalHttpProxyHost.isEmpty() || this.finalHttpProxyPort != -1;
    }

    private boolean isHttpsProxyEnabled() {
        return !this.finalHttpsProxyHost.isEmpty() || this.finalHttpsProxyPort != -1;
    }
}

