\name{RelabelLabelMapFilter}
\alias{RelabelLabelMapFilter}
\title{RelabelLabelMapFilter}
\Rdversion{1.1}
\docType{class}
\description{
This filter relabels the LabelObjects; the new labels are arranged
consecutively with consideration for the background value.
RelabelLabelMapFilter}
\details{
This filter takes the LabelObjects from the input and reassigns them
to the output by calling the PushLabelObject method, which by default,
attempts to reorganize the labels consecutively. The user can assign
an arbitrary value to the background; the filter will assign the
labels consecutively by skipping the background value.
This implementation was taken from the Insight Journal paper: https://www.insight-journal.org/browse/publication/176
Gaetan Lehmann. Biologie du Developpement et de la Reproduction, INRA
de Jouy-en-Josas, France.
See:
ShapeLabelObject , RelabelComponentImageFilter
RelabelLabelMapFilter for the procedural interface
itk::RelabelLabelMapFilter for the Doxygen on the original ITK class.
RelabelLabelMapFilter}
%C++ includes: sitkRelabelLabelMapFilter.h
\section{Methods}{
\describe{
\item{Image Execute(const Image &image1):}{}
\item{Image Execute(Image &&image1):}{
Execute the filter on the input image
}
\item{std::string GetName() const:}{
Name of this class
}
\item{bool GetReverseOrdering() const:}{}
\item{ RelabelLabelMapFilter():}{
Default Constructor that takes no arguments and initializes default
parameters
}
\item{Self ReverseOrderingOff():}{}
\item{Self ReverseOrderingOn():}{
Set the value of ReverseOrdering to true or false respectfully.
}
\item{Self SetReverseOrdering(bool ReverseOrdering):}{}
\item{std::string ToString() const:}{
Print ourselves out
}
\item{ ~RelabelLabelMapFilter():}{
Destructor
}
}
}
