\name{GridImageSource}
\alias{GridImageSource}
\title{GridImageSource}
\Rdversion{1.1}
\docType{class}
\description{
Generate an n-dimensional image of a grid.
GridImageSource}
\details{
GridImageSource generates an image of a grid. From the abstract... "Certain classes
of images find disparate use amongst members of the ITK community for
such purposes as visualization, simulation, testing, etc. Currently
there exists two derived classes from the ImageSource class used for generating specific images for various applications,
viz. RandomImageSource and GaussianImageSource. We propose to add to this set with the class GridImageSource which, obviously enough, produces a grid image. Such images are
useful for visualizing deformation when used in conjunction with the WarpImageFilter, simulating magnetic resonance tagging images, or creating optical
illusions with which to amaze your friends."
The output image may be of any dimension.
Tustison N., Avants B., Gee J. University of Pennsylvania
 This implementation was taken from the Insight Journal paper: https://www.insight-journal.org/browse/publication/140
See:
GridSource for the procedural interface
itk::GridImageSource for the Doxygen on the original ITK class.
GridImageSource}
%C++ includes: sitkGridImageSource.h
\section{Methods}{
\describe{
\item{Image Execute():}{
Execute the filter on the input image
}
\item{std::vector< double > GetDirection() const:}{}
\item{std::vector< double > GetGridOffset() const:}{
Set/Get the grid offset.
}
\item{std::vector< double > GetGridSpacing() const:}{
Set/Get the grid spacing of the peaks.
}
\item{std::string GetName() const:}{
Name of this class
}
\item{std::vector< double > GetOrigin() const:}{}
\item{PixelIDValueEnum GetOutputPixelType() const:}{}
\item{double GetScale() const:}{
Set/Get the scale factor to multiply the true value of the grid.
}
\item{std::vector< double > GetSigma() const:}{
Set/Get the standard deviation of the Gaussians or width of the box
functions.
}
\item{std::vector< unsigned int > GetSize() const:}{}
\item{std::vector< double > GetSpacing() const:}{}
\item{std::vector< bool > GetWhichDimensions() const:}{
Set/Get the dimensions which are gridded.
}
\item{ GridImageSource():}{
Default Constructor that takes no arguments and initializes default
parameters
}
\item{Self SetDirection(std::vector< double > Direction):}{}
\item{Self SetGridOffset(std::vector< double > GridOffset):}{
Set/Get the grid offset.
}
\item{Self SetGridSpacing(std::vector< double > GridSpacing):}{
Set/Get the grid spacing of the peaks.
}
\item{Self SetOrigin(std::vector< double > Origin):}{}
\item{Self SetOutputPixelType(PixelIDValueEnum OutputPixelType):}{}
\item{Self SetScale(double Scale):}{
Set/Get the scale factor to multiply the true value of the grid.
}
\item{Self SetSigma(double value):}{
Set the values of the Sigma vector all to value
}
\item{Self SetSigma(std::vector< double > Sigma):}{
Set/Get the standard deviation of the Gaussians or width of the box
functions.
}
\item{Self SetSize(std::vector< unsigned int > Size):}{}
\item{Self SetSpacing(std::vector< double > Spacing):}{}
\item{Self SetWhichDimensions(std::vector< bool > WhichDimensions):}{
Set/Get the dimensions which are gridded.
}
\item{std::string ToString() const:}{
Print ourselves out
}
\item{ ~GridImageSource():}{
Destructor
}
}
}
