/*
 * Decompiled with CFR 0.152.
 */
package git4idea.util;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Clock;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.VcsNotifier;
import com.intellij.openapi.vcs.history.VcsRevisionNumber;
import com.intellij.openapi.vcs.merge.MergeDialogCustomizer;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.text.DateFormatUtil;
import com.intellij.xml.util.XmlStringUtil;
import git4idea.commands.Git;
import git4idea.config.GitSaveChangesPolicy;
import git4idea.i18n.GitBundle;
import git4idea.merge.GitConflictResolver;
import git4idea.stash.GitChangesSaver;
import git4idea.util.GitFreezingProcess;
import java.util.Collection;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GitPreservingProcess {
    private static final Logger LOG = Logger.getInstance(GitPreservingProcess.class);
    @NotNull
    private final Project myProject;
    @NotNull
    private final Git myGit;
    @NotNull
    private final Collection<? extends VirtualFile> myRootsToSave;
    @NotNull
    @Nls
    private final String myOperationTitle;
    @NotNull
    @Nls
    private final String myDestinationName;
    @NotNull
    private final ProgressIndicator myProgressIndicator;
    @NotNull
    private final Runnable myOperation;
    @NotNull
    @Nls
    private final String myStashMessage;
    @NotNull
    private final GitChangesSaver mySaver;
    @NotNull
    private final AtomicBoolean myLoaded;

    public GitPreservingProcess(@NotNull Project project, @NotNull Git git, @NotNull Collection<? extends VirtualFile> rootsToSave, @Nls @NotNull String operationTitle, @Nls @NotNull String destinationName, @NotNull GitSaveChangesPolicy saveMethod, @NotNull ProgressIndicator indicator, @NotNull Runnable operation) {
        if (project == null) {
            GitPreservingProcess.$$$reportNull$$$0(0);
        }
        if (git == null) {
            GitPreservingProcess.$$$reportNull$$$0(1);
        }
        if (rootsToSave == null) {
            GitPreservingProcess.$$$reportNull$$$0(2);
        }
        if (operationTitle == null) {
            GitPreservingProcess.$$$reportNull$$$0(3);
        }
        if (destinationName == null) {
            GitPreservingProcess.$$$reportNull$$$0(4);
        }
        if (saveMethod == null) {
            GitPreservingProcess.$$$reportNull$$$0(5);
        }
        if (indicator == null) {
            GitPreservingProcess.$$$reportNull$$$0(6);
        }
        if (operation == null) {
            GitPreservingProcess.$$$reportNull$$$0(7);
        }
        this(project, git, rootsToSave, operationTitle, destinationName, saveMethod, indicator, true, operation);
    }

    @ApiStatus.Internal
    public GitPreservingProcess(@NotNull Project project, @NotNull Git git, @NotNull Collection<? extends VirtualFile> rootsToSave, @Nls @NotNull String operationTitle, @Nls @NotNull String destinationName, @NotNull GitSaveChangesPolicy saveMethod, @NotNull ProgressIndicator indicator, boolean reportLocalHistoryActivity, @NotNull Runnable operation) {
        if (project == null) {
            GitPreservingProcess.$$$reportNull$$$0(8);
        }
        if (git == null) {
            GitPreservingProcess.$$$reportNull$$$0(9);
        }
        if (rootsToSave == null) {
            GitPreservingProcess.$$$reportNull$$$0(10);
        }
        if (operationTitle == null) {
            GitPreservingProcess.$$$reportNull$$$0(11);
        }
        if (destinationName == null) {
            GitPreservingProcess.$$$reportNull$$$0(12);
        }
        if (saveMethod == null) {
            GitPreservingProcess.$$$reportNull$$$0(13);
        }
        if (indicator == null) {
            GitPreservingProcess.$$$reportNull$$$0(14);
        }
        if (operation == null) {
            GitPreservingProcess.$$$reportNull$$$0(15);
        }
        this.myLoaded = new AtomicBoolean();
        this.myProject = project;
        this.myGit = git;
        this.myRootsToSave = rootsToSave;
        this.myOperationTitle = operationTitle;
        this.myDestinationName = destinationName;
        this.myProgressIndicator = indicator;
        this.myOperation = operation;
        this.myStashMessage = VcsBundle.message((String)"stash.changes.message.with.date", (Object[])new Object[]{StringUtil.capitalize((String)this.myOperationTitle), DateFormatUtil.formatDateTime((long)Clock.getTime())});
        this.mySaver = this.configureSaver(saveMethod, reportLocalHistoryActivity);
    }

    public void execute() {
        this.execute(null);
    }

    public void execute(@Nullable Computable<Boolean> autoLoadDecision) {
        Runnable operation = () -> {
            boolean savedSuccessfully = (Boolean)ProgressManager.getInstance().computeInNonCancelableSection(() -> this.save());
            LOG.debug("save result: " + savedSuccessfully);
            if (savedSuccessfully) {
                try {
                    LOG.debug("running operation");
                    this.myOperation.run();
                    LOG.debug("operation completed.");
                }
                finally {
                    if (autoLoadDecision == null || ((Boolean)autoLoadDecision.compute()).booleanValue()) {
                        LOG.debug("loading");
                        ProgressManager.getInstance().executeNonCancelableSection(() -> this.load());
                    } else {
                        this.mySaver.notifyLocalChangesAreNotRestored(this.myOperationTitle);
                    }
                }
            }
            LOG.debug("finished.");
        };
        new GitFreezingProcess(this.myProject, this.myOperationTitle, operation).execute();
    }

    @NotNull
    private GitChangesSaver configureSaver(final @NotNull GitSaveChangesPolicy saveMethod, boolean reportLocalHistoryActivity) {
        if (saveMethod == null) {
            GitPreservingProcess.$$$reportNull$$$0(16);
        }
        GitChangesSaver saver = GitChangesSaver.getSaver(this.myProject, this.myGit, this.myProgressIndicator, this.myStashMessage, saveMethod, reportLocalHistoryActivity);
        MergeDialogCustomizer mergeDialogCustomizer = new MergeDialogCustomizer(){

            @NotNull
            public String getMultipleFileMergeDescription(@NotNull Collection<VirtualFile> files) {
                if (files == null) {
                    1.$$$reportNull$$$0(0);
                }
                String string = XmlStringUtil.wrapInHtml((CharSequence)GitBundle.message("restore.conflict.dialog.description.label.text", GitPreservingProcess.this.myOperationTitle, XmlStringUtil.wrapInHtmlTag((String)GitPreservingProcess.this.myDestinationName, (String)"code")));
                if (string == null) {
                    1.$$$reportNull$$$0(1);
                }
                return string;
            }

            @NotNull
            public String getLeftPanelTitle(@NotNull VirtualFile file) {
                if (file == null) {
                    1.$$$reportNull$$$0(2);
                }
                String string = saveMethod.selectBundleMessage(GitBundle.message("restore.conflict.diff.dialog.left.stash.title", new Object[0]), GitBundle.message("restore.conflict.diff.dialog.left.shelf.title", new Object[0]));
                if (string == null) {
                    1.$$$reportNull$$$0(3);
                }
                return string;
            }

            @NotNull
            public String getRightPanelTitle(@NotNull VirtualFile file, VcsRevisionNumber revisionNumber) {
                if (file == null) {
                    1.$$$reportNull$$$0(4);
                }
                String string = XmlStringUtil.wrapInHtml((CharSequence)GitBundle.message("restore.conflict.diff.dialog.right.title", XmlStringUtil.wrapInHtmlTag((String)GitPreservingProcess.this.myDestinationName, (String)"b")));
                if (string == null) {
                    1.$$$reportNull$$$0(5);
                }
                return string;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 3;
                    case 1, 3, 5 -> 2;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "files";
                        break;
                    }
                    case 1: 
                    case 3: 
                    case 5: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "git4idea/util/GitPreservingProcess$1";
                        break;
                    }
                    case 2: 
                    case 4: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "file";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "git4idea/util/GitPreservingProcess$1";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getMultipleFileMergeDescription";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getLeftPanelTitle";
                        break;
                    }
                    case 5: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getRightPanelTitle";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "getMultipleFileMergeDescription";
                        break;
                    }
                    case 1: 
                    case 3: 
                    case 5: {
                        break;
                    }
                    case 2: {
                        objectArray = objectArray;
                        objectArray[2] = "getLeftPanelTitle";
                        break;
                    }
                    case 4: {
                        objectArray = objectArray;
                        objectArray[2] = "getRightPanelTitle";
                        break;
                    }
                }
                String string = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalArgumentException(string);
                    case 1, 3, 5 -> new IllegalStateException(string);
                };
            }
        };
        GitConflictResolver.Params params = new GitConflictResolver.Params(this.myProject).setReverse(true).setMergeDialogCustomizer(mergeDialogCustomizer).setErrorNotificationTitle(GitBundle.message("preserving.process.local.changes.not.restored.error.title", new Object[0]));
        saver.setConflictResolverParams(params);
        GitChangesSaver gitChangesSaver = saver;
        if (gitChangesSaver == null) {
            GitPreservingProcess.$$$reportNull$$$0(17);
        }
        return gitChangesSaver;
    }

    private boolean save() {
        String errorMessage = this.mySaver.saveLocalChangesOrError(this.myRootsToSave);
        if (errorMessage == null) {
            return true;
        }
        VcsNotifier.getInstance((Project)this.myProject).notifyError("git.could.not.save.uncommitted.changes", GitBundle.message("save.notification.failed.title", this.myOperationTitle), errorMessage);
        return false;
    }

    public void load() {
        if (this.myLoaded.compareAndSet(false, true)) {
            this.mySaver.load();
        } else {
            LOG.info("The changes were already loaded");
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 17 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "git";
                break;
            }
            case 2: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootsToSave";
                break;
            }
            case 3: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "operationTitle";
                break;
            }
            case 4: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "destinationName";
                break;
            }
            case 5: 
            case 13: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "saveMethod";
                break;
            }
            case 6: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indicator";
                break;
            }
            case 7: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "operation";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "git4idea/util/GitPreservingProcess";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "git4idea/util/GitPreservingProcess";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "configureSaver";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "configureSaver";
                break;
            }
            case 17: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 17 -> new IllegalStateException(string);
        };
    }
}

