/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.fus.reporting.jvm;

import com.jetbrains.fus.reporting.FileHandle;
import com.jetbrains.fus.reporting.FileStorage;
import com.jetbrains.fus.reporting.FileStorageMode;
import com.jetbrains.fus.reporting.jvm.JvmFileHandle;
import java.nio.file.AtomicMoveNotSupportedException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import kotlin.Metadata;
import kotlin.io.path.PathsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0012\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\t\u001a\u00020\nH\u0016J\u0018\u0010\u0011\u001a\u00020\u00122\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0013\u001a\u00020\u0010H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0014"}, d2={"Lcom/jetbrains/fus/reporting/jvm/JvmFileStorage;", "Lcom/jetbrains/fus/reporting/FileStorage;", "workingDir", "Ljava/nio/file/Path;", "(Ljava/nio/file/Path;)V", "getWorkingDir", "()Ljava/nio/file/Path;", "exists", "", "path", "", "openFileHandle", "Lcom/jetbrains/fus/reporting/FileHandle;", "mode", "Lcom/jetbrains/fus/reporting/FileStorageMode;", "read", "", "write", "", "content", "api-jvm-defaults"})
public final class JvmFileStorage
implements FileStorage {
    @NotNull
    private final Path workingDir;

    public JvmFileStorage(@NotNull Path workingDir) {
        Intrinsics.checkNotNullParameter((Object)workingDir, (String)"workingDir");
        this.workingDir = workingDir;
    }

    @NotNull
    public final Path getWorkingDir() {
        return this.workingDir;
    }

    @Override
    @NotNull
    public FileHandle openFileHandle(@NotNull String path, @NotNull FileStorageMode mode) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter((Object)((Object)mode), (String)"mode");
        Path path2 = this.workingDir.resolve(path);
        Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"workingDir.resolve(path)");
        return new JvmFileHandle(path2, mode);
    }

    @Override
    @Nullable
    public byte[] read(@NotNull String path) {
        byte[] byArray;
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        try {
            byArray = Files.readAllBytes(this.workingDir.resolve(path));
        }
        catch (Exception exception) {
            byArray = null;
        }
        return byArray;
    }

    @Override
    public void write(@NotNull String path, @NotNull byte[] content) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter((Object)content, (String)"content");
        Path path2 = this.workingDir.resolve(path);
        Files.createDirectories(path2.getParent(), new FileAttribute[0]);
        Path path3 = path2.getParent();
        Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"path");
        Path tmpFile = Files.createFile(path3.resolve(PathsKt.getName((Path)path2) + ".tmp"), new FileAttribute[0]);
        Object[] objectArray = new OpenOption[]{StandardOpenOption.CREATE};
        Files.write(tmpFile, content, (OpenOption[])objectArray);
        try {
            objectArray = new CopyOption[]{StandardCopyOption.ATOMIC_MOVE, StandardCopyOption.REPLACE_EXISTING};
            Files.move(tmpFile, path2, (CopyOption[])objectArray);
        }
        catch (AtomicMoveNotSupportedException atomicMoveNotSupportedException) {
            CopyOption[] copyOptionArray = new CopyOption[]{StandardCopyOption.REPLACE_EXISTING};
            Files.move(tmpFile, path2, copyOptionArray);
        }
    }

    @Override
    public boolean exists(@NotNull String path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        return Files.exists(this.workingDir.resolve(path), new LinkOption[0]);
    }
}

