/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.dom;

import java.io.Serializable;
import org.apache.batik.dom.AbstractNode;
import org.apache.batik.dom.events.DocumentEventSupport;
import org.apache.batik.dom.events.EventSupport;
import org.apache.batik.dom.util.HashTable;
import org.w3c.dom.DOMImplementation;

public abstract class AbstractDOMImplementation
implements DOMImplementation,
Serializable {
    protected final HashTable features = new HashTable();

    protected void registerFeature(String string, Object object) {
        this.features.put(string.toLowerCase(), object);
    }

    protected AbstractDOMImplementation() {
        this.registerFeature("Core", new String[]{"2.0", "3.0"});
        this.registerFeature("XML", new String[]{"1.0", "2.0", "3.0"});
        this.registerFeature("Events", new String[]{"2.0", "3.0"});
        this.registerFeature("UIEvents", new String[]{"2.0", "3.0"});
        this.registerFeature("MouseEvents", new String[]{"2.0", "3.0"});
        this.registerFeature("TextEvents", "3.0");
        this.registerFeature("KeyboardEvents", "3.0");
        this.registerFeature("MutationEvents", new String[]{"2.0", "3.0"});
        this.registerFeature("MutationNameEvents", "3.0");
        this.registerFeature("Traversal", "2.0");
        this.registerFeature("XPath", "3.0");
    }

    public boolean hasFeature(String string, String string2) {
        Object object;
        if (string == null || string.length() == 0) {
            return false;
        }
        if (string.charAt(0) == '+') {
            string = string.substring(1);
        }
        if ((object = this.features.get(string.toLowerCase())) == null) {
            return false;
        }
        if (string2 == null || string2.length() == 0) {
            return true;
        }
        if (object instanceof String) {
            return string2.equals(object);
        }
        String[] stringArray = (String[])object;
        for (int i = 0; i < stringArray.length; ++i) {
            if (!string2.equals(stringArray[i])) continue;
            return true;
        }
        return false;
    }

    public Object getFeature(String string, String string2) {
        if (this.hasFeature(string, string2)) {
            return this;
        }
        return null;
    }

    public DocumentEventSupport createDocumentEventSupport() {
        return new DocumentEventSupport();
    }

    public EventSupport createEventSupport(AbstractNode abstractNode) {
        return new EventSupport(abstractNode);
    }
}

