/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.shell;

import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.LinkedList;
import java.util.zip.GZIPInputStream;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.AvroFSInput;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileChecksum;
import org.apache.hadoop.fs.FileContext;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathIsDirectoryException;
import org.apache.hadoop.fs.shell.CommandFactory;
import org.apache.hadoop.fs.shell.CommandFormat;
import org.apache.hadoop.fs.shell.FsCommand;
import org.apache.hadoop.fs.shell.PathData;
import org.apache.hadoop.io.DataInputBuffer;
import org.apache.hadoop.io.DataOutputBuffer;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.io.SequenceFile;
import org.apache.hadoop.io.compress.CompressionCodec;
import org.apache.hadoop.io.compress.CompressionCodecFactory;
import org.apache.hadoop.shaded.org.apache.avro.Schema;
import org.apache.hadoop.shaded.org.apache.avro.file.DataFileReader;
import org.apache.hadoop.shaded.org.apache.avro.file.FileReader;
import org.apache.hadoop.shaded.org.apache.avro.file.SeekableInput;
import org.apache.hadoop.shaded.org.apache.avro.generic.GenericDatumReader;
import org.apache.hadoop.shaded.org.apache.avro.generic.GenericDatumWriter;
import org.apache.hadoop.shaded.org.apache.avro.io.DatumReader;
import org.apache.hadoop.shaded.org.apache.avro.io.DatumWriter;
import org.apache.hadoop.shaded.org.apache.avro.io.Encoder;
import org.apache.hadoop.shaded.org.apache.avro.io.EncoderFactory;
import org.apache.hadoop.shaded.org.apache.avro.io.JsonEncoder;
import org.apache.hadoop.util.ReflectionUtils;
import org.apache.hadoop.util.StringUtils;

@InterfaceAudience.Private
@InterfaceStability.Evolving
class Display
extends FsCommand {
    Display() {
    }

    public static void registerCommands(CommandFactory factory) {
        factory.addClass(Cat.class, "-cat");
        factory.addClass(Text.class, "-text");
        factory.addClass(Checksum.class, "-checksum");
    }

    private static void validateInputStreamReadArguments(byte[] dest, int destPos, int destLen) throws IOException {
        if (dest == null) {
            throw new NullPointerException("null destination buffer");
        }
        if (destPos < 0 || destLen < 0 || destLen > dest.length - destPos) {
            throw new IndexOutOfBoundsException(String.format("invalid destination buffer range: destPos = %d, destLen = %d", destPos, destLen));
        }
    }

    protected static class AvroFileInputStream
    extends InputStream {
        private int pos = 0;
        private byte[] buffer = new byte[0];
        private final ByteArrayOutputStream output;
        private final FileReader<?> fileReader;
        private final DatumWriter<Object> writer;
        private final JsonEncoder encoder;
        private final byte[] finalSeparator;

        public AvroFileInputStream(FileStatus status) throws IOException {
            GenericDatumReader reader = new GenericDatumReader();
            FileContext fc = FileContext.getFileContext(new Configuration());
            this.fileReader = DataFileReader.openReader((SeekableInput)new AvroFSInput(fc, status.getPath()), (DatumReader)reader);
            Schema schema = this.fileReader.getSchema();
            this.writer = new GenericDatumWriter(schema);
            this.output = new ByteArrayOutputStream();
            this.encoder = EncoderFactory.get().jsonEncoder(schema, (OutputStream)this.output);
            this.finalSeparator = System.getProperty("line.separator").getBytes(StandardCharsets.UTF_8);
        }

        @Override
        public int read() throws IOException {
            if (this.buffer == null) {
                return -1;
            }
            if (this.pos < this.buffer.length) {
                return this.buffer[this.pos++];
            }
            if (!this.fileReader.hasNext()) {
                this.buffer = null;
                return -1;
            }
            this.writer.write(this.fileReader.next(), (Encoder)this.encoder);
            this.encoder.flush();
            if (!this.fileReader.hasNext() && this.buffer.length > 0) {
                this.output.write(this.finalSeparator);
                this.output.flush();
            }
            this.swapBuffer();
            return this.read();
        }

        @Override
        public int read(byte[] dest, int destPos, int destLen) throws IOException {
            Display.validateInputStreamReadArguments(dest, destPos, destLen);
            if (destLen == 0) {
                return 0;
            }
            if (this.buffer == null) {
                return -1;
            }
            int bytesRead = 0;
            while (destLen > 0 && this.buffer != null) {
                if (this.pos < this.buffer.length) {
                    int copyLen = Math.min(this.buffer.length - this.pos, destLen);
                    System.arraycopy(this.buffer, this.pos, dest, destPos, copyLen);
                    this.pos += copyLen;
                    bytesRead += copyLen;
                    destPos += copyLen;
                    destLen -= copyLen;
                    continue;
                }
                if (this.buffer == this.finalSeparator) {
                    this.buffer = null;
                    continue;
                }
                if (!this.fileReader.hasNext()) {
                    if (this.buffer.length > 0) {
                        this.buffer = this.finalSeparator;
                        this.pos = 0;
                        continue;
                    }
                    this.buffer = null;
                    return -1;
                }
                this.writer.write(this.fileReader.next(), (Encoder)this.encoder);
                this.encoder.flush();
                this.swapBuffer();
            }
            return bytesRead;
        }

        private void swapBuffer() {
            this.pos = 0;
            this.buffer = this.output.toByteArray();
            this.output.reset();
        }

        @Override
        public void close() throws IOException {
            this.fileReader.close();
            this.output.close();
            super.close();
        }
    }

    protected class TextRecordInputStream
    extends InputStream {
        private final SequenceFile.Reader r;
        private Object key;
        private Object val;
        private final DataInputBuffer inbuf;
        private final DataOutputBuffer outbuf;

        public TextRecordInputStream(FileStatus f) throws IOException {
            Path fpath = f.getPath();
            Configuration lconf = Display.this.getConf();
            this.r = new SequenceFile.Reader(lconf, SequenceFile.Reader.file(fpath));
            this.key = ReflectionUtils.newInstance(this.r.getKeyClass(), lconf);
            this.val = ReflectionUtils.newInstance(this.r.getValueClass(), lconf);
            this.inbuf = new DataInputBuffer();
            this.outbuf = new DataOutputBuffer();
        }

        @Override
        public int read() throws IOException {
            int ret;
            if (null == this.inbuf || -1 == (ret = this.inbuf.read())) {
                ret = !this.readNextFromSequenceFile() ? -1 : this.inbuf.read();
            }
            return ret;
        }

        @Override
        public int read(byte[] dest, int destPos, int destLen) throws IOException {
            Display.validateInputStreamReadArguments(dest, destPos, destLen);
            if (destLen == 0) {
                return 0;
            }
            int bytesRead = 0;
            while (destLen > 0) {
                int copyLen = this.inbuf.read(dest, destPos, destLen);
                if (-1 == copyLen) {
                    if (!this.readNextFromSequenceFile()) break;
                    copyLen = this.inbuf.read(dest, destPos, destLen);
                }
                bytesRead += copyLen;
                destPos += copyLen;
                destLen -= copyLen;
            }
            return bytesRead > 0 ? bytesRead : -1;
        }

        @Override
        public void close() throws IOException {
            this.r.close();
            super.close();
        }

        private boolean readNextFromSequenceFile() throws IOException {
            this.key = this.r.next(this.key);
            if (this.key == null) {
                return false;
            }
            this.val = this.r.getCurrentValue(this.val);
            byte[] tmp = this.key.toString().getBytes(StandardCharsets.UTF_8);
            this.outbuf.write(tmp, 0, tmp.length);
            this.outbuf.write(9);
            tmp = this.val.toString().getBytes(StandardCharsets.UTF_8);
            this.outbuf.write(tmp, 0, tmp.length);
            this.outbuf.write(10);
            this.inbuf.reset(this.outbuf.getData(), this.outbuf.getLength());
            this.outbuf.reset();
            return true;
        }
    }

    public static class Checksum
    extends Display {
        public static final String NAME = "checksum";
        public static final String USAGE = "[-v] <src> ...";
        public static final String DESCRIPTION = "Dump checksum information for files that match the file pattern <src> to stdout. Note that this requires a round-trip to a datanode storing each block of the file, and thus is not efficient to run on a large number of files. The checksum of a file depends on its content, block size and the checksum algorithm and parameters used for creating the file.";
        private boolean displayBlockSize;

        @Override
        protected void processOptions(LinkedList<String> args) throws IOException {
            CommandFormat cf = new CommandFormat(1, Integer.MAX_VALUE, "v");
            cf.parse(args);
            this.displayBlockSize = cf.getOpt("v");
        }

        @Override
        protected void processPath(PathData item) throws IOException {
            String outputChecksum;
            if (item.stat.isDirectory()) {
                throw new PathIsDirectoryException(item.toString());
            }
            FileChecksum checksum = item.fs.getFileChecksum(item.path);
            String string = outputChecksum = checksum == null ? "NONE" : String.format("%s\t%s", checksum.getAlgorithmName(), StringUtils.byteToHexString(checksum.getBytes(), 0, checksum.getLength()));
            if (this.displayBlockSize) {
                FileStatus fileStatus = item.fs.getFileStatus(item.path);
                this.out.printf("%s\t%s\tBlockSize=%s%n", item.toString(), outputChecksum, fileStatus != null ? Long.valueOf(fileStatus.getBlockSize()) : "NONE");
            } else {
                this.out.printf("%s\t%s%n", item.toString(), outputChecksum);
            }
        }
    }

    public static class Text
    extends Cat {
        public static final String NAME = "text";
        public static final String USAGE = "[-ignoreCrc] <src> ...";
        public static final String DESCRIPTION = "Takes a source file and outputs the file in text format.\nThe allowed formats are zip and TextRecordInputStream and Avro.";

        @Override
        protected InputStream getInputStream(PathData item) throws IOException {
            short leadBytes;
            FSDataInputStream i = (FSDataInputStream)super.getInputStream(item);
            try {
                leadBytes = i.readShort();
            }
            catch (EOFException e) {
                i.seek(0L);
                return i;
            }
            switch (leadBytes) {
                case 8075: {
                    i.seek(0L);
                    return new GZIPInputStream(i);
                }
                case 21317: {
                    if (i.readByte() == 81) {
                        i.close();
                        return new TextRecordInputStream(item.stat);
                    }
                }
                default: {
                    CompressionCodecFactory cf = new CompressionCodecFactory(this.getConf());
                    CompressionCodec codec = cf.getCodec(item.path);
                    if (codec == null) break;
                    i.seek(0L);
                    return codec.createInputStream(i);
                }
                case 20322: {
                    if (i.readByte() != 106) break;
                    i.close();
                    return new AvroFileInputStream(item.stat);
                }
            }
            i.seek(0L);
            return i;
        }
    }

    public static class Cat
    extends Display {
        public static final String NAME = "cat";
        public static final String USAGE = "[-ignoreCrc] <src> ...";
        public static final String DESCRIPTION = "Fetch all files that match the file pattern <src> and display their content on stdout.\n";
        private boolean verifyChecksum = true;

        @Override
        protected void processOptions(LinkedList<String> args) throws IOException {
            CommandFormat cf = new CommandFormat(1, Integer.MAX_VALUE, "ignoreCrc");
            cf.parse(args);
            this.verifyChecksum = !cf.getOpt("ignoreCrc");
        }

        @Override
        protected void processPath(PathData item) throws IOException {
            if (item.stat.isDirectory()) {
                throw new PathIsDirectoryException(item.toString());
            }
            item.fs.setVerifyChecksum(this.verifyChecksum);
            this.printToStdout(this.getInputStream(item));
        }

        private void printToStdout(InputStream in) throws IOException {
            try {
                IOUtils.copyBytes(in, (OutputStream)this.out, this.getConf(), false);
            }
            finally {
                in.close();
            }
        }

        protected InputStream getInputStream(PathData item) throws IOException {
            return item.openForSequentialIO();
        }
    }
}

