/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.knn.jni;

import com.sun.jna.Platform;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.util.Arrays;
import java.util.Locale;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import oshi.util.platform.mac.SysctlUtil;

public class PlatformUtils {
    private static final Logger logger = LogManager.getLogger(PlatformUtils.class);
    private static volatile Boolean isAVX2Supported;
    private static volatile Boolean isAVX512Supported;
    private static volatile Boolean isAVX512SPRSupported;

    static void reset() {
        isAVX2Supported = null;
        isAVX512Supported = null;
        isAVX512SPRSupported = null;
    }

    public static boolean isAVX2SupportedBySystem() {
        if (isAVX2Supported != null) {
            return isAVX2Supported;
        }
        if (!Platform.isIntel() || Platform.isWindows()) {
            isAVX2Supported = false;
            return isAVX2Supported;
        }
        if (Platform.isMac()) {
            try {
                isAVX2Supported = AccessController.doPrivileged(() -> {
                    String flags = SysctlUtil.sysctl((String)"machdep.cpu.leaf7_features", (String)"empty");
                    return flags.toLowerCase(Locale.ROOT).contains("avx2");
                });
            }
            catch (Exception e) {
                isAVX2Supported = false;
                logger.error("[KNN] Error fetching cpu flags info. [{}]", (Object)e.getMessage(), (Object)e);
            }
        } else if (Platform.isLinux()) {
            String fileName = "/proc/cpuinfo";
            try {
                isAVX2Supported = AccessController.doPrivileged(() -> Files.lines(Paths.get(fileName, new String[0])).filter(s -> s.startsWith("flags")).anyMatch(s -> StringUtils.containsIgnoreCase((CharSequence)s, (CharSequence)"avx2")));
            }
            catch (Exception e) {
                isAVX2Supported = false;
                logger.error("[KNN] Error reading file [{}]. [{}]", (Object)fileName, (Object)e.getMessage(), (Object)e);
            }
        } else {
            isAVX2Supported = false;
        }
        return isAVX2Supported != null ? isAVX2Supported : false;
    }

    public static boolean isAVX512SupportedBySystem() {
        if (isAVX512Supported == null) {
            isAVX512Supported = PlatformUtils.areAVX512FlagsAvailable(new String[]{"avx512f", "avx512cd", "avx512vl", "avx512dq", "avx512bw"});
        }
        return isAVX512Supported;
    }

    public static boolean isAVX512SPRSupportedBySystem() {
        if (isAVX512SPRSupported == null) {
            isAVX512SPRSupported = PlatformUtils.areAVX512FlagsAvailable(new String[]{"avx512_fp16", "avx512_bf16", "avx512_vpopcntdq"});
        }
        return isAVX512SPRSupported;
    }

    private static boolean areAVX512FlagsAvailable(String[] avx512) {
        if (!Platform.isIntel() || Platform.isMac() || Platform.isWindows()) {
            return false;
        }
        if (Platform.isLinux()) {
            String fileName = "/proc/cpuinfo";
            try {
                return AccessController.doPrivileged(() -> {
                    Stream<String> linestream = Files.lines(Paths.get(fileName, new String[0]));
                    String flags = linestream.filter(line -> line.startsWith("flags")).findFirst().orElse("");
                    return Arrays.stream(avx512).allMatch(flags::contains);
                });
            }
            catch (PrivilegedActionException e) {
                logger.error("[KNN] Error reading file [{}]. [{}]", (Object)fileName, (Object)e.getMessage(), (Object)e);
            }
        }
        return false;
    }
}

