/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.knn.index.query;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.PriorityQueue;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.search.TotalHits;
import org.apache.lucene.util.DocIdSetBuilder;
import org.opensearch.knn.index.query.PerLeafResult;

public final class ResultUtil {
    public static void reduceToTopK(List<PerLeafResult> perLeafResults, int k) {
        PriorityQueue<Float> topKMinQueue = new PriorityQueue<Float>(k);
        int count = 0;
        for (PerLeafResult perLeafResult : perLeafResults) {
            count += perLeafResult.getResult().scoreDocs.length;
            for (ScoreDoc scoreDoc : perLeafResult.getResult().scoreDocs) {
                if (topKMinQueue.size() < k) {
                    topKMinQueue.add(Float.valueOf(scoreDoc.score));
                    continue;
                }
                if (topKMinQueue.peek() == null || !(scoreDoc.score > ((Float)topKMinQueue.peek()).floatValue())) continue;
                topKMinQueue.poll();
                topKMinQueue.add(Float.valueOf(scoreDoc.score));
            }
        }
        if (count <= k) {
            return;
        }
        float minScore = topKMinQueue.peek() == null ? -3.4028235E38f : ((Float)topKMinQueue.peek()).floatValue();
        perLeafResults.forEach(results -> {
            ArrayList<ScoreDoc> filteredScoreDocList = new ArrayList<ScoreDoc>();
            for (ScoreDoc scoreDoc : results.getResult().scoreDocs) {
                if (!(scoreDoc.score >= minScore)) continue;
                filteredScoreDocList.add(scoreDoc);
            }
            ScoreDoc[] filteredScoreDoc = filteredScoreDocList.toArray(new ScoreDoc[0]);
            TotalHits totalHits = new TotalHits((long)filteredScoreDoc.length, TotalHits.Relation.EQUAL_TO);
            results.setResult(new TopDocs(totalHits, filteredScoreDoc));
        });
    }

    public static DocIdSetIterator resultMapToDocIds(Map<Integer, Float> resultMap) throws IOException {
        if (resultMap.isEmpty()) {
            return DocIdSetIterator.empty();
        }
        int maxDoc = Collections.max(resultMap.keySet()) + 1;
        return ResultUtil.resultMapToDocIds(resultMap, maxDoc);
    }

    public static DocIdSetIterator resultMapToDocIds(Map<Integer, Float> resultMap, int maxDoc) throws IOException {
        if (resultMap.isEmpty()) {
            return DocIdSetIterator.empty();
        }
        DocIdSetBuilder docIdSetBuilder = new DocIdSetBuilder(maxDoc);
        DocIdSetBuilder.BulkAdder setAdder = docIdSetBuilder.grow(resultMap.size());
        for (int doc : resultMap.keySet()) {
            setAdder.add(doc);
        }
        return docIdSetBuilder.build().iterator();
    }

    public static TopDocs resultMapToTopDocs(Map<Integer, Float> resultMap, int segmentOffset) {
        if (resultMap.isEmpty()) {
            return new TopDocs(new TotalHits(0L, TotalHits.Relation.EQUAL_TO), new ScoreDoc[0]);
        }
        int totalHits = 0;
        ArrayList<ScoreDoc> scoreDocs = new ArrayList<ScoreDoc>();
        ArrayList<Map.Entry<Integer, Float>> topScores = new ArrayList<Map.Entry<Integer, Float>>(resultMap.entrySet());
        topScores.sort(Map.Entry.comparingByValue().reversed());
        for (Map.Entry entry : topScores) {
            ScoreDoc scoreDoc = new ScoreDoc((Integer)entry.getKey() + segmentOffset, ((Float)entry.getValue()).floatValue());
            scoreDocs.add(scoreDoc);
            ++totalHits;
        }
        return new TopDocs(new TotalHits((long)totalHits, TotalHits.Relation.EQUAL_TO), (ScoreDoc[])scoreDocs.toArray(ScoreDoc[]::new));
    }
}

