/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.node;

import java.io.IOException;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.opensearch.common.annotation.PublicApi;
import org.opensearch.common.unit.TimeValue;
import org.opensearch.common.util.set.Sets;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.common.io.stream.Writeable;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.ToXContentFragment;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.node.ResponseCollectorService;

@PublicApi(since="1.0.0")
public class AdaptiveSelectionStats
implements Writeable,
ToXContentFragment {
    private final Map<String, Long> clientOutgoingConnections;
    private final Map<String, ResponseCollectorService.ComputedNodeStats> nodeComputedStats;

    private AdaptiveSelectionStats(Builder builder) {
        this.clientOutgoingConnections = builder.clientOutgoingConnections;
        this.nodeComputedStats = builder.nodeComputedStats;
    }

    @Deprecated
    public AdaptiveSelectionStats(Map<String, Long> clientConnections, Map<String, ResponseCollectorService.ComputedNodeStats> nodeComputedStats) {
        this.clientOutgoingConnections = clientConnections;
        this.nodeComputedStats = nodeComputedStats;
    }

    public AdaptiveSelectionStats(StreamInput in) throws IOException {
        this.clientOutgoingConnections = in.readMap(StreamInput::readString, StreamInput::readLong);
        this.nodeComputedStats = in.readMap(StreamInput::readString, ResponseCollectorService.ComputedNodeStats::new);
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeMap(this.clientOutgoingConnections, StreamOutput::writeString, StreamOutput::writeLong);
        out.writeMap(this.nodeComputedStats, StreamOutput::writeString, (stream, stats) -> stats.writeTo(stream));
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject("adaptive_selection");
        Set allNodeIds = Sets.union(this.clientOutgoingConnections.keySet(), this.nodeComputedStats.keySet());
        for (String nodeId : allNodeIds) {
            builder.startObject(nodeId);
            ResponseCollectorService.ComputedNodeStats stats = this.nodeComputedStats.get(nodeId);
            if (stats != null) {
                long outgoingSearches = this.clientOutgoingConnections.getOrDefault(nodeId, 0L);
                builder.field("outgoing_searches", outgoingSearches);
                builder.field("avg_queue_size", stats.queueSize);
                if (builder.humanReadable()) {
                    builder.field("avg_service_time", new TimeValue((long)stats.serviceTime, TimeUnit.NANOSECONDS).toString());
                }
                builder.field("avg_service_time_ns", (long)stats.serviceTime);
                if (builder.humanReadable()) {
                    builder.field("avg_response_time", new TimeValue((long)stats.responseTime, TimeUnit.NANOSECONDS).toString());
                }
                builder.field("avg_response_time_ns", (long)stats.responseTime);
                builder.field("rank", String.format(Locale.ROOT, "%.1f", stats.rank(outgoingSearches)));
            }
            builder.endObject();
        }
        builder.endObject();
        return builder;
    }

    public Map<String, Long> getOutgoingConnections() {
        return this.clientOutgoingConnections;
    }

    public Map<String, ResponseCollectorService.ComputedNodeStats> getComputedStats() {
        return this.nodeComputedStats;
    }

    public Map<String, Double> getRanks() {
        return this.nodeComputedStats.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> ((ResponseCollectorService.ComputedNodeStats)e.getValue()).rank(this.clientOutgoingConnections.getOrDefault(e.getKey(), 0L))));
    }

    public static class Builder {
        private Map<String, Long> clientOutgoingConnections;
        private Map<String, ResponseCollectorService.ComputedNodeStats> nodeComputedStats;

        public Builder clientOutgoingConnections(Map<String, Long> clientOutgoingConnections) {
            this.clientOutgoingConnections = clientOutgoingConnections;
            return this;
        }

        public Builder nodeComputedStats(Map<String, ResponseCollectorService.ComputedNodeStats> nodeComputedStats) {
            this.nodeComputedStats = nodeComputedStats;
            return this;
        }

        public AdaptiveSelectionStats build() {
            return new AdaptiveSelectionStats(this);
        }
    }
}

