/*
 * Decompiled with CFR 0.152.
 */
package oracle.ucp.common;

import java.sql.SQLException;
import java.util.Hashtable;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Predicate;
import java.util.logging.Level;
import javax.sql.XAConnection;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;
import oracle.ucp.UniversalConnectionPoolException;
import oracle.ucp.common.CoreConnection;
import oracle.ucp.common.ServiceMember;
import oracle.ucp.diagnostics.DiagnosticsCollectorImpl;
import oracle.ucp.util.UCPErrorHandler;
import oracle.ucp.util.Util;
import weblogic.transaction.Transaction;
import weblogic.transaction.TransactionHelper;
import weblogic.transaction.TransactionManager;

public class WLSJTAPlugin {
    static final String CLASS_NAME = WLSJTAPlugin.class.getName();
    public static final boolean jtaWLSEnabled = Util.isJTASupportForWLSEnabled();
    static final Map<Xid, ServiceMember> xaAffinityMap = new ConcurrentHashMap<Xid, ServiceMember>();

    public static void registerXAResource(XAResource xar, String dsName) {
        if (jtaWLSEnabled) {
            try {
                Properties registrationProperties = new Properties();
                registrationProperties.put("weblogic.transaction.registration.type", "dynamic");
                registrationProperties.put("weblogic.transaction.resource.type", "datasource");
                String xarName = dsName + "@" + xar.toString();
                ((TransactionManager)TransactionHelper.getTransactionHelper().getTransactionManager()).registerResource(xarName, xar, (Hashtable)registrationProperties);
                DiagnosticsCollectorImpl.getCommon().trace(Level.FINEST, CLASS_NAME, "registerXAResource", "##### Successfully registered XAResource: {0}", null, null, xar);
            }
            catch (Exception exc) {
                DiagnosticsCollectorImpl.getCommon().trace(Level.WARNING, CLASS_NAME, "registerXAResource", "##### Failed to register XAResource", null, exc, new Object[0]);
            }
        }
    }

    public static ServiceMember getXAInstance() {
        if (jtaWLSEnabled) {
            Transaction tx = (Transaction)TransactionHelper.getTransactionHelper().getTransaction();
            DiagnosticsCollectorImpl.getCommon().trace(Level.FINEST, CLASS_NAME, "getXAInstance", "##### Got XA-transaction from WLS: {0}", null, null, tx);
            if (tx != null) {
                ServiceMember inst = xaAffinityMap.get(tx.getXid());
                DiagnosticsCollectorImpl.getCommon().trace(Level.FINEST, CLASS_NAME, "getXAInstance", "##### Got instance from XA-affinity-map: {0}", null, null, inst);
                return inst;
            }
        }
        return null;
    }

    static final Predicate<CoreConnection> xaAffSelector() {
        if (jtaWLSEnabled) {
            ServiceMember xaInstance = WLSJTAPlugin.getXAInstance();
            return conn -> xaInstance == null || xaInstance.equals(conn.serviceMember());
        }
        return p -> true;
    }

    public static void enlistXAResource(XAConnection xaconn) throws SQLException {
        if (jtaWLSEnabled) {
            Transaction tx = (Transaction)TransactionHelper.getTransactionHelper().getTransaction();
            DiagnosticsCollectorImpl.getCommon().trace(Level.FINEST, CLASS_NAME, "enlistXAResource", "##### Successfully got Transaction object from WLS: {0}", null, null, tx);
            if (tx != null) {
                XAResource xar = xaconn.getXAResource();
                WLSJTAPlugin.enlist(tx, xar);
            }
        }
    }

    public static void enlistXAResource(XAResource xar) throws SQLException {
        if (jtaWLSEnabled) {
            Transaction tx = (Transaction)TransactionHelper.getTransactionHelper().getTransaction();
            DiagnosticsCollectorImpl.getCommon().trace(Level.FINEST, CLASS_NAME, "enlistXAResource", "##### Successfully got Transaction object from WLS: {0}", null, null, tx);
            if (tx != null) {
                WLSJTAPlugin.enlist(tx, xar);
            }
        }
    }

    private static void enlist(Transaction tx, XAResource xar) throws SQLException {
        SQLException se = null;
        try {
            Map nullEnlistProps = null;
            tx.enlistResourceWithProperties(xar, nullEnlistProps);
            DiagnosticsCollectorImpl.getCommon().trace(Level.FINEST, CLASS_NAME, "enlist", "##### Successfully enlisted XAResource with WLS: {0}", null, null, xar);
        }
        catch (Exception ex) {
            DiagnosticsCollectorImpl.getCommon().trace(Level.WARNING, CLASS_NAME, "enlist", "##### Failed to enlist XAResource with WLS:", null, ex, new Object[0]);
            se = new SQLException("Unexpected exception: " + ex.getMessage());
        }
        if (se != null) {
            throw se;
        }
    }

    public static void checkXAAffinity(ServiceMember connInstance) throws UniversalConnectionPoolException {
        Transaction tx;
        if (jtaWLSEnabled && (tx = (Transaction)TransactionHelper.getTransactionHelper().getTransaction()) != null) {
            Xid xid = tx.getXid();
            ServiceMember affInst = xaAffinityMap.get(xid);
            if (affInst == null) {
                xaAffinityMap.put(xid, connInstance);
            } else if (affInst.equals(connInstance)) {
                DiagnosticsCollectorImpl.getCommon().trace(Level.FINEST, CLASS_NAME, "checkXAAffinity", "##### Followed XA affinity to instance on WLS: {0}", null, null, connInstance);
            } else {
                DiagnosticsCollectorImpl.getCommon().trace(Level.FINEST, CLASS_NAME, "checkXAAffinity", "##### Violated XA affinity to instance on WLS, affinity instance: {0}, actual instance: {1}", null, null, affInst, connInstance);
                try {
                    tx.rollback();
                    DiagnosticsCollectorImpl.getCommon().trace(Level.FINEST, CLASS_NAME, "checkXAAffinity", "##### Rolled back XA transaction on WLS, xid = {0}", null, null, xid);
                }
                catch (Exception exc) {
                    DiagnosticsCollectorImpl.getCommon().trace(Level.WARNING, CLASS_NAME, "checkXAAffinity", "##### Rolling back XA transaction on WLS got exception:", null, exc, new Object[0]);
                }
                UCPErrorHandler.throwUniversalConnectionPoolException(420);
            }
        }
    }
}

