from typing import Optional

from pydantic import BaseModel
from sqlalchemy import Column, Integer, Double, String, ForeignKey
from sqlalchemy.orm import relationship

from ..base import Base


class RegionAppDxgKernelProfileRanges(Base):
    __tablename__ = 'region_app_dxg_kernel_profile_ranges'
    id = Column(Integer, primary_key=True, index=True)
    frame_duration_pct = Column(Double)
    duration_ms = Column(Double)
    range_count = Column(Integer)
    top_dxg_kernel_profile_event_ranges = Column(String)

    region_id = Column(Integer, ForeignKey('region.id'))
    region = relationship('Region', back_populates='region_app_dxg_kernel_profile_ranges')


class RegionAppDxgKernelProfileRangesInDB(BaseModel):
    frame_duration_pct: float
    duration_ms: float
    range_count: int
    top_dxg_kernel_profile_event_ranges: str

    class Config:
        from_attributes = True


class RegionAppDxgKernelProfileRangesCreate(BaseModel):
    id: Optional[int] = None
    frame_duration_pct: float
    duration_ms: float
    range_count: int
    top_dxg_kernel_profile_event_ranges: str

    class Config:
        from_attributes = True
