/*
 * Decompiled with CFR 0.152.
 */
package org.openoffice.da.comp.w2lcommon.filter;

import java.io.UnsupportedEncodingException;

public class EPSCleaner {
    private byte[] psStart;
    private byte[] psEnd;

    public EPSCleaner() {
        try {
            this.psStart = "%!PS-Adobe".getBytes("US-ASCII");
            this.psEnd = "%%EOF".getBytes("US-ASCII");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
    }

    public byte[] cleanEps(byte[] blob) {
        int n = blob.length;
        int nStart = 0;
        for (int i = 0; i < n; ++i) {
            if (!this.match(blob, this.psStart, i)) continue;
            nStart = i;
            break;
        }
        int nEnd = n;
        for (int i = nStart; i < n; ++i) {
            if (!this.match(blob, this.psEnd, i)) continue;
            nEnd = i + this.psEnd.length;
            break;
        }
        byte[] newBlob = new byte[nEnd - nStart];
        System.arraycopy(blob, nStart, newBlob, 0, nEnd - nStart);
        return newBlob;
    }

    private boolean match(byte[] blob, byte[] sig, int nStart) {
        int n = sig.length;
        if (nStart + n >= blob.length) {
            return false;
        }
        for (int i = 0; i < n; ++i) {
            if (blob[nStart + i] == sig[i]) continue;
            return false;
        }
        return true;
    }
}

