/*
 * Decompiled with CFR 0.152.
 */
package io.lettuce.core.output;

import io.lettuce.core.TransactionResult;
import io.lettuce.core.codec.RedisCodec;
import io.lettuce.core.internal.ExceptionFactory;
import io.lettuce.core.internal.LettuceFactories;
import io.lettuce.core.output.CommandOutput;
import io.lettuce.core.output.DefaultTransactionResult;
import io.lettuce.core.protocol.RedisCommand;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.Queue;

public class MultiOutput<K, V>
extends CommandOutput<K, V, TransactionResult> {
    private final Queue<RedisCommand<K, V, ?>> queue;
    private List<Object> responses = new ArrayList<Object>();
    private Boolean discarded;
    private Integer multi;

    public MultiOutput(RedisCodec<K, V> codec) {
        super(codec, null);
        this.queue = LettuceFactories.newSpScQueue();
    }

    public void add(RedisCommand<K, V, ?> cmd) {
        this.queue.add(cmd);
    }

    public void cancel() {
        for (RedisCommand redisCommand : this.queue) {
            redisCommand.complete();
        }
    }

    @Override
    public void set(long integer) {
        RedisCommand<K, V, ?> command = this.queue.peek();
        if (command != null && command.getOutput() != null) {
            command.getOutput().set(integer);
        }
    }

    @Override
    public void setSingle(ByteBuffer bytes) {
        RedisCommand<K, V, ?> command = this.queue.peek();
        if (command != null && command.getOutput() != null) {
            command.getOutput().setSingle(bytes);
        }
    }

    @Override
    public void setBigNumber(ByteBuffer bytes) {
        RedisCommand<K, V, ?> command = this.queue.peek();
        if (command != null && command.getOutput() != null) {
            command.getOutput().setBigNumber(bytes);
        }
    }

    @Override
    public void set(double number) {
        RedisCommand<K, V, ?> command = this.queue.peek();
        if (command != null && command.getOutput() != null) {
            command.getOutput().set(number);
        }
    }

    @Override
    public void set(ByteBuffer bytes) {
        if (this.multi == null && bytes == null) {
            this.discarded = true;
            return;
        }
        RedisCommand<K, V, ?> command = this.queue.peek();
        if (command != null && command.getOutput() != null) {
            command.getOutput().set(bytes);
        }
    }

    @Override
    public void multi(int count) {
        if (this.multi == null) {
            this.multi = count;
        }
        if (this.discarded == null) {
            this.discarded = count == -1;
        } else if (!this.queue.isEmpty()) {
            this.queue.peek().getOutput().multi(count);
        }
    }

    @Override
    public void setError(ByteBuffer error) {
        if (this.discarded == null) {
            super.setError(error);
            return;
        }
        MultiOutput output = this.queue.isEmpty() ? this : this.queue.peek().getOutput();
        output.setError(this.decodeString(error));
    }

    @Override
    public void complete(int depth) {
        RedisCommand<K, V, ?> cmd;
        if (this.queue.isEmpty()) {
            return;
        }
        if (depth >= 1) {
            cmd = this.queue.peek();
            cmd.getOutput().complete(depth - 1);
        }
        if (depth == 1) {
            cmd = this.queue.remove();
            CommandOutput<K, V, ?> commandOutput = cmd.getOutput();
            this.responses.add(!commandOutput.hasError() ? commandOutput.get() : ExceptionFactory.createExecutionException(commandOutput.getError()));
            cmd.complete();
        } else if (depth == 0 && !this.queue.isEmpty()) {
            for (RedisCommand redisCommand : this.queue) {
                redisCommand.complete();
            }
        }
    }

    @Override
    public TransactionResult get() {
        return new DefaultTransactionResult(this.discarded == null ? false : this.discarded, this.responses);
    }
}

