/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.server;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Predicate;
import org.jetbrains.annotations.NotNull;
import org.languagetool.AnalyzedSentence;
import org.languagetool.Tag;
import org.languagetool.rules.Category;
import org.languagetool.rules.CategoryId;
import org.languagetool.rules.ITSIssueType;
import org.languagetool.rules.Rule;
import org.languagetool.rules.RuleMatch;

class ResultExtender {
    ResultExtender() {
    }

    @NotNull
    static List<RuleMatch> getAsHiddenMatches(List<RuleMatch> matches, List<RuleMatch> extensionMatches) {
        ArrayList<RuleMatch> filteredExtMatches = new ArrayList<RuleMatch>();
        for (RuleMatch extensionMatch : extensionMatches) {
            Rule rule = extensionMatch.getRule();
            Predicate<RuleMatch> touchedByMatch = m -> extensionMatch.getFromPos() <= m.getToPos() && extensionMatch.getToPos() >= m.getFromPos();
            if (!matches.stream().noneMatch(touchedByMatch)) continue;
            AnalyzedSentence sentence = extensionMatch.getSentence();
            String issueType = null;
            if (rule.getLocQualityIssueType() != null) {
                issueType = rule.getLocQualityIssueType().toString();
            }
            String categoryId = rule.getCategory().getId().toString();
            String categoryName = rule.getCategory().getName();
            HiddenRule hiddenRule = new HiddenRule(categoryId, categoryName, issueType, rule.getTags(), rule.estimateContextForSureMatch());
            RuleMatch hiddenRuleMatch = new RuleMatch((Rule)hiddenRule, sentence, extensionMatch.getFromPos(), extensionMatch.getToPos(), "(hidden message)");
            filteredExtMatches.add(hiddenRuleMatch);
        }
        return filteredExtMatches;
    }

    static class HiddenRule
    extends Rule {
        final String categoryId;
        final String categoryName;
        final ITSIssueType itsType;
        final int estimatedContextForSureMatch;
        final List<Tag> tags;

        HiddenRule(String categoryId, String categoryName, String type, List<Tag> tags, int estimatedContextForSureMatch) {
            this.categoryId = categoryId;
            this.categoryName = categoryName;
            this.itsType = type != null ? ITSIssueType.getIssueType((String)type) : ITSIssueType.Uncategorized;
            this.estimatedContextForSureMatch = estimatedContextForSureMatch;
            this.tags = tags;
        }

        @NotNull
        public final Category getCategory() {
            return new Category(new CategoryId(this.categoryId), this.categoryName);
        }

        public String getId() {
            return "HIDDEN_RULE";
        }

        public ITSIssueType getLocQualityIssueType() {
            return this.itsType;
        }

        public String getDescription() {
            return "(description hidden)";
        }

        public RuleMatch[] match(AnalyzedSentence sentence) {
            throw new RuntimeException("not implemented");
        }

        public int estimateContextForSureMatch() {
            return this.estimatedContextForSureMatch;
        }

        @NotNull
        public List<Tag> getTags() {
            return this.tags == null ? Collections.emptyList() : this.tags;
        }
    }
}

