/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.predicate;

import io.undertow.predicate.Predicate;
import io.undertow.predicate.PredicateBuilder;
import io.undertow.predicate.Predicates;
import io.undertow.server.HttpServerExchange;
import java.util.Collections;
import java.util.Map;
import java.util.Set;

public class PathSuffixPredicate
implements Predicate {
    private final String suffix;

    PathSuffixPredicate(String suffix) {
        this.suffix = suffix;
    }

    @Override
    public boolean resolve(HttpServerExchange value) {
        return value.getRelativePath().endsWith(this.suffix);
    }

    public static class Builder
    implements PredicateBuilder {
        @Override
        public String name() {
            return "path-suffix";
        }

        @Override
        public Map<String, Class<?>> parameters() {
            return Collections.singletonMap("path", String[].class);
        }

        @Override
        public Set<String> requiredParameters() {
            return Collections.singleton("path");
        }

        @Override
        public String defaultParameter() {
            return "path";
        }

        @Override
        public Predicate build(Map<String, Object> config) {
            String[] path = (String[])config.get("path");
            return Predicates.suffixes(path);
        }
    }
}

