/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.deployment.dev;

import io.quarkus.bootstrap.app.CuratedApplication;
import io.quarkus.bootstrap.app.QuarkusBootstrap;
import io.quarkus.deployment.dev.CompilationProvider;
import io.quarkus.deployment.dev.DevModeContext;
import io.quarkus.fs.util.FileSystemProviders;
import io.quarkus.maven.dependency.ResolvedDependency;
import io.quarkus.paths.PathCollection;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.regex.Pattern;
import org.jboss.logging.Logger;

public class QuarkusCompiler
implements Closeable {
    private static final Logger log = Logger.getLogger(QuarkusCompiler.class);
    private static final Pattern WHITESPACE_PATTERN = Pattern.compile(" ");
    private final List<CompilationProvider> compilationProviders;
    private final Map<String, CompilationProvider.Context> compilationContexts = new HashMap<String, CompilationProvider.Context>();
    private final Set<String> allHandledExtensions;

    public QuarkusCompiler(CuratedApplication application, List<CompilationProvider> compilationProviders, DevModeContext context) throws IOException {
        Set<File> reloadableClassPathElements;
        this.compilationProviders = compilationProviders;
        HashSet<File> classPathElements = new HashSet<File>();
        for (DevModeContext.ModuleInfo i : context.getAllModules()) {
            if (i.getMain().getClassesPath() != null) {
                classPathElements.add(new File(i.getMain().getClassesPath()));
            }
            if (application.getQuarkusBootstrap().getMode() != QuarkusBootstrap.Mode.TEST || !i.getTest().isPresent()) continue;
            classPathElements.add(new File(i.getTest().get().getClassesPath()));
        }
        HashSet paths = new HashSet();
        HashSet reloadablePaths = new HashSet(0);
        boolean skipReloadableArtifacts = !application.hasReloadableArtifacts();
        for (ResolvedDependency i : application.getApplicationModel().getRuntimeDependencies()) {
            if (skipReloadableArtifacts) {
                paths.addAll(i.getContentTree().getRoots());
                continue;
            }
            if (application.isReloadableArtifact(i.getKey())) {
                reloadablePaths.addAll(i.getContentTree().getRoots());
                continue;
            }
            paths.addAll(i.getContentTree().getRoots());
        }
        String devModeRunnerJarCanonicalPath = context.getDevModeRunnerJarFile() == null ? null : context.getDevModeRunnerJarFile().getCanonicalPath();
        HashSet<String> parsedFiles = new HashSet<String>();
        this.parseClassPath(devModeRunnerJarCanonicalPath, classPathElements, new ArrayDeque<Path>(paths), parsedFiles);
        if (reloadablePaths.isEmpty()) {
            reloadableClassPathElements = Set.of();
        } else {
            reloadableClassPathElements = new HashSet(reloadablePaths.size());
            this.parseClassPath(devModeRunnerJarCanonicalPath, reloadableClassPathElements, new ArrayDeque<Path>(reloadablePaths), parsedFiles);
        }
        for (DevModeContext.ModuleInfo module : context.getAllModules()) {
            this.setupSourceCompilationContext(context, classPathElements, reloadableClassPathElements, module, module.getMain(), "classes");
            if (application.getQuarkusBootstrap().getMode() != QuarkusBootstrap.Mode.TEST || !module.getTest().isPresent()) continue;
            this.setupSourceCompilationContext(context, classPathElements, reloadableClassPathElements, module, module.getTest().get(), "test classes");
        }
        this.allHandledExtensions = new HashSet<String>();
        for (CompilationProvider compilationProvider : compilationProviders) {
            this.allHandledExtensions.addAll(compilationProvider.handledExtensions());
        }
    }

    private void parseClassPath(String devModeRunnerJarCanonicalPath, Set<File> classPathElements, Deque<Path> toParse, Set<String> parsedFiles) throws IOException {
        while (!toParse.isEmpty()) {
            Path path = toParse.poll();
            File file = path.toFile();
            String s = file.getAbsolutePath();
            if (parsedFiles.contains(s)) continue;
            parsedFiles.add(s);
            if (!file.exists()) continue;
            if (path.getFileSystem() == FileSystems.getDefault()) {
                classPathElements.add(file);
                continue;
            }
            if (path.getFileSystem().provider() != FileSystemProviders.ZIP_PROVIDER) continue;
            if (devModeRunnerJarCanonicalPath != null && file.getCanonicalPath().equals(devModeRunnerJarCanonicalPath)) {
                log.debug((Object)("Dev mode runner jar " + String.valueOf(file) + " won't be added to compilation classpath of hot deployment"));
            } else {
                classPathElements.add(file);
            }
            try (JarFile jar = new JarFile(file);){
                Object classPath;
                Manifest mf = jar.getManifest();
                if (mf == null || mf.getMainAttributes() == null || (classPath = mf.getMainAttributes().get(Attributes.Name.CLASS_PATH)) == null) continue;
                for (String classPathEntry : WHITESPACE_PATTERN.split(classPath.toString())) {
                    File f;
                    URI cpEntryURI = new URI(classPathEntry);
                    if (cpEntryURI.isAbsolute() && cpEntryURI.getScheme().equals("file")) {
                        f = new File(cpEntryURI.getPath());
                    } else {
                        try {
                            f = Paths.get(new URI("file", null, "/", null).resolve(cpEntryURI)).toFile();
                        }
                        catch (URISyntaxException e) {
                            f = new File(file.getParentFile(), classPathEntry);
                        }
                    }
                    if (!f.exists()) continue;
                    toParse.add(f.toPath());
                }
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to open class path file " + String.valueOf(file), e);
            }
        }
    }

    public void setupSourceCompilationContext(DevModeContext context, Set<File> classPathElements, Set<File> reloadableClassPathElements, DevModeContext.ModuleInfo i, DevModeContext.CompilationUnit compilationUnit, String name) {
        if (!compilationUnit.getSourcePaths().isEmpty()) {
            if (compilationUnit.getClassesPath() == null) {
                log.warn((Object)("No " + name + " directory found for module '" + i.getName() + "'. It is advised that this module be compiled before launching dev mode"));
                return;
            }
            for (Path sourcePath : compilationUnit.getSourcePaths()) {
                String srcPathStr = sourcePath.toString();
                if (this.compilationContexts.containsKey(srcPathStr)) continue;
                this.compilationContexts.put(srcPathStr, new CompilationProvider.Context(i.getName(), classPathElements, reloadableClassPathElements, i.getProjectDirectory() == null ? null : new File(i.getProjectDirectory()), sourcePath.toFile(), new File(compilationUnit.getClassesPath()), context.getSourceEncoding(), context.getCompilerOptions(), context.getReleaseJavaVersion(), context.getSourceJavaVersion(), context.getTargetJvmVersion(), context.getCompilerPluginArtifacts(), context.getCompilerPluginsOptions(), compilationUnit.getGeneratedSourcesPath() == null ? null : new File(compilationUnit.getGeneratedSourcesPath()), context.getAnnotationProcessorPaths(), context.getAnnotationProcessors(), context.getBuildSystemProperties().getOrDefault("quarkus.live-reload.ignore-module-info", "true")));
            }
        }
    }

    public Set<String> allHandledExtensions() {
        return this.allHandledExtensions;
    }

    public void compile(String sourceDir, Map<String, Set<File>> extensionToChangedFiles) {
        CompilationProvider.Context compilationContext = this.compilationContexts.get(sourceDir);
        block0: for (String extension : extensionToChangedFiles.keySet()) {
            for (CompilationProvider compilationProvider : this.compilationProviders) {
                if (!compilationProvider.handledExtensions().contains(extension)) continue;
                compilationProvider.compile(extensionToChangedFiles.get(extension), compilationContext);
                continue block0;
            }
        }
    }

    public Path findSourcePath(Path classFilePath, PathCollection sourcePaths, String classesPath) {
        for (CompilationProvider compilationProvider : this.compilationProviders) {
            Path sourcePath = compilationProvider.getSourcePath(classFilePath, sourcePaths, classesPath);
            if (sourcePath == null) continue;
            return sourcePath;
        }
        return null;
    }

    @Override
    public void close() throws IOException {
        for (CompilationProvider i : this.compilationProviders) {
            i.close();
        }
    }
}

